<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/Error.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/Error.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Error.m3                                              

<P><PRE>MODULE <module><implements><A HREF="Error.i3">Error</A></implements></module>;

IMPORT <A HREF="M3.i3">M3</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="#x1">M3ID</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="Host.i3">Host</A>, <A HREF="Scanner.i3">Scanner</A>;

TYPE
  Level = [0..3];

TYPE
  IgnoreCell = REF RECORD offs: INTEGER; next: IgnoreCell END;

CONST
  Labels = ARRAY Level OF TEXT {
     &quot;info: &quot;,     (* informational messages *)
     &quot;warning: &quot;,  (* &quot;fussy&quot; warnings *)
     &quot;warning: &quot;,  (* warnings *)
     &quot;&quot;            (* errors *)
  };

VAR
  count   := ARRAY Level OF INTEGER {0, ..};
  spare   : M3Buf.T    := NIL;
  ignores : IgnoreCell := NIL;

PROCEDURE <A NAME="Msg"><procedure>Msg</procedure></A> (msg: TEXT) =
  VAR wr := Header ();
  BEGIN
    Out (wr, msg);
    Trailer (wr);
  END Msg;

PROCEDURE <A NAME="Int"><procedure>Int</procedure></A> (n: INTEGER;  msg: TEXT) =
  VAR wr := Header ();
  BEGIN
    Out (wr, msg);
    Out (wr, &quot; (&quot;);
    Out (wr, Fmt.Int (n));
    Out (wr, &quot;)&quot;);
    Trailer (wr);
  END Int;

PROCEDURE <A NAME="ID"><procedure>ID</procedure></A> (id: M3ID.T;  msg: TEXT) =
  VAR wr := Header ();
  BEGIN
    Out  (wr, msg);
    Out  (wr, &quot; (&quot;);
    OutS (wr, id);
    Out  (wr, &quot;)&quot;);
    Trailer (wr);
  END ID;

PROCEDURE <A NAME="Txt"><procedure>Txt</procedure></A> (id, msg: TEXT) =
  VAR wr := Header ();
  BEGIN
    Out (wr, id);
    Out (wr, &quot;: &quot;);
    Out (wr, msg);
    Trailer (wr);
  END Txt;

PROCEDURE <A NAME="QID"><procedure>QID</procedure></A> (READONLY q: M3.QID;  msg: TEXT) =
  VAR wr := Header ();
  BEGIN
    Out (wr, msg);
    Out (wr, &quot; (&quot;);
    IF (q.module # M3ID.NoID) THEN
      OutS (wr, q.module);
      Out  (wr, &quot;.&quot;);
    END;
    OutS (wr, q.item);
    Out (wr, &quot;)&quot;);
    Trailer (wr);
  END QID;

PROCEDURE <A NAME="Info"><procedure>Info</procedure></A> (msg: TEXT) =
  BEGIN
    IF Toss (FIRST (Level)) THEN RETURN END;
    VAR wr := Header (FIRST (Level)); BEGIN
      Out (wr, msg);
      Trailer (wr);
    END;
  END Info;

PROCEDURE <A NAME="Warn"><procedure>Warn</procedure></A> (level: INTEGER;  msg: TEXT) =
  BEGIN
    IF Toss (level) THEN RETURN END;
    VAR wr := Header (level); BEGIN
      Out (wr, msg);
      Trailer (wr);
    END;
  END Warn;

PROCEDURE <A NAME="WarnID"><procedure>WarnID</procedure></A> (level: INTEGER;  id: M3ID.T;  msg: TEXT) =
  BEGIN
    IF Toss (level) THEN RETURN END;
    VAR wr := Header (level); BEGIN
      Out  (wr, msg);
      Out  (wr, &quot; (&quot;);
      OutS (wr, id);
      Out  (wr, &quot;)&quot;);
      Trailer (wr);
    END;
  END WarnID;

PROCEDURE <A NAME="Header"><procedure>Header</procedure></A> (level: INTEGER := LAST (INTEGER)): M3Buf.T =
  VAR wr: M3Buf.T;
  BEGIN
    IF (spare # NIL)
      THEN wr := spare;  spare := NIL;
      ELSE wr := M3Buf.New ();
    END;
    level := MAX (FIRST (Level), MIN (level, LAST (Level)));
    INC (count[level]);
    Out  (wr, Labels [level]);
    RETURN wr;
  END Header;

PROCEDURE <A NAME="Trailer"><procedure>Trailer</procedure></A> (wr: M3Buf.T) =
  VAR n: INTEGER := 0;  file: TEXT;  line: INTEGER;
  BEGIN
    Scanner.Here (file, line);
    Host.env.report_error (file, line, M3Buf.ToText (wr));
    spare := wr;
    IF (Host.errorDie &gt;= 0) THEN
      FOR i := FIRST (count) TO LAST (count) DO INC (n, count[i]) END;
      IF (n &gt;= Host.errorDie) THEN &lt;* ASSERT FALSE *&gt; END;
    END;
  END Trailer;

PROCEDURE <A NAME="Out"><procedure>Out</procedure></A> (wr: M3Buf.T;  t: TEXT) =
  BEGIN
    IF (t # NIL) THEN M3Buf.PutText (wr, t); END;
  END Out;

PROCEDURE <A NAME="OutS"><procedure>OutS</procedure></A> (wr: M3Buf.T;  id: M3ID.T) =
  BEGIN
    M3ID.Put (wr, id);
  END OutS;

PROCEDURE <A NAME="Count"><procedure>Count</procedure></A> (VAR nErrors, nWarnings: INTEGER) =
  BEGIN
    nErrors := count [LAST (count)];
    nWarnings := 0;
    FOR i := FIRST (count) + 1 TO LAST (count) - 1 DO
      INC (nWarnings, count[i]);
    END;
  END Count;

PROCEDURE <A NAME="IgnoreWarning"><procedure>IgnoreWarning</procedure></A> (offset: INTEGER) =
  BEGIN
    WITH i = NEW (IgnoreCell) DO
      i.offs := offset;
      i.next := ignores;
      ignores := i;
    END;
  END IgnoreWarning;

PROCEDURE <A NAME="Toss"><procedure>Toss</procedure></A> (level: INTEGER): BOOLEAN =
  VAR i: IgnoreCell;  here: INTEGER;
  BEGIN
    IF (level &lt; Host.warnings) THEN RETURN TRUE END;
    here := Scanner.offset;
    i := ignores;
    WHILE (i # NIL) DO
      IF (i.offs = here) THEN RETURN TRUE END;
      i := i.next;
    END;
    RETURN FALSE;
  END Toss;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> () =
  BEGIN
    ignores := NIL;
    FOR i := FIRST (count) TO LAST (count) DO count[i] := 0 END;
  END Reset;

BEGIN
END Error.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
