<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/Host.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/Host.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Host.i3                                               

<P><PRE>INTERFACE <interface><A HREF="Host.m3">Host</A></interface>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../../../os/src/Common/File.i3">File</A>, <A HREF="M3Compiler.i3">M3Compiler</A>;

VAR (* parameters to the top-level compile *)
  filename      : TEXT := NIL;
  source        : File.T;
  env           : M3Compiler.Environment;

VAR (* misc. options *)
  verbose       : BOOLEAN := FALSE; (* =&gt; diagnostic listing of phases *)
  errorDie      : INTEGER := -1;    (* N&gt;=0 =&gt; abort on the Nth error *)
  warnings      : INTEGER := 2;     (* =&gt; ignore levels less than this value *)
  coverage      : BOOLEAN := FALSE; (* =&gt; generate coverage counts *)
  versionStamps : BOOLEAN := TRUE;  (* do emit version stamps *)
  emitBuiltins  : BOOLEAN := FALSE; (* don't compile, emit the builtins *)
  init_floats   : BOOLEAN := FALSE; (* initialize all floats to zero *)
  vs_debug      : BOOLEAN := FALSE; (* print version stamp debugging *)
  load_map      : BOOLEAN := TRUE;  (* print unit's load map as a comment *)
  ext_direct    : BOOLEAN := TRUE;  (* call external procedure directly? *)
  all_direct    : BOOLEAN := FALSE; (* call all procedures directly? *)
  stack_walker  : BOOLEAN := TRUE;  (* use the Target specified stack walker *)

  nested_calls : BOOLEAN := FALSE;
  (* can calls to procedures be nested? *)

  nested_procs_first : BOOLEAN := TRUE;
  (* should nested procedures be generated before or after their parent *)

  inline_nested_procs : BOOLEAN := TRUE;
  (* should the code for nested procedures be generated inline *)

  clean_stores : BOOLEAN := FALSE;
  (* must the stack be empty after every store *)

  clean_jumps : BOOLEAN := TRUE;
  (* must the stack be empty before every jump or call *)

VAR (* runtime checks *)
  doNarrowChk : BOOLEAN := TRUE;
  doRangeChk  : BOOLEAN := TRUE;
  doReturnChk : BOOLEAN := TRUE;
  doCaseChk   : BOOLEAN := TRUE;
  doTCaseChk  : BOOLEAN := TRUE;
  doAsserts   : BOOLEAN := TRUE;
  doNilChk    : BOOLEAN := TRUE;
  doRaisesChk : BOOLEAN := TRUE;

VAR
  new_adr      : BOOLEAN := FALSE;  (* TRUE =&gt;  &quot;ADR (t: T): UNTRACED REF T&quot; *)
  report_stats : BOOLEAN := FALSE;

PROCEDURE <A HREF="Host.m3#Initialize">Initialize</A> (READONLY options: ARRAY OF TEXT): BOOLEAN;

PROCEDURE <A HREF="Host.m3#OpenUnit">OpenUnit</A> (name: M3ID.T; interface, generic: BOOLEAN;
                      VAR(*OUT*) filename: TEXT): File.T;

PROCEDURE <A HREF="Host.m3#CloseFile">CloseFile</A> (rd: File.T);

PROCEDURE <A HREF="Host.m3#FileTail">FileTail</A> (path: TEXT): TEXT;
</PRE><BLOCKQUOTE><EM> returns the tail of 'path' </EM></BLOCKQUOTE><PRE>

END Host.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
