<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/Host.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/Host.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: Host.m3                                               

<P><PRE>MODULE <module><implements><A HREF="Host.i3">Host</A></implements></module>;

IMPORT <A HREF="../../../os/src/Common/File.i3">File</A>, <A HREF="../../../text/src/Text.i3">Text</A>, (*ETimer, M3Timers,*) <A HREF="#x1">M3ID</A>, <A HREF="M3Compiler.i3">M3Compiler</A>;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> (READONLY options: ARRAY OF TEXT): BOOLEAN =
  BEGIN
    verbose       := FALSE;
    errorDie      := -1;
    warnings      := 2;
    coverage      := FALSE;
    versionStamps := TRUE;
    emitBuiltins  := FALSE;
    init_floats   := FALSE;
    vs_debug      := FALSE;
    load_map      := TRUE;
    ext_direct    := TRUE;
    all_direct    := FALSE;
    stack_walker  := TRUE;
    nested_calls        := FALSE;
    nested_procs_first  := FALSE;
    inline_nested_procs := TRUE;
    clean_stores  := FALSE;
    clean_jumps   := TRUE;
    doNarrowChk   := TRUE;
    doRangeChk    := TRUE;
    doReturnChk   := TRUE;
    doCaseChk     := TRUE;
    doTCaseChk    := TRUE;
    doAsserts     := TRUE;
    doNilChk      := TRUE;
    doRaisesChk   := TRUE;
    new_adr       := FALSE;
    report_stats  := FALSE;

    FOR i := 0 TO LAST (options) DO
      IF NOT ProcessArg (options[i]) THEN RETURN FALSE; END;
    END;
    RETURN TRUE;
  END Initialize;
</PRE>------------------------------------------------ command line arguments ---

<P><PRE>PROCEDURE <A NAME="ProcessArg"><procedure>ProcessArg</procedure></A> (t: TEXT): BOOLEAN =
  VAR key: TEXT;
  BEGIN
    IF (t = NIL) THEN RETURN TRUE; END;
    key := Text.Sub (t, 0, 2);
    IF (Text.Equal (t, &quot;-v&quot;)) THEN
      verbose  := TRUE;
      vs_debug := TRUE;
      warnings := -1;
    ELSIF (Text.Equal (key, &quot;-t&quot;)) THEN
      (* ignore the old -tTARGET option which is still in the config files  *)
    ELSIF (Text.Equal (t, &quot;-g&quot;)) THEN
      (* generate debugging, which we always do anyway! *)
    ELSIF (Text.Equal (t, &quot;-S&quot;)) THEN
      versionStamps := FALSE;   (* don't generate version stamps *)
    ELSIF (Text.Equal (t, &quot;-w&quot;)) THEN
      warnings := 99;
    ELSIF (Text.Equal (key, &quot;-w&quot;)) THEN
      warnings := GetInt (t, 2);
    ELSIF (Text.Equal (t, &quot;-builtins&quot;)) THEN
      emitBuiltins := TRUE; (* emit the predefined scopes *)
    ELSIF (Text.Equal (t, &quot;-Z&quot;)) THEN
      coverage := TRUE; (* generate line profiling *)
    ELSIF (Text.Equal (key, &quot;-E&quot;)) THEN
      errorDie := GetInt (t, 2);
    ELSIF (Text.Equal (t, &quot;-NoAsserts&quot;)) THEN
      doAsserts := FALSE;
    ELSIF (Text.Equal (t, &quot;-NoNarrowChk&quot;)) THEN
      doNarrowChk := FALSE;
    ELSIF (Text.Equal (t, &quot;-NoRangeChk&quot;)) THEN
      doRangeChk := FALSE;
    ELSIF (Text.Equal (t, &quot;-NoReturnChk&quot;)) THEN
      doReturnChk := FALSE;
    ELSIF (Text.Equal (t, &quot;-NoCaseChk&quot;)) THEN
      doCaseChk := FALSE;
    ELSIF (Text.Equal (t, &quot;-NoTypecaseChk&quot;)) THEN
      doTCaseChk := FALSE;
    ELSIF (Text.Equal (t, &quot;-NoNilChk&quot;)) THEN
      doNilChk := FALSE;
    ELSIF (Text.Equal (t, &quot;-NoRaisesChk&quot;)) THEN
      doRaisesChk := FALSE;
    ELSIF (Text.Equal (t, &quot;-NoChecks&quot;)) THEN
      doAsserts   := FALSE;
      doNarrowChk := FALSE;
      doRangeChk  := FALSE;
      doReturnChk := FALSE;
      doCaseChk   := FALSE;
      doTCaseChk  := FALSE;
      doNilChk    := FALSE;
      doRaisesChk := FALSE;
    ELSIF (Text.Equal (t, &quot;-InitFloats&quot;)) THEN
      init_floats := TRUE;
    ELSIF (Text.Equal (t, &quot;-load_map&quot;)) THEN
      load_map := TRUE;
    ELSIF (Text.Equal (t, &quot;-No_load_map&quot;)) THEN
      load_map := FALSE;
    ELSIF (Text.Equal (t, &quot;-No_stack_walker&quot;)) THEN
      stack_walker := FALSE;
    ELSIF (Text.Equal (t, &quot;-externals_direct&quot;)) THEN
      ext_direct := TRUE;
    ELSIF (Text.Equal (t, &quot;-externals_indirect&quot;)) THEN
      ext_direct := FALSE;
    ELSIF (Text.Equal (t, &quot;-all_direct&quot;)) THEN
      all_direct := TRUE;
    ELSIF (Text.Equal (t, &quot;-all_indirect&quot;)) THEN
      all_direct := FALSE;
    ELSIF (Text.Equal (t, &quot;-nested_calls&quot;)) THEN
      nested_calls  := TRUE;
    ELSIF (Text.Equal (t, &quot;-no_nested_calls&quot;)) THEN
      nested_calls  := FALSE;
    ELSIF (Text.Equal (t, &quot;-nested_procs_first&quot;)) THEN
      (* nested_procs_first := TRUE; *)
      (* THIS IS BOGUS:  nested_procs_first =&gt; the nested procedure
         cannot reference local variables of its parent that
         weren't declared at the outermost level.  *)
    ELSIF (Text.Equal (t, &quot;-nested_procs_last&quot;)) THEN
      nested_procs_first := FALSE;
    ELSIF (Text.Equal (t, &quot;-inline_nested_procs&quot;)) THEN
      inline_nested_procs := TRUE;
    ELSIF (Text.Equal (t, &quot;-unfold_nested_procs&quot;)) THEN
      inline_nested_procs := FALSE;
    ELSIF (Text.Equal (t, &quot;-clean_stores&quot;)) THEN
      clean_stores  := TRUE;
    ELSIF (Text.Equal (t, &quot;-dirty_stores&quot;)) THEN
      clean_stores  := FALSE;
    ELSIF (Text.Equal (t, &quot;-clean_jumps&quot;)) THEN
      clean_jumps   := TRUE;
    ELSIF (Text.Equal (t, &quot;-dirty_jumps&quot;)) THEN
      clean_jumps   := FALSE;
    ELSIF (Text.Equal (t, &quot;-vsdebug&quot;)) THEN
      vs_debug := TRUE;
    ELSIF (Text.Equal (t, &quot;-new_adr&quot;)) THEN
      new_adr := TRUE;
    ELSIF (Text.Equal (t, &quot;-stats&quot;)) THEN
      report_stats := TRUE;
    ELSE
      env.report_error (NIL, 0, &quot;m3c: unknown option, \&quot;&quot; &amp; t &amp; &quot;\&quot;&quot;);
      RETURN FALSE;
    END;
    RETURN TRUE;
  END ProcessArg;

PROCEDURE <A NAME="GetInt"><procedure>GetInt</procedure></A> (t: TEXT;  start: INTEGER): INTEGER =
  VAR c: CHAR;  n: INTEGER := 0;
  BEGIN
    FOR j := start TO Text.Length (t)-1 DO
      c := Text.GetChar (t, j);
      IF (c &lt; '0') OR ('9' &lt; c) THEN RETURN n END;
      n := n * 10 + ORD (c) - ORD ('0');
    END;
    RETURN n;
  END GetInt;
</PRE>-------------------------------------------------- misc file operations ---

<P><PRE>PROCEDURE <A NAME="OpenUnit"><procedure>OpenUnit</procedure></A> (name: M3ID.T; interface, generic: BOOLEAN;
                                  VAR(*OUT*) filename: TEXT): File.T =
  VAR file: M3Compiler.SourceFile;
  BEGIN
    (* ETimer.Push (M3Timers.search); *)
    file := env.find_source (name, interface, generic);
    filename := file.name;
    (* ETimer.Pop (); *)
    RETURN file.contents;
  END OpenUnit;

PROCEDURE <A NAME="CloseFile"><procedure>CloseFile</procedure></A> (rd: File.T) =
  BEGIN
    IF (rd # NIL) THEN
      TRY rd.close () EXCEPT ELSE END;
    END;
  END CloseFile;

PROCEDURE <A NAME="FileTail"><procedure>FileTail</procedure></A> (path: TEXT): TEXT =
  VAR c: CHAR;
  BEGIN
    IF (path = NIL) THEN RETURN NIL END;

    (* search for the last slash or blank in the string *)
    FOR x := Text.Length (path) - 1 TO 0 BY -1 DO
      c := Text.GetChar (path, x);
      IF (c = '/') OR (c = ' ') OR (c = '\\') THEN
        RETURN Text.Sub (path, x+1);
      END;
    END;

    (* no slashes *)
    RETURN path;
  END FileTail;

BEGIN
END Host.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
