<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/M3.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/M3.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: M3.i3                                                 

<P> This interface defines some base object types so that circular
   dependencies between other interfaces may be avoided. 

<P><PRE>INTERFACE <interface><A HREF="M3.m3">M3</A></interface>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>;

TYPE
  Flag = BITS 1 FOR BOOLEAN;

  QID  = RECORD module, item: M3ID.T; END;
</PRE>------------------------------------------------------------- AST nodes ---

<P><PRE>TYPE
  Node      = OBJECT origin: INTEGER END;
  ValueNode = Node OBJECT next: Value := NIL END;

TYPE
  <A HREF="Scope.m3#Scope">Scope</A>     &lt;: Node;      (* == Scope.T *)
  <A HREF="../stmts/StmtRep.i3#Stmt">Stmt</A>      &lt;: Node;      (* == Stmt.T  *)
  <A HREF="../exprs/ExprRep.i3#Expr">Expr</A>      &lt;: Node;      (* == Expr.T  *)
  Value     &lt;: ValueNode; (* == Value.T *)
  <A HREF="../types/TypeRep.i3#Type">Type</A>      &lt;: Node;      (* == Type.T  *)
  <A HREF="ESet.m3#ExSet">ExSet</A>     &lt;: Node;      (* == ESet.T  *)
  <A HREF="ESet.m3#ExSetList">ExSetList</A> &lt;: REFANY;    (* == list of ExSet *)
</PRE>--------------------------------------------------------- type checking ---

<P><PRE>TYPE (* the &quot;global state&quot; that is passed around during type checking *)
  CheckState = RECORD
    raises_others : BOOLEAN;
    ok_to_raise   : ExSetList;
    no_error      : ExSetList;
    int_ops       : INTEGER;
    fp_ops        : INTEGER;
    div_ops       : INTEGER;
  END;

CONST
  OuterCheckState = CheckState {
    raises_others := FALSE,
    ok_to_raise   := NIL,
    no_error      := NIL,
    int_ops       := 0,
    fp_ops        := 0,
    div_ops       := 0
  };
</PRE>-------------------------------------------------------- fingerprinting ---

<P><PRE>TYPE
  FPInfo = RECORD
    tag     : TEXT;
    buf     : M3Buf.T;
    n_nodes : INTEGER;
    nodes   : ARRAY [0..5] OF Type;
    others  : REF ARRAY OF Type;
  END;
  (* &quot;fp&quot; methods must either assign a non-NIL value to &quot;tag&quot;
     or build a string in &quot;buf&quot;.  They must also set &quot;n_nodes&quot; and
     either &quot;nodes&quot; or &quot;others&quot;.  If &quot;n_nodes &lt;= NUMBER (nodes)&quot;,
     &quot;nodes&quot; must be used, otherwise &quot;others&quot; is used. *)

END M3.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
