<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/M3Compiler.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/M3Compiler.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: M3Compiler.i3                                         

<P><PRE>INTERFACE <interface><A HREF="M3Compiler.m3">M3Compiler</A></interface>;
</PRE> This module defines the front-end interface of the Modula-3
   compiler.  The compiler is a monitor -- only one compilation
   can be active at a time.


<P><PRE>IMPORT <A HREF="../../../os/src/Common/File.i3">File</A>, <A HREF="../../../fingerprint/src/Fingerprint.i3">Fingerprint</A>;
IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../../../m3middle/src/M3CG.i3">M3CG</A>;

PROCEDURE <A HREF="M3Compiler.m3#ParseImports">ParseImports</A> (READONLY input : SourceFile;
                                 env   : Environment): IDList;
</PRE><BLOCKQUOTE><EM> Returns the names of the interfaces directly imported by 'input'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Compiler.m3#Compile">Compile</A> (READONLY input    : SourceFile;
                            env      : Environment;
                   READONLY options  : ARRAY OF TEXT): BOOLEAN;
</PRE> Reads and compiles a Modula-3 unit from <CODE>input</CODE>.
   Evironmental queries and reports are made through <CODE>env</CODE>.
   The listing and diagnostic options of the compiler are set by <CODE>options</CODE>.
   Returns <CODE>TRUE</CODE> iff the compilation succeeded with no errors.
   It is the caller's responsibility to initialize the Target interface
   prior to calling Compile. 

<P><PRE>TYPE
  TypeID     = INTEGER;  (* A compiler generated type id. *)
  SourceFile = RECORD  name: TEXT;  contents: File.T  END;
  IDList     = REF RECORD interface: M3ID.T;  next: IDList  END;

TYPE
  Environment = OBJECT METHODS

    report_error (file: TEXT;  line: INTEGER;  msg: TEXT);

    find_source (unit: M3ID.T;  interface, generic: BOOLEAN): SourceFile;

    note_unit (name: M3ID.T;  interface: BOOLEAN);

    note_comment (msg: TEXT);

    note_interface_use (name: M3ID.T;  imported: BOOLEAN);

    note_generic_use (name: M3ID.T);

    note_version_stamp (unit, symbol: M3ID.T;
                        READONLY vs: Fingerprint.T;
                        imported, implemented: BOOLEAN);

    note_opaque (type, super_type: TypeID);

    note_revelation (unit: M3ID.T;  interface: BOOLEAN;
                    lhs, rhs: TypeID;  full, imported: BOOLEAN);

    note_opaque_magic (type, super_type: TypeID;
                       data_size, data_align, method_size : INTEGER);

    find_opaque_magic (type: TypeID;  VAR(*OUT*) super_type: TypeID;
            VAR(*OUT*) data_size, data_align, method_size: INTEGER): BOOLEAN;

    note_ast (unit: M3ID.T;  ast: REFANY);
    find_ast (unit: M3ID.T): REFANY;

    note_type (type: TypeID;  imported: BOOLEAN);

    init_code_generator (): M3CG.T;

    note_webinfo (t: TEXT);
  END;

END M3Compiler.
</PRE> The compiler makes all environmental queries and reports through
   the <CODE>env</CODE> parameter:
<P>
     <CODE>report_error</CODE> is called to report error and warning messages.
<P>
     <CODE>find_source</CODE> is called to locate the source files needed to
      satisfy <CODE>IMPORT</CODE>s.
<P>
     <CODE>note_unit</CODE> is called to announce the current unit.  The remainder
      of the <CODE>note</CODE> calls attach information needed by the linker
      and smart recompilation system to the announced unit.
<P>
     <CODE>note_comment</CODE> attaches a comment to the current unit.
<P>
     <CODE>note_inteface_use</CODE> records the named interface as is either imported
      or exported by the current unit.
<P>
     <CODE>note_generic_use</CODE> records the use of the specified generic unit.
<P>
     <CODE>note_version_stamp</CODE> records the import(export) of <CODE>symbol</CODE> with
      version stamp <CODE>vs</CODE> from(to) the interface <CODE>unit</CODE>.
<P>
     <CODE>note_opaque</CODE> records the opaque declaration <CODE>type &lt;: super_type</CODE>
      in the current unit.
<P>
     <CODE>note_revelation</CODE> records the import(export) of a revelation.
      With <CODE>note_opaque</CODE> it is used to verify the all opaque types
      are defined and the all compilation units saw a consistent
      set of revelations.
<P>
     <CODE>note_opaque_magic</CODE> announces the size of a previously declared
      opaque type.
<P>
     <CODE>find_opaque_magic</CODE> attempts to locate the size of an opaque type.
      Returns TRUE iff it succeeded in finding the information.
<P>
     <CODE>note_ast</CODE> records an (interface name, ast) pair in the ast
     cache.
<P>
     <CODE>find_ast</CODE> returns the ast cached under the given name.  Returns
     NIL if no such ast exists.
<P>
     <CODE>init_code_generator</CODE> returns the code generator to be used.
     To avoid empty object files, <CODE>init_code_generator</CODE> isn't called
     until after type checking.


<P> The recognized options are:
<P>
     -v             verbose mode
     -g             generate debugging information
     -S             don't generate version stamps
     -wX            print warnings at level <CODE>X</CODE> and above
     -w             don't print warnings  == -w99
     -Z             generate line-based profiling.
     -En            die on the <CODE>n-th</CODE> error message.
     -NoChecks      disable all runtime checks
     -NoAsserts     disable &lt;*ASSERT*&gt; checks
     -NoNarrowChk   disable narrow checks
     -NoRangeChk    disable subscript and range checks
     -NoReturnChk   disable checks for functions that fail to return values
     -NoCaseChk     disable checks for unhandled CASE selectors
     -NoTypecaseChk disable checks for unhandled TYPECASE selectors
     -NoNilChk      disable explicit NIL checks
     -NoRaisesChk   disable checks for unhandled exceptions
     -InitFloats    initialize all floating point values to zero
     -vsdebug       generate a trace of the fingerprint computations
     -builtins      <CODE>compile</CODE> and emit the builtin symbols
     -times         print the elapsed time profile
     -load_map      generate the load map comment in the output
     -No_load_map   don't generate the load map comment in the output

 
<P>
<P>
</inInterface>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
