<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/M3Compiler.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/M3Compiler.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: M3Compiler.m3                                         

<P><PRE>MODULE <module><implements><A HREF="M3Compiler.i3">M3Compiler</A></implements></module>;

IMPORT <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>(** , RTCollector, RTCollectorSRC **);
IMPORT <A HREF="Token.i3">Token</A>, <A HREF="Error.i3">Error</A>, <A HREF="Scanner.i3">Scanner</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="Scope.i3">Scope</A>, <A HREF="M3String.i3">M3String</A>, <A HREF="../types/RefType.i3">RefType</A>;
IMPORT <A HREF="../values/Module.i3">Module</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/BuiltinTypes.i3">BuiltinTypes</A>, <A HREF="Host.i3">Host</A>, <A HREF="Tracer.i3">Tracer</A>, <A HREF="M3Header.i3">M3Header</A>;
IMPORT <A HREF="../builtinOps/BuiltinOps.i3">BuiltinOps</A>, <A HREF="../builtinWord/WordModule.i3">WordModule</A>, <A HREF="M3.i3">M3</A>, <A HREF="../../../time/src/Common/Time.i3">Time</A>, <A HREF="Coverage.i3">Coverage</A>, <A HREF="Marker.i3">Marker</A>, <A HREF="../types/TypeFP.i3">TypeFP</A>;
IMPORT <A HREF="../values/Ident.i3">Ident</A>, <A HREF="../exprs/TextExpr.i3">TextExpr</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../exprs/SetExpr.i3">SetExpr</A>, <A HREF="TipeDesc.i3">TipeDesc</A>, <A HREF="../../../os/src/Common/Pathname.i3">Pathname</A>;
IMPORT <A HREF="ESet.i3">ESet</A>, <A HREF="CG.i3">CG</A>, <A HREF="../../../rw/src/Common/TextWr.i3">TextWr</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="ProcBody.i3">ProcBody</A>, <A HREF="Runtime.i3">Runtime</A>, <A HREF="#x1">M3ID</A>;

VAR mu         : MUTEX    := NEW (MUTEX);
VAR builtins   : Module.T := NIL;

PROCEDURE <A NAME="ParseImports"><procedure>ParseImports</procedure></A> (READONLY input : SourceFile;
                                 env   : Environment): IDList =
  VAR ids: IDList := NIL;
  BEGIN
    LOCK mu DO
      (* make the arguments globally visible *)
      Host.env      := env;
      Host.source   := input.contents;
      Host.filename := input.name;

      Scanner.Push (Host.filename, Host.source, is_main := TRUE);
        ids := M3Header.Parse ();
      Scanner.Pop ();
      RETURN ids;
    END;
  END ParseImports;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (READONLY input    : SourceFile;
                            env      : Environment;
                   READONLY options  : ARRAY OF TEXT): BOOLEAN =
  VAR ok: BOOLEAN;  start: Time.T;
  BEGIN
    LOCK mu DO
      start := Time.Now ();

      (* make the arguments globally visible *)
      Host.env      := env;
      Host.source   := input.contents;
      Host.filename := input.name;

      IF NOT Host.Initialize (options) THEN RETURN FALSE; END;

      IF NOT Host.stack_walker THEN
        (* command line override... *)
        Target.Has_stack_walker := FALSE;
      END;

      IF (builtins = NIL) THEN Initialize () END;

      Reset ();
      DoCompile ();
      ok := Finalize ();

      IF (Host.report_stats) THEN DumpStats (start, Time.Now ()); END;
    END;
    RETURN ok;
  END Compile;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    (* this list is ordered! *)
    Type.Initialize ();
    TypeFP.Initialize ();

    Scanner.Push (&quot;M3_BUILTIN&quot;, NIL, is_main := Host.emitBuiltins);
      builtins := Module.NewDefn (&quot;M3_BUILTIN&quot;, TRUE, Scope.Initial);
      BuiltinTypes.Initialize ();
      BuiltinOps.Initialize ();
    Scanner.Pop ();

    Scanner.Push (&quot;Word.i3&quot;, NIL, is_main := Host.emitBuiltins);
      WordModule.Initialize ();
    Scanner.Pop ();
  END Initialize;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> () =
  BEGIN
    (* this list is ordered! *)
    M3String.Reset ();
    Scanner.Reset ();
    Scope.Reset ();
    Coverage.Reset ();
    Error.Reset ();
    Marker.Reset ();
    ESet.Reset ();
    ProcBody.Reset ();
    Runtime.Reset ();
    TipeDesc.Reset ();
    Tracer.Reset ();
    Type.Reset ();
    TypeFP.Reset ();
    RefType.Reset ();
    Value.Reset ();
    Module.Reset ();
    Ident.Reset ();
    TextExpr.Reset ();
    Procedure.Reset ();
    SetExpr.Init ();
  END Reset;

PROCEDURE <A NAME="DoCompile"><procedure>DoCompile</procedure></A> () =
  VAR m: Module.T;  cs := M3.OuterCheckState;  m_name, filename: M3ID.T;
  BEGIN
</PRE><BLOCKQUOTE><EM>**
RTCollectorSRC.gcRatio := 0.5; (* don't bother collecting much </EM></BLOCKQUOTE><PRE>
RTCollectorSRC.incremental := FALSE;
RTCollector.Disable ();
***)
    Scanner.Push (Host.filename, Host.source, is_main := TRUE);

    StartPhase (&quot;initializing builtins&quot;);
    CheckBuiltins ();

    StartPhase (&quot;parsing&quot;);
    m := Module.Parse ();

    (* check that the module name matches the file name *)
    m_name := Module.Name (m);
    filename := M3ID.Add (Pathname.LastBase (Host.filename));
    IF (m_name # filename) THEN
      Error.Warn (2, &quot;file name (&quot; &amp; Pathname.Last (Host.filename)
                    &amp; &quot;) doesn't match module name (&quot;
                    &amp; M3ID.ToText (m_name) &amp; &quot;)&quot;);
    END;
</PRE><BLOCKQUOTE><EM>**
RTCollector.Enable ();
**</EM></BLOCKQUOTE><PRE>
    IF Failed () THEN RETURN END;

    StartPhase (&quot;type checking&quot;);
    Module.TypeCheck (m, TRUE, cs);
    IF Failed () THEN RETURN END;

    StartPhase (&quot;emitting code&quot;);
    CG.Init ();
    IF Failed () THEN RETURN END;
    IF (Host.emitBuiltins) THEN
      Module.MakeCurrent (builtins);
      Module.MakeCurrent (WordModule.M);
      Module.Compile (builtins);
      Module.Compile (WordModule.M);
    ELSE
      Module.Compile (m);
    END;
    IF Failed () THEN RETURN END;
  END DoCompile;

PROCEDURE <A NAME="CheckBuiltins"><procedure>CheckBuiltins</procedure></A> () =
  VAR cs := M3.OuterCheckState;
  BEGIN
    Value.TypeCheck (builtins, cs);
    Value.TypeCheck (WordModule.M, cs);
  END CheckBuiltins;

PROCEDURE <A NAME="StartPhase"><procedure>StartPhase</procedure></A> (tag: TEXT) =
  BEGIN
    IF (Host.verbose) THEN
      Host.env.report_error (NIL, 0, tag &amp; &quot;...&quot;);
    END;
  END StartPhase;

PROCEDURE <A NAME="Failed"><procedure>Failed</procedure></A> (): BOOLEAN =
  VAR errs, warns: INTEGER;
  BEGIN
    Error.Count (errs, warns);
    RETURN (errs &gt; 0);
  END Failed;

PROCEDURE <A NAME="DumpStats"><procedure>DumpStats</procedure></A> (start, stop: Time.T) =
  &lt;*FATAL Wr.Failure, Thread.Alerted*&gt;
  VAR
    wr      := TextWr.New ();
    elapsed := MAX (stop - start, 1.0d-6);
    speed   := FLOAT (Scanner.nLines, LONGREAL) / elapsed;
  BEGIN
    Wr.PutText (wr, &quot;  &quot;);
    Wr.PutText (wr, Fmt.Int (Scanner.nLines));
    Wr.PutText (wr, &quot; lines (&quot;);
    Wr.PutText (wr, Fmt.Int (Scanner.nPushed));
    Wr.PutText (wr, &quot; files) scanned, &quot;);
    Wr.PutText (wr, Fmt.LongReal (elapsed, Fmt.Style.Fix, 2));
    Wr.PutText (wr, &quot; seconds, &quot;);
    Wr.PutText (wr, Fmt.LongReal (speed, Fmt.Style.Fix, 1));
    Wr.PutText (wr, &quot; lines / second.&quot;);
    Host.env.report_error (NIL, 0, TextWr.ToText (wr));
  END DumpStats;

PROCEDURE <A NAME="Finalize"><procedure>Finalize</procedure></A> (): BOOLEAN =
  &lt;*FATAL Wr.Failure, Thread.Alerted*&gt;
  VAR errs, warns: INTEGER;  wr: TextWr.T;
  BEGIN
    Scanner.Pop ();

    Error.Count (errs, warns);
    IF (errs + warns &gt; 0) THEN
      wr := TextWr.New ();
      IF (errs &gt; 0) THEN
        Wr.PutText (wr, Fmt.Int (errs));
        Wr.PutText (wr, &quot; error&quot;);
        IF (errs &gt; 1) THEN Wr.PutText (wr, &quot;s&quot;) END;
      END;
      IF (warns &gt; 0) THEN
        IF (errs &gt; 0) THEN Wr.PutText (wr, &quot; and &quot;) END;
        Wr.PutText (wr, Fmt.Int (warns));
        Wr.PutText (wr, &quot; warning&quot;);
        IF (warns &gt; 1) THEN Wr.PutText (wr, &quot;s&quot;) END;
      END;
      Wr.PutText (wr, &quot; encountered&quot;);
      Host.env.report_error (NIL, 0, TextWr.ToText (wr));
    END;

    RETURN (errs &lt;= 0);
  END Finalize;

BEGIN
  M3String.Initialize ();
  Token.Initialize ();
  Scanner.Initialize ();
  Scope.Initialize ();
END M3Compiler.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
