<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/M3Header.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/M3Header.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: M3Header.m3                                           

<P><PRE>MODULE <module><implements><A HREF="M3Header.i3">M3Header</A></implements></module>;

IMPORT <A HREF="../../../os/src/Common/File.i3">File</A>, <A HREF="M3Compiler.i3">M3Compiler</A>, <A HREF="Token.i3">Token</A>, <A HREF="Host.i3">Host</A>, <A HREF="#x1">M3ID</A>, <A HREF="Scanner.i3">Scanner</A>;
FROM <A HREF="Scanner.i3">Scanner</A> IMPORT GetToken, cur;

TYPE
  IDList = M3Compiler.IDList;
  TK     = Token.T;

TYPE
  State = RECORD
    imports   : IDList  := NIL;
    generic   : File.T  := NIL;
    interface : BOOLEAN := FALSE;
    failed    : BOOLEAN := FALSE;
  END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): M3Compiler.IDList =
  VAR
    s  : State;
    id : M3ID.T;
  BEGIN
    PushID (s, M3ID.Add (&quot;RTHooks&quot;)); (* compiler magic *)

    IF (cur.token = TK.tEXTERNAL) THEN SkipExternalPragma (); END;
    IF (cur.token = TK.tUNSAFE) THEN GetToken (); END;

    s.interface := (cur.token = TK.tINTERFACE);
    IF (cur.token #TK.tINTERFACE) AND (cur.token # TK.tMODULE) THEN
      RETURN s.imports;
    END;
    GetToken (); (* INTERFACE/MODULE *)

    IF NOT MatchID (s, id) THEN RETURN s.imports END;

    IF (cur.token = TK.tEXPORTS) THEN
      GetToken (); (*EXPORTS*)
      MatchIDList (s, save := TRUE);
    ELSIF (NOT s.interface) THEN
      PushID (s, id);
    END;

    IF (cur.token = TK.tSEMI) THEN
      (* this is a simple module/interface, just fall through *)
      GetToken (); (* ; *)
    ELSIF (cur.token = TK.tEQUAL) THEN
      (* this is an instantiation of a generic module/interface *)
      GetToken (); (* = *)
      PushGeneric (s);
    ELSE (* bail out *)
      RETURN s.imports;
    END;

    ParseImports (s);

    IF (s.generic # NIL) THEN
      Scanner.Pop ();
      Host.CloseFile (s.generic);
    END;

    RETURN s.imports;
  END Parse;

PROCEDURE <A NAME="SkipExternalPragma"><procedure>SkipExternalPragma</procedure></A> () =
  BEGIN
    GetToken (); (* EXTERNAL *)
    IF (cur.token = TK.tIDENT) OR (cur.token = TK.tTEXTCONST) THEN
      GetToken (); (* IDENT, TEXTCONST *)
      IF (cur.token = TK.tCOLON) THEN
        GetToken (); (* : *)
        IF (cur.token = TK.tIDENT) OR (cur.token = TK.tTEXTCONST) THEN
          GetToken (); (* language *)
        END;
      END;
    END;
    IF (cur.token = TK.tENDPRAGMA) THEN
      GetToken (); (* &quot;*&gt;&quot; *)
    END;
  END SkipExternalPragma;

PROCEDURE <A NAME="PushGeneric"><procedure>PushGeneric</procedure></A> (VAR s: State) =
  (* instantiate a call on a generic interface or module *)
  VAR
    genericName  : M3ID.T;
    filename     : TEXT;
    old_filename : TEXT;
    old_line     : INTEGER;
  BEGIN
    Scanner.Here (old_filename, old_line);

    IF NOT MatchID (s, genericName) THEN RETURN END;

    (* parse the list of actuals *)
    ParseGenericArgs (s, save := TRUE);

    (* open the external file *)
    s.generic := Host.OpenUnit (genericName, s.interface, TRUE, filename);
    IF (s.generic = NIL) THEN s.failed := TRUE;  RETURN; END;

    (* build a synthetic file name &amp; start reading *)
    filename := old_filename &amp; &quot; =&gt; &quot; &amp; filename;
    Scanner.Push (filename, s.generic, is_main := Scanner.in_main);

    (* make sure we got what we wanted *)
    IF NOT Match (s, TK.tGENERIC) THEN RETURN END;
    IF (cur.token # TK.tINTERFACE) AND (cur.token #TK.tMODULE) THEN RETURN END;
    GetToken ();

    (* get the generic's name *)
    IF NOT Match (s, TK.tIDENT) THEN RETURN END;

    (* skip the list of formals *)
    ParseGenericArgs (s, save := FALSE);

    EVAL Match (s, TK.tSEMI);
  END PushGeneric;

PROCEDURE <A NAME="ParseGenericArgs"><procedure>ParseGenericArgs</procedure></A> (VAR s: State;  save: BOOLEAN) =
  BEGIN
    IF NOT Match (s, TK.tLPAREN) THEN RETURN END;
    MatchIDList (s, save);
    IF NOT Match (s, TK.tRPAREN) THEN RETURN END;
  END ParseGenericArgs;

PROCEDURE <A NAME="ParseImports"><procedure>ParseImports</procedure></A> (VAR s: State) =
  BEGIN
    LOOP
      IF    (cur.token = TK.tIMPORT) THEN ParseImport (s);
      ELSIF (cur.token = TK.tFROM)   THEN ParseFromImport (s);
      ELSE  EXIT;
      END;
    END;
  END ParseImports;

PROCEDURE <A NAME="ParseImport"><procedure>ParseImport</procedure></A> (VAR s: State) =
  VAR id: M3ID.T;
  BEGIN
    GetToken (); (* IMPORT *)
    LOOP
      IF NOT MatchID (s, id) THEN RETURN END;
      PushID (s, id);

      IF (cur.token = TK.tAS) THEN
        GetToken (); (* AS *)
        IF NOT MatchID (s, id) THEN RETURN END;
      END;

      IF (cur.token # TK.tCOMMA) THEN EXIT END;
      GetToken (); (* , *)
    END;
    EVAL Match (s, TK.tSEMI);
  END ParseImport;

PROCEDURE <A NAME="ParseFromImport"><procedure>ParseFromImport</procedure></A> (s: State) =
  VAR id: M3ID.T;
  BEGIN
    GetToken (); (* FROM *)
    IF NOT MatchID (s, id) THEN RETURN END;
    PushID (s, id);
    IF NOT Match (s, TK.tIMPORT) THEN RETURN END;
    MatchIDList (s, save := FALSE);
    EVAL Match (s, TK.tSEMI);
  END ParseFromImport;

PROCEDURE <A NAME="MatchIDList"><procedure>MatchIDList</procedure></A> (VAR s: State;  save: BOOLEAN) =
  VAR id: M3ID.T;
  BEGIN
    LOOP
      IF NOT MatchID (s, id) THEN RETURN END;
      IF save THEN PushID (s, id); END;
      IF (cur.token # TK.tCOMMA) THEN EXIT; END;
      GetToken (); (* , *)
    END;
  END MatchIDList;

PROCEDURE <A NAME="Match"><procedure>Match</procedure></A> (VAR s: State;  t: TK): BOOLEAN =
  BEGIN
    IF (s.failed) OR (cur.token # t) THEN
      s.failed := TRUE;
      RETURN FALSE;
    END;
    GetToken ();
    RETURN TRUE;
  END Match;

PROCEDURE <A NAME="MatchID"><procedure>MatchID</procedure></A> (VAR s: State;  VAR(*OUT*) id: M3ID.T): BOOLEAN =
  BEGIN
    IF (s.failed) OR (cur.token # TK.tIDENT) THEN
      s.failed := TRUE;
      RETURN FALSE;
    END;
    id := cur.id;
    GetToken ();
    RETURN TRUE;
  END MatchID;

PROCEDURE <A NAME="PushID"><procedure>PushID</procedure></A> (VAR s: State;  id: M3ID.T) =
  BEGIN
    s.imports := NEW (M3Compiler.IDList, interface := id, next := s.imports);
  END PushID;

BEGIN
END M3Header.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
