<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/M3String.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/M3String.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: M3String.i3                                           

<P><PRE>INTERFACE <interface><A HREF="M3String.m3">M3String</A></interface>;

IMPORT <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>;

TYPE <A HREF="M3String.m3#T">T</A> &lt;: REFANY;

PROCEDURE <A HREF="M3String.m3#Add">Add</A> (x: TEXT): T;
</PRE><BLOCKQUOTE><EM> Returns a string equal to 'x' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3String.m3#FromStr">FromStr</A> (READONLY buf: ARRAY OF CHAR;  length: INTEGER := 99999): T;
</PRE><BLOCKQUOTE><EM> Returns a string equal to buf[0 .. MIN(HIGH(buf), length-1)]. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3String.m3#Concat">Concat</A> (a, b: T): T;
</PRE><BLOCKQUOTE><EM> Returns the concatenation of two strings </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3String.m3#ToText">ToText</A> (t: T): TEXT;
</PRE><BLOCKQUOTE><EM> Returns a text equal to t </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3String.m3#Put">Put</A> (wr: M3Buf.T;  t: T);
</PRE><BLOCKQUOTE><EM> writes the string on the writer </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3String.m3#Init_chars">Init_chars</A> (offset: INTEGER;  t: T);
</PRE><BLOCKQUOTE><EM> initializes the current variable at 'offset' with the characters of 't'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3String.m3#Length">Length</A> (t: T): INTEGER;
</PRE><BLOCKQUOTE><EM> returns the length of the string </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3String.m3#GetUID">GetUID</A> (t: T): INTEGER;
</PRE><BLOCKQUOTE><EM> returns the string's UID </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3String.m3#SetUID">SetUID</A> (t: T;  uid: INTEGER);
</PRE><BLOCKQUOTE><EM> sets the string's UID </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3String.m3#Hash">Hash</A> (t: T): INTEGER;
</PRE><BLOCKQUOTE><EM> returns a hash value for the string </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3String.m3#Initialize">Initialize</A> ();
PROCEDURE <A HREF="M3String.m3#Reset">Reset</A> ();

END M3String.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
