<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/Marker.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/Marker.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: Marker.i3                                             
 Last Modified On Tue Dec 20 14:26:58 PST 1994 by kalsow     
      Modified On Sat Jun 10 18:44:15 PDT 1989 by muller     

<P><PRE>INTERFACE <interface><A HREF="Marker.m3">Marker</A></interface>;

IMPORT <A HREF="CG.i3">CG</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Variable.i3">Variable</A>, <A HREF="ESet.i3">ESet</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>;

CONST
  Return_exception = -1;
  Exit_exception = -2;

PROCEDURE <A HREF="Marker.m3#Pop">Pop</A> ();
</PRE><BLOCKQUOTE><EM> pop to top scope. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Marker.m3#SaveFrame">SaveFrame</A> ();
</PRE><BLOCKQUOTE><EM> mark and save the top scope so it can be emitted in the
   global table of scopes </EM></BLOCKQUOTE><PRE>
</PRE> TRY-EXCEPT 
<PRE>PROCEDURE <A HREF="Marker.m3#PushTry">PushTry</A>     (l_start, l_stop: CG.Label;  info: CG.Var;  ex: ESet.T);
PROCEDURE <A HREF="Marker.m3#PushTryElse">PushTryElse</A> (l_start, l_stop: CG.Label;  info: CG.Var);
</PRE> TRY-FINALLY 
<PRE>PROCEDURE <A HREF="Marker.m3#PushFinally">PushFinally</A>     (l_start, l_stop: CG.Label;  info: CG.Var);
PROCEDURE <A HREF="Marker.m3#PushFinallyProc">PushFinallyProc</A> (l_start, l_stop: CG.Label;  info: CG.Var);
PROCEDURE <A HREF="Marker.m3#PopFinally">PopFinally</A>      (VAR(*OUT*) returnSeen, exitSeen: BOOLEAN);
</PRE> LOCK-END 
<PRE>PROCEDURE <A HREF="Marker.m3#PushLock">PushLock</A> (l_start, l_stop: CG.Label;  mutex: CG.Var);
</PRE> LOOP-EXIT 
<PRE>PROCEDURE <A HREF="Marker.m3#PushExit">PushExit</A> (l_stop: CG.Label);
PROCEDURE <A HREF="Marker.m3#ExitOK">ExitOK</A>   (): BOOLEAN;
</PRE> TRY-PASSING (RAISES) 
<PRE>PROCEDURE <A HREF="Marker.m3#PushRaises">PushRaises</A> (l_start, l_stop: CG.Label;  ex: ESet.T;  info: CG.Var);
</PRE> PROCEDURE-RETURN 
<PRE>PROCEDURE <A HREF="Marker.m3#PushProcedure">PushProcedure</A> (t: Type.T;  v: Variable.T;  cc: CG.CallingConvention);
PROCEDURE <A HREF="Marker.m3#ReturnVar">ReturnVar</A>     (VAR(*OUT*) t: Type.T;  VAR(*OUT*) v: Variable.T);
PROCEDURE <A HREF="Marker.m3#ReturnOK">ReturnOK</A>      (): BOOLEAN;
</PRE> code generation 
<PRE>PROCEDURE <A HREF="Marker.m3#EmitExit">EmitExit</A>   ();
PROCEDURE <A HREF="Marker.m3#EmitReturn">EmitReturn</A> (expr: Expr.T;  fromFinally: BOOLEAN);
PROCEDURE <A HREF="Marker.m3#EmitScopeTable">EmitScopeTable</A> (): INTEGER;
PROCEDURE <A HREF="Marker.m3#EmitExceptionTest">EmitExceptionTest</A> (signature: Type.T);
PROCEDURE <A HREF="Marker.m3#NextHandler">NextHandler</A> (VAR(*OUT*) handler: CG.Label;
                       VAR(*OUT*) info: CG.Var): BOOLEAN;

PROCEDURE <A HREF="Marker.m3#PushFrame">PushFrame</A> (frame: CG.Var;  class: M3RT.HandlerClass);
PROCEDURE <A HREF="Marker.m3#PopFrame">PopFrame</A> (frame: CG.Var);
</PRE><BLOCKQUOTE><EM> generate code to link and unlink 'frame' from the global
   stack of exception frames </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Marker.m3#SetLock">SetLock</A> (acquire: BOOLEAN;  var: CG.Var;  offset: INTEGER);
</PRE><BLOCKQUOTE><EM> generate the call to acquire or release a mutex </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Marker.m3#CaptureState">CaptureState</A> (frame: CG.Var;  handler: CG.Label);
</PRE><BLOCKQUOTE><EM> call 'setjmp' on 'frame's jmpbuf and branch to 'handler' on re-returns. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Marker.m3#Reset">Reset</A> ();

END Marker.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
