<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/ProcBody.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/ProcBody.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ProcBody.i3                                           

<P><PRE>INTERFACE <interface><A HREF="ProcBody.m3">ProcBody</A></interface>;
</PRE> This interface manages the order that procedure bodies are emitted. 

<P><PRE>IMPORT <A HREF="CG.i3">CG</A>;

TYPE
  <A HREF="ProcBody.m3#T">T</A> &lt;: T_;
  T_ = OBJECT
    parent     : T       := NIL; (* set by Push *)
    level      : INTEGER := 0;   (* set by Push *)
    name       : TEXT    := NIL; (* set by client *)
    cg_proc    : CG.Proc := NIL; (* set by client *)
    export_var : CG.Var  := NIL; (* set by client *)
    export_offs: INTEGER := 0;   (* set by client *)
  METHODS
    gen_decl ();
    gen_body ();
  END;

PROCEDURE <A HREF="ProcBody.m3#Push">Push</A> (t: T);
</PRE><BLOCKQUOTE><EM> pushes the procedure that will be written as a child of the current
   procedure.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ProcBody.m3#Pop">Pop</A> ();
</PRE><BLOCKQUOTE><EM> pops the current procedure </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ProcBody.m3#Schedule">Schedule</A> (t: T);
</PRE><BLOCKQUOTE><EM> schedules <CODE>t</CODE> to be written as a top-level procedure </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ProcBody.m3#DelayedInit">DelayedInit</A> (offset: INTEGER;  src: CG.Var;  src_offset: INTEGER);
</PRE><BLOCKQUOTE><EM> generate the runtime code to initialize the pointer at <CODE>offset</CODE> with
   the value at <CODE>src+src_offset</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ProcBody.m3#EmitAll">EmitAll</A> (VAR proc_info: INTEGER;  VAR link_proc: CG.Proc);
</PRE><BLOCKQUOTE><EM> generate all the procedure bodies, build the global table,
   and generate the link proc if it's needed </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ProcBody.m3#Reset">Reset</A> ();

END ProcBody.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
