<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/Runtime.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/Runtime.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Runtime.m3                                            
 Last Modified On Mon Jul 25 15:30:51 PDT 1994 By kalsow     

<P><PRE>MODULE <module><implements><A HREF="Runtime.i3">Runtime</A></implements></module>;

IMPORT <A HREF="M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../values/ValueRep.i3">ValueRep</A>, <A HREF="Scope.i3">Scope</A>, <A HREF="../values/Module.i3">Module</A>, <A HREF="Error.i3">Error</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="CG.i3">CG</A>;

TYPE
  ActualHook = [0..14];
CONST
  HookNames = ARRAY ActualHook OF TEXT {
    &quot;Raise&quot;,
    &quot;ResumeRaise&quot;,
    &quot;PushEFrame&quot;,
    &quot;PopEFrame&quot;,
    &quot;LockMutex&quot;,
    &quot;UnlockMutex&quot;,
    &quot;Concat&quot;,
    &quot;Allocate&quot;,
    &quot;AllocateOpenArray&quot;,
    &quot;AllocateUntracedObj&quot;,
    &quot;AllocateUntracedRef&quot;,
    &quot;AllocateUntracedOpenArray&quot;,
    &quot;DisposeUntracedRef&quot;,
    &quot;DisposeUntracedObj&quot;,
    &quot;ReportFault&quot;
  };

CONST
  HookMap = ARRAY Hook OF ActualHook { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
                                       11, 12, 13, 14, 14, 14, 14, 14, 14,
                                       14, 14, 14 };

VAR
  hooks       : Module.T := NIL;
  hooks_name  : M3ID.T   := M3ID.NoID;
  hooks_alias : M3ID.T   := M3ID.NoID;
  hook_procs  : ARRAY ActualHook OF Procedure.T;
</PRE>---------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> () =
  BEGIN
    hooks := NIL;
  END Reset;

PROCEDURE <A NAME="Import"><procedure>Import</procedure></A> () =
  BEGIN
    IF (hooks # NIL) THEN RETURN END;
    hooks_name  := M3ID.Add (&quot;RTHooks&quot;);
    hooks_alias := M3ID.Add (&quot;__RTHooks__&quot;);
    hooks := Module.LookUp (hooks_name, internal := TRUE);
    FOR h := FIRST (hook_procs) TO LAST (hook_procs) DO
      hook_procs[h] := NIL;
    END;
  END Import;

PROCEDURE <A NAME="Bind"><procedure>Bind</procedure></A> (dest: Module.T;  VAR runtime: Module.T;  VAR id: M3ID.T) =
  BEGIN
    IF (dest.name = hooks_name) AND Module.IsInterface ()
      THEN runtime := NIL;    id := M3ID.NoID;
      ELSE runtime := hooks;  id := hooks_alias;
    END;
  END Bind;

PROCEDURE <A NAME="LookUpProc"><procedure>LookUpProc</procedure></A> (h: Hook): Procedure.T =
  VAR hh := HookMap[h];  p := hook_procs [hh];
  BEGIN
    &lt;*ASSERT hooks # NIL*&gt;
    IF (p = NIL) THEN
      p := LookUpNewProc (M3ID.Add (HookNames [hh]));
      hook_procs [hh] := p;
    END;
    RETURN p;
  END LookUpProc;
</PRE>-------------------------------------------------------------- internal ---

<P><PRE>PROCEDURE <A NAME="LookUpNewProc"><procedure>LookUpNewProc</procedure></A> (name: M3ID.T): Procedure.T =
  VAR
    v := LookUp (name);
    c := Value.ClassOf (v);
    proc   : CG.Proc;
    unit   : CG.Var;
    offset : INTEGER;
  BEGIN
    IF (c # Value.Class.Procedure) THEN RETURN NIL END;
    Value.Declare (v);  (* force a version stamp *)
    Procedure.CGName (v, proc, unit, offset);
    IF (unit # NIL) THEN
      CG.Set_runtime_hook (v.name, unit, offset);
    END;
    RETURN v;
  END LookUpNewProc;

PROCEDURE <A NAME="LookUp"><procedure>LookUp</procedure></A> (name: M3ID.T): Value.T =
  VAR syms: Scope.T;  v: Value.T;
  BEGIN
    IF (hooks = NIL) THEN RETURN NIL END;
    syms := Module.ExportScope (hooks);
    IF (syms # NIL)
      THEN v := Scope.LookUp (syms, name, TRUE);
      ELSE v := NIL; (* probably a circular import! *)
    END;
    IF (v = NIL) THEN
      Error.QID (M3.QID {module := hooks_name, item := name},
                  &quot;undefined runtime symbol !!&quot;)
    END;
    RETURN v;
  END LookUp;

BEGIN
END Runtime.
</PRE>******************************************
PROCEDURE LookUpType (name: TEXT): Type.T =
  VAR
    n := M3ID.Add (name);
    v := LookUp (n);
    c := Value.ClassOf (v);
    t : Type.T;
    info: Type.Info;
  BEGIN
    IF (c # Value.Class.Type) THEN RETURN NIL END;
    t := Value.ToType (v);
    t := Type.Check (t, info);
    RETURN t;
  END LookUpType;
*********************************************

<P>******************************************
PROCEDURE GenHooks () =
  VAR
    syms: Scope.T;
    v: Value.T;
    proc: CG.Proc;
    unit: CG.Var;
    offset: INTEGER;
    c: Value.Class;
  BEGIN
    CG.Comment (-1, <CODE>runtime routines</CODE>);
    IF (hooks = NIL) THEN RETURN END;
    syms := Module.ExportScope (hooks);
    IF (syms = NIL) THEN RETURN END; (* probably a circular import! 
    <PRE>v := Scope.ToList (syms);
    WHILE (v # NIL) DO
      c := Value.ClassOf (v);
      IF (c = Value.Class.Procedure) THEN
        Procedure.CGName (v, proc, unit, offset);
        IF (unit # NIL) THEN
          CG.Set_runtime_hook (v.name, unit, offset);
        END;
      ELSIF (c = Value.Class.Var) THEN
        Variable.CGName (v, unit, offset);
        IF (unit # NIL) THEN
          CG.Set_runtime_hook (v.name, unit, offset);
        END;
      END;
      v := v.next;
    END;
  END GenHooks;
**********************************************)
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
