<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/Scanner.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/Scanner.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Scanner.i3                                            

<P><PRE>INTERFACE <interface><A HREF="Scanner.m3">Scanner</A></interface>;

IMPORT <A HREF="Token.i3">Token</A>, <A HREF="../../../os/src/Common/File.i3">File</A>, <A HREF="#x1">M3ID</A>, <A HREF="M3String.i3">M3String</A>, <A HREF="M3.i3">M3</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;

TYPE
  Symbol = RECORD
    token  : Token.T;
    id     : M3ID.T;
    str    : M3String.T;
    int    : Target.Int;
    float  : Target.Float;
    offset : INTEGER;
    defn   : M3.Value;
  END;

VAR
  cur     : Symbol; (* READONLY *)
  offset  : INTEGER;
  nLines  : INTEGER := 0; (* READONLY *)
  nPushed : INTEGER := 0; (* READONLY *)
  in_main : BOOLEAN := FALSE;

PROCEDURE <A HREF="Scanner.m3#GetToken">GetToken</A> ();
PROCEDURE <A HREF="Scanner.m3#Match">Match</A>    (t: Token.T);
PROCEDURE <A HREF="Scanner.m3#MatchID">MatchID</A>  (): M3ID.T;
PROCEDURE <A HREF="Scanner.m3#Fail">Fail</A>     (msg: TEXT);

PROCEDURE <A HREF="Scanner.m3#NoteReserved">NoteReserved</A> (name: M3ID.T;  value: M3.Value);

PROCEDURE <A HREF="Scanner.m3#Here">Here</A> (VAR file: TEXT;  VAR line: INTEGER);
PROCEDURE <A HREF="Scanner.m3#LocalHere">LocalHere</A> (VAR file: TEXT;  VAR line: INTEGER);
PROCEDURE <A HREF="Scanner.m3#SameFile">SameFile</A> (a, b: INTEGER): BOOLEAN;

PROCEDURE <A HREF="Scanner.m3#Push">Push</A> (name: TEXT;  file: File.T;  is_main: BOOLEAN);
PROCEDURE <A HREF="Scanner.m3#Pop">Pop</A> ();

PROCEDURE <A HREF="Scanner.m3#Initialize">Initialize</A> ();
PROCEDURE <A HREF="Scanner.m3#Reset">Reset</A> ();

END Scanner.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
