<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/Scope.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/Scope.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Scope.m3                                              

<P><PRE>MODULE <module><implements><A HREF="Scope.i3">Scope</A></implements></module>;

IMPORT <A HREF="M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="CG.i3">CG</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../values/Module.i3">Module</A>, <A HREF="Error.i3">Error</A>, <A HREF="../values/Procedure.i3">Procedure</A>;
IMPORT <A HREF="Scanner.i3">Scanner</A>, <A HREF="../values/ValueRep.i3">ValueRep</A>, <A HREF="../values/Variable.i3">Variable</A>, <A HREF="Tracer.i3">Tracer</A>, <A HREF="../../../convert/src/Convert.i3">Convert</A>;

CONST
  MinHashed = 30;

REVEAL
  M3.<A NAME="Scope">Scope</A> = M3.Node BRANDED &quot;Scope.T&quot; OBJECT
    next       : T;
    parent     : T;
    sname      : M3ID.T;
    children   : INTEGER  := 0;
    head       : Value.T  := NIL;
    tail       : Value.T  := NIL;
    open       : BOOLEAN  := FALSE;  (* =&gt; lookups can see parent *)
    module     : BOOLEAN  := FALSE;  (* =&gt; is an outer module scope *)
    nested     : BOOLEAN  := FALSE;  (* =&gt; is a nested block *)
    proc_frame : BOOLEAN  := FALSE;
    home       : Module.T := NIL;
    n_elts     : INTEGER  := 0;
    hash_size  : INTEGER  := 0;
    hash       : REF ARRAY OF Value.T := NIL;
  END;

VAR (* explicit reset *)
  top       : T;
  allScopes : T;

VAR (* string &quot;constants&quot; *)
  emptyStr    : M3ID.T;
  Dot         : M3ID.T;
  DUnderscore : M3ID.T;

VAR (* never reset *)
  stack_buf : M3Buf.T := NIL;
  int_cache := ARRAY [0..15] OF M3ID.T {M3ID.NoID, ..};

PROCEDURE <A NAME="PopNew"><procedure>PopNew</procedure></A> () =
  BEGIN
    top := top.parent;
  END PopNew;

PROCEDURE <A NAME="PushNew"><procedure>PushNew</procedure></A> (open: BOOLEAN;  name: M3ID.T;  module := FALSE;
                   nested := FALSE): T =
  VAR t := NEW (T);
  BEGIN
    t.origin     := Scanner.offset;
    t.next       := allScopes;  allScopes := t;
    t.parent     := top;
    t.sname      := name;
    t.open       := open;
    t.module     := module;
    t.nested     := nested;
    t.proc_frame := (open) AND (NOT module) AND (NOT nested);
    t.home       := Module.Current ();
    top := t;
    RETURN t;
  END PushNew;

PROCEDURE <A NAME="New1"><procedure>New1</procedure></A> (obj: Value.T): T =
  VAR t := PushNew (open:=TRUE, name:=M3ID.NoID, module:=FALSE, nested:=TRUE);
  BEGIN
    Insert (obj);
    RETURN t;
  END New1;

PROCEDURE <A NAME="Push"><procedure>Push</procedure></A> (t: T): T =
  VAR old := top;
  BEGIN
    &lt;* ASSERT t # NIL *&gt;
    top := t;
    RETURN old;
  END Push;

PROCEDURE <A NAME="Pop"><procedure>Pop</procedure></A> (old: T) =
  BEGIN
    &lt;* ASSERT old # NIL *&gt;
    top := old;
  END Pop;

PROCEDURE <A NAME="Top"><procedure>Top</procedure></A> (): T =
  (* return the top &quot;open&quot; scope *)
  VAR t: T;
  BEGIN
    t := top;
    WHILE (t # NIL) AND (NOT t.open) DO t := t.parent END;
    RETURN t;
  END Top;

PROCEDURE <A NAME="OuterMost"><procedure>OuterMost</procedure></A> (t: T) : BOOLEAN =
  BEGIN
    RETURN (t # NIL) AND (t.module);
  END OuterMost;

PROCEDURE <A NAME="LookUpQID"><procedure>LookUpQID</procedure></A> (t: T;  READONLY q: M3.QID): Value.T =
  BEGIN
    IF (q.module = M3ID.NoID) THEN
      RETURN LookUp (t, q.item, FALSE);
    ELSE
      TYPECASE Value.Base (LookUp (t, q.module, FALSE)) OF
      | NULL         =&gt; RETURN NIL;
      | Module.T (m) =&gt; RETURN LookUp (Module.ExportScope (m), q.item, TRUE);
      ELSE              RETURN NIL;
      END;
    END;
  END LookUpQID;

PROCEDURE <A NAME="LookUp"><procedure>LookUp</procedure></A> (t: T;  name: M3ID.T;  strict: BOOLEAN): Value.T =
  VAR o: Value.T;  up_level := FALSE;  x, y: CARDINAL;
  BEGIN
    LOOP
      IF (t = NIL) THEN RETURN NIL END;
      IF (t.n_elts &lt; MinHashed) THEN
        o := t.head;
        WHILE (o # NIL) AND (o.name # name) DO o := o.next END;
      ELSE
        IF (t.n_elts # t.hash_size) THEN Rehash (t) END;
        y := NUMBER (t.hash^);
        x := M3ID.Hash (name) MOD y;
        LOOP
          o := t.hash [x];
          IF (o = NIL) OR (o.name = name) THEN EXIT END;
          INC (x);  IF (x &gt;= y) THEN x := 0 END;
        END;
      END;
      IF (o # NIL) THEN EXIT END;
      IF (strict) OR (NOT t.open) THEN RETURN NIL END;
      up_level := up_level OR t.proc_frame;
      t := t.parent;
    END;
    o.up_level := o.up_level OR up_level;

    IF (Scanner.in_main) THEN
      (* this is a top-level use of the symbol! *)
      o.used := TRUE;
      IF o.obsolete THEN
        Error.WarnID (2, name, &quot;&lt;*OBSOLETE*&gt; symbol used&quot;);
      ELSIF o.unused THEN
        Error.WarnID (2, name, &quot;&lt;*UNUSED*&gt; symbol used&quot;);
      END;
    END;

    RETURN o;
  END LookUp;

PROCEDURE <A NAME="Rehash"><procedure>Rehash</procedure></A> (t: T) =
  VAR
    max  := 2 * t.n_elts;
    x    := NEW (REF ARRAY OF Value.T, max);
    v    := t.head;
    hash : INTEGER;
  BEGIN
    WHILE (v # NIL) DO
      hash := M3ID.Hash (v.name) MOD max;
      WHILE (x[hash] # NIL) DO
        INC (hash);
        IF (hash &gt;= max) THEN hash := 0 END;
      END;
      x[hash] := v;
      v := v.next;
    END;
    t.hash_size := t.n_elts;
    t.hash := x;
  END Rehash;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (o: Value.T) =
  VAR t := top;
  BEGIN
    (* check for a reserved word *)
    IF (t # Initial) AND (LookUp (Initial, o.name, TRUE) # NIL) THEN
      Error.ID (o.name, &quot;Reserved identifier redefined&quot;);
    END;

    IF (o.next # NIL) THEN
      Error.ID (o.name, &quot;INTERNAL ERROR: value reinserted in scope&quot;);
      &lt;*ASSERT FALSE*&gt;
    END;

    (* finally, do the insertion *)
    IF (o.scope = NIL) THEN o.scope := t END;
    IF (t.tail # NIL)
      THEN t.tail.next := o;
      ELSE t.head := o;
    END;
    t.tail := o;
    INC (t.n_elts);
  END Insert;

PROCEDURE <A NAME="ToList"><procedure>ToList</procedure></A> (t: T): Value.T =
  BEGIN
    IF (t = NIL)
      THEN  RETURN NIL;
      ELSE  RETURN t.head;
    END;
  END ToList;

PROCEDURE <A NAME="TypeCheck"><procedure>TypeCheck</procedure></A> (t: T;  VAR cs: Value.CheckState) =
  (* note: we separate the type checking of procedures heads and bodies
     in an attempt to keep the error messages sorted in a rational order *)
  VAR v: Value.T;
  BEGIN
    IF (t = NIL) THEN RETURN END;
    CheckDuplicates (t);
    v := t.head;
    WHILE (v # NIL) DO  Value.TypeCheck (v, cs);  v := v.next;  END;
    v := t.head;
    WHILE (v # NIL) DO
      TYPECASE Value.Base (v) OF
      | NULL            =&gt; (* ignore *)
      | Procedure.T (p) =&gt; Procedure.CheckBody (p, cs);
      ELSE                 (* ignore *)
      END;
      v := v.next;
    END;
  END TypeCheck;

PROCEDURE <A NAME="Enter"><procedure>Enter</procedure></A> (t: T) =
  VAR v: Value.T;  c: Value.Class;
  BEGIN
    IF (t = NIL) THEN RETURN END;
    IF (t.nested) THEN CG.Begin_block () END;
    v := t.head;
    WHILE (v #  NIL) DO
      c := Value.ClassOf (v);
      IF (c # Value.Class.Procedure) THEN Value.Declare (v) END;
      v := v.next;
    END;
    v := t.head;
    WHILE (v #  NIL) DO
      c := Value.ClassOf (v);
      IF (c = Value.Class.Procedure) THEN Value.Declare (v) END;
      v := v.next;
    END;
  END Enter;

PROCEDURE <A NAME="InitValues"><procedure>InitValues</procedure></A> (t: T) =
  VAR v: Value.T;
  BEGIN
    IF t = NIL THEN RETURN; END;
    v := t.head;
    WHILE (v #  NIL) DO  Value.LangInit (v);  v := v.next;  END;
    Tracer.EmitPending ();
    v := t.head;
    WHILE (v #  NIL) DO  Value.UserInit (v);  v := v.next;  END;
    Tracer.EmitPending ();
  END InitValues;

PROCEDURE <A NAME="Exit"><procedure>Exit</procedure></A> (t: T) =
  BEGIN
    IF (t.nested) THEN CG.End_block () END;
  END Exit;

PROCEDURE <A NAME="WarnUnused"><procedure>WarnUnused</procedure></A> (t: T) =
  VAR save, level: INTEGER;  vc: Value.Class;  v: Value.T;
  BEGIN
    IF (t = NIL) THEN RETURN END;
    save := Scanner.offset;
    v := t.head;
    WHILE (v # NIL) DO
      IF (NOT v.used) AND (NOT v.exportable) THEN
        IF NOT (v.unused OR v.obsolete) THEN
          level := 2;
          vc := Value.ClassOf (v);
          IF (vc = Value.Class.Formal) OR
            ((vc = Value.Class.Var) AND Variable.IsFormal (Value.Base(v))) THEN
            level := 1;
          END;
          Scanner.offset := v.origin;
          Error.WarnID (level, v.name, &quot;not used&quot;);
	END;
      END;
      v := v.next;
    END;
    Scanner.offset := save;
  END WarnUnused;

PROCEDURE <A NAME="CheckDuplicates"><procedure>CheckDuplicates</procedure></A> (t: T) =
  VAR v: Value.T;
  BEGIN
    M3ID.AdvanceMarks ();

    (* check each name *)
    v := t.head;
    WHILE (v # NIL) DO
      IF M3ID.SetMark (v.name) THEN ReportDuplicate (t, v) END;
      v := v.next;
    END;
 END CheckDuplicates;

PROCEDURE <A NAME="ReportDuplicate"><procedure>ReportDuplicate</procedure></A> (t: T;  v1: Value.T) =
  VAR save := Scanner.offset;  v2: Value.T;
  BEGIN
    (* verify the duplicate *)
    v2 := t.head;
    WHILE (v2 # NIL) AND ((v2.name # v1.name) OR (v2 = v1)) DO
      v2 := v2.next;
    END;
    IF (v2 = NIL) THEN RETURN END;

    (* report the error *)
    Scanner.offset := v1.origin;
    IF (Value.Base (v1) = Value.Base (v2)) THEN
      (* same item duplicated =&gt; kill 2nd one *)
      Error.ID (v1.name, &quot;duplicate import&quot;);
    ELSE (* different items with the same name! *)
      Error.ID (v1.name, &quot;symbol redefined&quot;);
    END;
    Scanner.offset := save;
  END ReportDuplicate;

PROCEDURE <A NAME="ModuleName"><procedure>ModuleName</procedure></A> (v: Value.T): M3ID.T =
  BEGIN
    v := Value.Base (v);
    RETURN ScopeName (v.scope);
  END ModuleName;

PROCEDURE <A NAME="PutStack"><procedure>PutStack</procedure></A> (mbuf: M3Buf.T;  READONLY s: IDStack) =
  BEGIN
    FOR i := 0 TO s.top-1 DO M3ID.Put (mbuf, s.stk[i]); END;
  END PutStack;

PROCEDURE <A NAME="StackToText"><procedure>StackToText</procedure></A> (READONLY s: IDStack): TEXT =
  BEGIN
    IF (stack_buf = NIL) THEN stack_buf := M3Buf.New (); END;
    FOR i := 0 TO s.top-1 DO M3ID.Put (stack_buf, s.stk[i]); END;
    RETURN M3Buf.ToText (stack_buf);
  END StackToText;

PROCEDURE <A NAME="NameToPrefix"><procedure>NameToPrefix</procedure></A> (v: Value.T;
                    VAR p: IDStack;
                        considerExternal := TRUE;
                        dots := FALSE;
                        with_module := TRUE) =
  VAR t: T; count: INTEGER := 0;  dot, scope_name: M3ID.T;  save: INTEGER;
  BEGIN
    v := Value.Base (v);
    IF (dots)
      THEN dot := Dot;
      ELSE dot := DUnderscore;
    END;

    IF considerExternal AND v.external THEN
      (* simple external name:  foo  *)
      p.stk [p.top] := v.extName;
      INC (p.top);

    ELSIF v.exported OR v.imported OR v.scope.module THEN
      (* global names:   foo   module.foo  *)
      scope_name := ScopeName (v.scope);
      IF (scope_name = emptyStr) OR (NOT with_module) THEN
        p.stk [p.top] := v.name;
        INC (p.top, 1);
      ELSE
        p.stk [p.top]   := scope_name;
        p.stk [p.top+1] := dot;
        p.stk [p.top+2] := v.name;
        INC (p.top, 3);
      END;

    ELSIF with_module
      OR Value.ClassOf (v) = Value.Class.Procedure
      OR Value.ClassOf (v) = Value.Class.Expr THEN
      (* procedure or constant =&gt; fully qualified name:  module.p1.p2.p *)

      (* count how may strings we'll produce *)
      save := p.top;
      count := p.top;
      t := v.scope;
      LOOP
        IF t = NIL THEN EXIT END;
        IF (with_module) OR (NOT t.module) THEN
          scope_name := ScopeName (v.scope);
          IF scope_name # emptyStr THEN INC (count, 2); END;
        END;
        IF (NOT t.open) THEN EXIT END;
        IF (t.module) THEN EXIT END;
        t := t.parent;
      END;
      INC (count);

      p.top := count;
      DEC (count);
      p.stk [count] := v.name;
      t := v.scope;
      LOOP
        IF t = NIL THEN EXIT END;
        IF (with_module) OR (NOT t.module) THEN
          scope_name := ScopeName (t);
          IF scope_name # emptyStr THEN
            DEC (count, 2);
            p.stk [count + 1] := dot;
            p.stk [count]     := scope_name;
          END;
        END;
        IF (NOT t.open) THEN EXIT END;
        IF (t.module) THEN EXIT END;
        t := t.parent;
      END;
      &lt;* ASSERT count = save *&gt;

    ELSE
      (* variable =&gt; simple name:  foo *)
      p.stk [p.top] := v.name;
      INC (p.top);
    END;
  END NameToPrefix;

PROCEDURE <A NAME="ScopeName"><procedure>ScopeName</procedure></A> (t: T): M3ID.T =
  BEGIN
    IF (t.sname = M3ID.NoID) THEN
      IF (t.parent = NIL) THEN
        t.sname := emptyStr;
      ELSE
        INC (t.parent.children);
        t.sname := InternalName (t.parent.children);
      END;
    END;
    RETURN t.sname;
  END ScopeName;

PROCEDURE <A NAME="InternalName"><procedure>InternalName</procedure></A> (n: INTEGER): M3ID.T =
  BEGIN
    IF (n &lt; 0) OR (LAST (int_cache) &lt; n) THEN RETURN NewInt (n) END;
    IF int_cache [n] = M3ID.NoID THEN int_cache [n] := NewInt (n) END;
    RETURN int_cache [n];
  END InternalName;

PROCEDURE <A NAME="NewInt"><procedure>NewInt</procedure></A> (i: INTEGER): M3ID.T =
  &lt;*FATAL Convert.Failed*&gt;
  VAR
    buf : ARRAY [0..BITSIZE(INTEGER)-1] OF CHAR;
    len := Convert.FromInt (buf, i);
  BEGIN
    RETURN M3ID.FromStr (buf, len);
  END NewInt;

PROCEDURE <A NAME="ToUnit"><procedure>ToUnit</procedure></A> (v: Value.T): CG.Var =
  VAR t, t0: T;
  BEGIN
    v := Value.Base (v);

    (* look for the containing module scope *)
    t := v.scope;  t0 := t;
    WHILE (t # NIL) AND (t.home = NIL) DO t := t.parent END;

    IF (t = NIL) THEN RETURN NIL END;

    (* mark any intervening scopes with the same &quot;home&quot; *)
    WHILE (t0 # t) DO t0.home := t.home;  t0 := t0.parent END;

    RETURN Module.GlobalData (t.home);
  END ToUnit;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    emptyStr    := M3ID.Add (&quot;&quot;);
    Dot         := M3ID.Add (&quot;.&quot;);
    DUnderscore := M3ID.Add (&quot;__&quot;);

    Initial := PushNew (FALSE, M3ID.Add (&quot;M3_BUILTIN&quot;)(*emptyStr*));
  END Initialize;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> () =
  BEGIN
    allScopes := NIL;
    top       := Initial;
  END Reset;

BEGIN
END Scope.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
