<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/TipeDesc.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/TipeDesc.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: TipeDesc.m3                                           
 Last Modified On Tue Jul  5 16:45:55 PDT 1994 by kalsow     

<P><PRE>MODULE <module><implements><A HREF="TipeDesc.i3">TipeDesc</A></implements></module>;

IMPORT <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../../../m3middle/src/TWord.i3">TWord</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Module.i3">Module</A>, <A HREF="CG.i3">CG</A>;

TYPE
  ByteList = REF ARRAY OF [0..255];
  TypeList = REF ARRAY OF Type.T;

VAR
  busy    : BOOLEAN  := FALSE;
  bytes   : ByteList := NIL;
  n_bytes : INTEGER  := 0;
  types   : TypeList := NIL;
  n_types : INTEGER  := 0;

PROCEDURE <A NAME="Start"><procedure>Start</procedure></A> () =
  BEGIN
    &lt;*ASSERT NOT busy*&gt;
    busy := TRUE;
    IF (bytes = NIL) THEN
      bytes := NEW (ByteList, 200);
      types := NEW (TypeList, 100);
    END;
    n_bytes := 0;
    n_types := 0;
  END Start;

PROCEDURE <A NAME="Finish"><procedure>Finish</procedure></A> (a, b, c, d: TEXT := NIL): INTEGER =
  VAR base, offset, n_data_bytes: INTEGER;
  BEGIN
    IF (n_bytes = 0) THEN busy := FALSE; RETURN -1 END;

    (* add the op count *)
    n_data_bytes := n_bytes;
    AddI (n_types);

    (* allocate space *)
    base := Module.Allocate (n_bytes * Target.Int_A.size,
                             Target.Int_A.align, &quot;type_desc&quot;);
    CG.Comment (base, a, b, c, d);

    (* emit the op count *)
    offset := base;
    FOR i := n_data_bytes TO n_bytes-1 DO
      CG.Init_intt (offset, Target.Int_A.size, bytes[i]);
      INC (offset, Target.Int_A.size);
    END;

    (* generate the bytes *)
    FOR i := 0 TO n_data_bytes-1 DO
      CG.Init_intt (offset, Target.Int_A.size, bytes[i]);
      INC (offset, Target.Int_A.size);
    END;

    busy := FALSE;
    RETURN base;
  END Finish;

PROCEDURE <A NAME="AddO"><procedure>AddO</procedure></A> (o: Op;  type: Type.T): BOOLEAN =
  CONST MaxSmall = 255 - ORD (Op.Old0);
  VAR tt: Type.T;
  BEGIN
    FOR i := 0 TO n_types-1 DO
      tt := types[i];
      IF (tt # NIL) AND Type.IsEqual (tt, type, NIL) THEN
        IF (i &lt;= MaxSmall)
          THEN Stuff (ORD (Op.Old0) + i);
          ELSE Stuff (ORD (Op.OldN));  AddI (i);
        END;
        IF (n_types &gt;= NUMBER (types^)) THEN ExpandTypes () END;
        types[n_types] := NIL;  INC (n_types);
        RETURN FALSE;
      END;
    END;
    IF (n_types &gt;= NUMBER (types^)) THEN ExpandTypes () END;
    types[n_types] := type;  INC (n_types);
    Stuff (ORD (o));
    RETURN TRUE;
  END AddO;

PROCEDURE <A NAME="AddU"><procedure>AddU</procedure></A> (i: INTEGER) =
  BEGIN
    Stuff (Word.And (i, 16_ff));  i := Word.RightShift (i, 8);
    Stuff (Word.And (i, 16_ff));  i := Word.RightShift (i, 8);
    Stuff (Word.And (i, 16_ff));  i := Word.RightShift (i, 8);
    Stuff (Word.And (i, 16_ff));
  END AddU;

PROCEDURE <A NAME="AddI"><procedure>AddI</procedure></A> (i: INTEGER) =
  BEGIN
    IF (0 &lt;= i) THEN
      IF    (i &lt;= 16_3f)         THEN Stuff (i);
      ELSIF (i &lt;= 16_ff)         THEN Stuff (16_41); Stuff (i);
      ELSIF (i = 16_7fffffff)    THEN Stuff (16_7e);
      ELSIF (i = LAST(INTEGER))  THEN Stuff (16_7f);
      ELSE  AddBigInt (i);
      END;
    ELSE (* i &lt; 0 *)
      IF    (i &gt;= -16_3f)        THEN Stuff (16_80-i);
      ELSIF (i &gt;= -16_ff)        THEN Stuff (16_c1); Stuff (i);
      ELSIF (i = 16_80000000)    THEN Stuff (16_fe);
      ELSIF (i = FIRST(INTEGER)) THEN Stuff (16_ff);
      ELSE  AddBigInt (i);
      END;
    END;
  END AddI;

PROCEDURE <A NAME="AddBigInt"><procedure>AddBigInt</procedure></A> (i: INTEGER) =
  CONST Sign = ARRAY BOOLEAN OF INTEGER { 16_40, 16_c0 };
  VAR key, n_bytes: INTEGER;   x: ARRAY [0..BYTESIZE(INTEGER)-1] OF INTEGER;
  BEGIN
    key := Sign [i &lt; 0];
    IF (i &lt; 0) THEN i := Word.Minus (0, i); END;

    (* extract the bytes *)
    n_bytes := 0;
    WHILE (i # 0) DO
      x[n_bytes] := Word.And (i, 16_ff);  INC (n_bytes);
      i := Word.RightShift (i, 8);
    END;

    (* stuff'm *)
    Stuff (key + n_bytes);
    FOR i := 0 TO n_bytes-1 DO Stuff (x[i]); END;
  END AddBigInt;

PROCEDURE <A NAME="AddX"><procedure>AddX</procedure></A> (READONLY i: Target.Int) =
  VAR x: INTEGER;
  BEGIN
    IF    TInt.ToInt (i, x)             THEN AddI (x);
    ELSIF TInt.EQ (i, Target.Int_C.max) THEN Stuff (16_7e);
    ELSIF TInt.EQ (i, Target.Int_C.min) THEN Stuff (16_fe);
    ELSIF TInt.EQ (i, Target.Int_D.max) THEN Stuff (16_7f);
    ELSIF TInt.EQ (i, Target.Int_D.min) THEN Stuff (16_ff);
    ELSE  AddBigX (i);
    END;
  END AddX;

PROCEDURE <A NAME="AddBigX"><procedure>AddBigX</procedure></A> (READONLY ii: Target.Int) =
  CONST Sign = ARRAY BOOLEAN OF INTEGER { 16_40, 16_c0 };
  VAR x: TInt.ByteArray;  key, n_bytes: INTEGER;  i := ii;
  BEGIN
    key := Sign [TInt.LT (i, TInt.Zero)];
    IF (key # 16_40) THEN TWord.Subtract (TInt.Zero, ii, i); END;

    (* extract the bytes *)
    n_bytes := TInt.ToBytes (i, x);

    (* stuff'm *)
    Stuff (key + n_bytes);
    FOR i := 0 TO n_bytes-1 DO Stuff (x[i]); END;
  END AddBigX;

PROCEDURE <A NAME="Stuff"><procedure>Stuff</procedure></A> (i: INTEGER) =
  BEGIN
    &lt;*ASSERT busy*&gt;
    IF (n_bytes &gt;= NUMBER (bytes^)) THEN ExpandBytes () END;
    bytes[n_bytes] := Word.And (i, 16_ff);  INC (n_bytes);
  END Stuff;

PROCEDURE <A NAME="ExpandBytes"><procedure>ExpandBytes</procedure></A> () =
  VAR new := NEW (ByteList, 2 * NUMBER (bytes^));
  BEGIN
    SUBARRAY (new^, 0, NUMBER(bytes^)) := bytes^;
    bytes := new;
  END ExpandBytes;

PROCEDURE <A NAME="ExpandTypes"><procedure>ExpandTypes</procedure></A> () =
  VAR new := NEW (TypeList, 2 * NUMBER (types^));
  BEGIN
    SUBARRAY (new^, 0, NUMBER(types^)) := types^;
    types := new;
  END ExpandTypes;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> () =
  BEGIN
    busy    := FALSE;
    n_bytes := 0;
    n_types := 0;
    IF (types # NIL) THEN
      FOR i := FIRST (types^) TO LAST (types^) DO types[i] := NIL END;
    END;
  END Reset;

BEGIN
END TipeDesc.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
