<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/Tracer.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/Tracer.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Tracer.m3                                             
 Last Modified On Tue Jun 28 09:56:03 PDT 1994 by kalsow     

<P><PRE>MODULE <module><implements><A HREF="Tracer.i3">Tracer</A></implements></module>;
</PRE> IMPORT Error; 

<P><PRE>VAR
  emitting := FALSE;
  pending  : T := NIL;
  stack    : T := NIL;

PROCEDURE <A NAME="Schedule"><procedure>Schedule</procedure></A> (t: T) =
  BEGIN
    IF (t = NIL) THEN RETURN END;

    IF (emitting) THEN
      (*** silently ignore the new event  ***
      Error.Msg (&quot;nested &lt;*TRACE*&gt; pragmas are not allowed&quot;);
      ***)
      RETURN;
    END;

    IF (t.next = NIL) THEN
      t.next := pending;
      pending := t;
    END;
  END Schedule;

PROCEDURE <A NAME="Push"><procedure>Push</procedure></A> (t: T) =
  BEGIN
    IF (t = NIL)  THEN RETURN END;

    IF (emitting) THEN
      (*** silently ignore the new event  ***
      Error.Msg (&quot;nested &lt;*TRACE*&gt; pragmas are not allowed&quot;);
      ***)
      RETURN;
    END;

    IF (t.next = NIL) THEN
      t.next := stack;
      stack := t;
    END;
  END Push;

PROCEDURE <A NAME="Pop"><procedure>Pop</procedure></A> (tt: T) =
  VAR t := stack;
  BEGIN
    IF (tt = NIL) THEN RETURN END;
    IF (emitting) THEN RETURN END;
    IF (t = tt) THEN
      stack := t.next;
      t.next := NIL;
    END;
  END Pop;

PROCEDURE <A NAME="EmitPending"><procedure>EmitPending</procedure></A> () =
  VAR t: T;
  BEGIN
    IF (emitting) THEN RETURN END;
    emitting := TRUE;

    (* generate the one-shot traces *)
    WHILE (pending # NIL) DO
      t := pending;
      pending := t.next;
      t.next := NIL;
      t.apply ();
    END;

    (* generate the persistent traces *)
    t := stack;
    WHILE (t # NIL) DO
      t.apply ();
      t := t.next;
    END;

    emitting := FALSE;
  END EmitPending;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> () =
  BEGIN
    emitting := FALSE;
    pending  := NIL;
    stack    := NIL;
  END Reset;

BEGIN
END Tracer.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
