<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/WebInfo.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/WebInfo.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="WebInfo.m3">WebInfo</A></interface>;

IMPORT <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/M3CG.i3">M3CG</A>, <A HREF="M3.i3">M3</A>;
</PRE><P>
This interface defines the routines used to generate the WWW
browser information.


<P><PRE>TYPE (* see M3CG for the interpretation of these types *)
  Name    = M3CG.Name;
  Offset  = M3CG.BitOffset;
  Size    = M3CG.BitSize;
  TypeUID = M3CG.TypeUID;
</PRE>------------------------------------------------------ set up/tear down ---

<P><PRE>PROCEDURE <A HREF="WebInfo.m3#Reset">Reset</A> ();
</PRE><BLOCKQUOTE><EM> initializes the info. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="WebInfo.m3#Finish">Finish</A> (): TEXT;
</PRE><BLOCKQUOTE><EM> returns the accumulated browser info. </EM></BLOCKQUOTE><PRE>
</PRE>----------------------------------------------------- compilation units ---

<P><PRE>PROCEDURE <A HREF="WebInfo.m3#Import_unit">Import_unit</A> (n: Name);
PROCEDURE <A HREF="WebInfo.m3#Export_unit">Export_unit</A> (n: Name);
</PRE><BLOCKQUOTE><EM> note that the current compilation unit imports/exports the interface 'n' </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------- debugging type declarations ---

<P> The debugging information for a type is identified by small a integer
   within a compilation unit.  The information is identified by a global
   uid (an INTEGER) across compilation units. The following procedures generate
   the symbol table entries needed to describe Modula-3 types to the
   debugger.  Note that Modula-3's builtin types have the fixed IDs
   listed above.  The 'hint' passed to 'import_type' is the name of
   the source file that generated the type declaration.  

<P><PRE>PROCEDURE <A HREF="WebInfo.m3#Declare_typename">Declare_typename</A> (t: TypeUID;  x: M3.Value);

PROCEDURE <A HREF="WebInfo.m3#Declare_array">Declare_array</A> (t: TypeUID;  index, elt: TypeUID;  s: Size);
PROCEDURE <A HREF="WebInfo.m3#Declare_open_array">Declare_open_array</A> (t: TypeUID;  elt: TypeUID;  s: Size);

PROCEDURE <A HREF="WebInfo.m3#Declare_enum">Declare_enum</A> (t: TypeUID;  n_elts: INTEGER;  s: Size);
PROCEDURE <A HREF="WebInfo.m3#Declare_enum_elt">Declare_enum_elt</A> (n: Name);

PROCEDURE <A HREF="WebInfo.m3#Declare_packed">Declare_packed</A>  (t: TypeUID;  s: Size;  base: TypeUID);

PROCEDURE <A HREF="WebInfo.m3#Declare_record">Declare_record</A> (t: TypeUID;  s: Size;  n_fields: INTEGER);
PROCEDURE <A HREF="WebInfo.m3#Declare_field">Declare_field</A> (n: Name;  o: Offset;  s: Size;  t: TypeUID);

PROCEDURE <A HREF="WebInfo.m3#Declare_set">Declare_set</A> (t, domain: TypeUID;  s: Size);

PROCEDURE <A HREF="WebInfo.m3#Declare_subrange">Declare_subrange</A> (t, domain: TypeUID;  READONLY min, max: Target.Int;
                   s: Size);

PROCEDURE <A HREF="WebInfo.m3#Declare_pointer">Declare_pointer</A> (t, target: TypeUID;  brand: TEXT;  traced: BOOLEAN);

PROCEDURE <A HREF="WebInfo.m3#Declare_indirect">Declare_indirect</A> (t, target: TypeUID);

PROCEDURE <A HREF="WebInfo.m3#Declare_proctype">Declare_proctype</A> (t: TypeUID; n_formals: INTEGER;
                            result: TypeUID;  n_raises: INTEGER);
PROCEDURE <A HREF="WebInfo.m3#Declare_formal">Declare_formal</A> (n: Name;  t: TypeUID);
PROCEDURE <A HREF="WebInfo.m3#Declare_raises">Declare_raises</A> (n: Name);

PROCEDURE <A HREF="WebInfo.m3#Declare_object">Declare_object</A> (t, super: TypeUID;  brand: TEXT;  traced: BOOLEAN;
                 n_fields, n_methods, n_overrides: INTEGER;  field_size: Size);
PROCEDURE <A HREF="WebInfo.m3#Declare_method">Declare_method</A> (n: Name;  signature: TypeUID;  dfault: M3.Expr);
PROCEDURE <A HREF="WebInfo.m3#Declare_override">Declare_override</A> (n: Name;  dfault: M3.Expr);
PROCEDURE <A HREF="WebInfo.m3#Declare_opaque">Declare_opaque</A> (t, super: TypeUID);
PROCEDURE <A HREF="WebInfo.m3#Reveal_opaque">Reveal_opaque</A> (lhs, rhs: TypeUID);

END WebInfo.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
