<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/WebInfo.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/WebInfo.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="WebInfo.i3">WebInfo</A></implements></module>;

IMPORT <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="#x1">M3ID</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="Scope.i3">Scope</A>, <A HREF="../values/Module.i3">Module</A>, <A HREF="Scanner.i3">Scanner</A>;
IMPORT <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../types/UserProc.i3">UserProc</A>;

VAR
  info: M3Buf.T := NIL;
</PRE>------------------------------------------------------ set up/tear down ---

<P><PRE>PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> () =
  CONST Tag = ARRAY BOOLEAN OF CHAR { 'A', 'B' };
  VAR file: TEXT;  line: INTEGER;
  BEGIN
    IF (info = NIL) THEN info := M3Buf.New (); END;

    Scanner.LocalHere (file, line);
    OutC ('@');
    OutT (file);
    NL ();

    OutC (Tag [Module.IsInterface ()]);
    OutN (Module.Name (NIL));
    NL ();
  END Reset;

PROCEDURE <A NAME="Finish"><procedure>Finish</procedure></A> (): TEXT =
  BEGIN
    RETURN M3Buf.ToText (info);
  END Finish;
</PRE>----------------------------------------------------- compilation units ---

<P><PRE>PROCEDURE <A NAME="Import_unit"><procedure>Import_unit</procedure></A> (n: Name) =
  BEGIN
    OutC ('C');
    OutN (n);
    NL ();
  END Import_unit;

PROCEDURE <A NAME="Export_unit"><procedure>Export_unit</procedure></A> (n: Name) =
  BEGIN
    OutC ('D');
    OutN (n);
    NL ();
  END Export_unit;
</PRE>------------------------------------------- debugging type declarations ---

<P><PRE>PROCEDURE <A NAME="Declare_typename"><procedure>Declare_typename</procedure></A> (t: TypeUID;  x: Value.T) =
  BEGIN
    OutX (t, 'E');
    OutV (x);
    NL ();
  END Declare_typename;

PROCEDURE <A NAME="Declare_array"><procedure>Declare_array</procedure></A> (t: TypeUID;  index, elt: TypeUID;  s: Size) =
  BEGIN
    OutX (t, 'F');
    OutU (index);
    OutU (elt);
    OutI (s);
    NL ();
  END Declare_array;

PROCEDURE <A NAME="Declare_open_array"><procedure>Declare_open_array</procedure></A> (t: TypeUID;  elt: TypeUID;  s: Size) =
  BEGIN
    OutX (t, 'G');
    OutU (elt);
    OutI (s);
    NL ();
  END Declare_open_array;

PROCEDURE <A NAME="Declare_enum"><procedure>Declare_enum</procedure></A> (t: TypeUID;  n_elts: INTEGER;  s: Size) =
  BEGIN
    OutX (t, 'H');
    OutI (n_elts);
    OutI (s);
    NL ();
  END Declare_enum;

PROCEDURE <A NAME="Declare_enum_elt"><procedure>Declare_enum_elt</procedure></A> (n: Name) =
  BEGIN
    OutC ('I');
    OutN (n);
    NL ();
  END Declare_enum_elt;

PROCEDURE <A NAME="Declare_packed"><procedure>Declare_packed</procedure></A>  (t: TypeUID;  s: Size;  base: TypeUID) =
  BEGIN
    OutX (t, 'J');
    OutI (s);
    OutU (base);
    NL ();
  END Declare_packed ;

PROCEDURE <A NAME="Declare_record"><procedure>Declare_record</procedure></A> (t: TypeUID;  s: Size;  n_fields: INTEGER) =
  BEGIN
    OutX (t, 'K');
    OutI (s);
    OutI (n_fields);
    NL ();
  END Declare_record;

PROCEDURE <A NAME="Declare_field"><procedure>Declare_field</procedure></A> (n: Name;  o: Offset;  s: Size;  t: TypeUID) =
  BEGIN
    OutC ('L');
    OutN (n);
    OutI (o);
    OutI (s);
    OutU (t);
    NL ();
  END Declare_field;

PROCEDURE <A NAME="Declare_set"><procedure>Declare_set</procedure></A> (t, domain: TypeUID;  s: Size) =
  BEGIN
    OutX (t, 'M');
    OutU (domain);
    OutI (s);
    NL ();
  END Declare_set;

PROCEDURE <A NAME="Declare_subrange"><procedure>Declare_subrange</procedure></A> (t, domain: TypeUID;  READONLY min, max: Target.Int;
                   s: Size) =
  BEGIN
    OutX (t, 'N');
    OutU (domain);
    OutZ (min);
    OutZ (max);
    OutI (s);
    NL ();
  END Declare_subrange;

PROCEDURE <A NAME="Declare_pointer"><procedure>Declare_pointer</procedure></A> (t, target: TypeUID;  brand: TEXT; traced: BOOLEAN) =
  CONST Tag = ARRAY BOOLEAN OF CHAR { 'O', 'P' };
  BEGIN
    OutX (t, Tag [traced]);
    OutU (target);
    IF (brand # NIL) THEN
      OutC (' ');
      OutT (brand);
    END;
    NL ();
  END Declare_pointer;

PROCEDURE <A NAME="Declare_indirect"><procedure>Declare_indirect</procedure></A> (t, target: TypeUID) =
  BEGIN
    OutX (t, 'Q');
    OutU (target);
    NL ();
  END Declare_indirect;

PROCEDURE <A NAME="Declare_proctype"><procedure>Declare_proctype</procedure></A> (t: TypeUID; n_formals: INTEGER;
                            result: TypeUID;  n_raises: INTEGER) =
  BEGIN
    OutX (t, 'R');
    OutI (n_formals);
    OutU (result);
    OutI (n_raises);
    NL ();
  END Declare_proctype;

PROCEDURE <A NAME="Declare_formal"><procedure>Declare_formal</procedure></A> (n: Name;  t: TypeUID) =
  BEGIN
    OutC ('S');
    OutN (n);
    OutU (t);
    NL ();
  END Declare_formal;

PROCEDURE <A NAME="Declare_raises"><procedure>Declare_raises</procedure></A> (n: Name) =
  BEGIN
    OutC ('T');
    OutN (n);
    NL ();
  END Declare_raises;

PROCEDURE <A NAME="Declare_object"><procedure>Declare_object</procedure></A> (t, super: TypeUID;  brand: TEXT;  traced: BOOLEAN;
                n_fields, n_methods, n_overrides: INTEGER;  field_size: Size) =
  CONST Tag = ARRAY BOOLEAN OF CHAR { 'U', 'V' };
  BEGIN
    OutX (t, Tag[traced]);
    OutU (super);
    OutI (n_fields);
    OutI (n_methods);
    OutI (n_overrides);
    OutI (field_size);
    IF (brand # NIL) THEN
      OutC (' ');
      OutT (brand);
    END;
    NL ();
  END Declare_object;

PROCEDURE <A NAME="Declare_method"><procedure>Declare_method</procedure></A> (n: Name;  signature: TypeUID;  dfault: Expr.T) =
  VAR proc: Value.T;
  BEGIN
    OutC ('W');
    OutN (n);
    OutU (signature);
    IF (dfault = NIL) THEN
      (* skip *)
    ELSIF UserProc.IsProcedureLiteral (dfault, proc) THEN
      OutV (proc);
    ELSE
      OutT (&quot; NIL&quot;);
    END;
    NL ();
  END Declare_method;

PROCEDURE <A NAME="Declare_override"><procedure>Declare_override</procedure></A> (n: Name;  dfault: Expr.T) =
  VAR proc: Value.T;
  BEGIN
    OutC ('X');
    OutN (n);
    IF (dfault = NIL) THEN
      OutT (&quot; (??)&quot;);
    ELSIF UserProc.IsProcedureLiteral (dfault, proc) THEN
      OutV (proc);
    ELSE
      OutT (&quot; NIL&quot;);
    END;
    NL ();
  END Declare_override;

PROCEDURE <A NAME="Declare_opaque"><procedure>Declare_opaque</procedure></A> (t, super: TypeUID) =
  BEGIN
    OutX (t, 'Y');
    OutU (super);
    NL ();
  END Declare_opaque;

PROCEDURE <A NAME="Reveal_opaque"><procedure>Reveal_opaque</procedure></A> (lhs, rhs: TypeUID) =
  BEGIN
    OutX (lhs, 'Z');
    OutU (rhs);
    NL ();
  END Reveal_opaque;
</PRE>--------------------------------------------------------- low-level I/O ---

<P><PRE>PROCEDURE <A NAME="OutC"><procedure>OutC</procedure></A> (c: CHAR) =
  BEGIN
    M3Buf.PutChar (info, c);
  END OutC;

PROCEDURE <A NAME="OutI"><procedure>OutI</procedure></A> (i: INTEGER) =
  BEGIN
    M3Buf.PutChar (info, ' ');
    M3Buf.PutInt (info, i);
  END OutI;

PROCEDURE <A NAME="OutU"><procedure>OutU</procedure></A> (t: TypeUID) =
  BEGIN
    M3Buf.PutChar (info, ' ');
    PutHex (t);
  END OutU;

PROCEDURE <A NAME="OutN"><procedure>OutN</procedure></A> (n: Name) =
  BEGIN
    M3ID.Put (info, n);
  END OutN;

PROCEDURE <A NAME="OutX"><procedure>OutX</procedure></A> (t: TypeUID;  c: CHAR) =
  BEGIN
    M3Buf.PutChar (info, c);
    PutHex (t);
  END OutX;

PROCEDURE <A NAME="OutV"><procedure>OutV</procedure></A> (v: Value.T) =
  VAR s: Scope.IDStack;
  BEGIN
    M3Buf.PutChar (info, ' ');
    s.top := 0;
    Scope.NameToPrefix (v, s, dots := TRUE, with_module := TRUE);
    Scope.PutStack (info, s);
  END OutV;

PROCEDURE <A NAME="OutZ"><procedure>OutZ</procedure></A> (READONLY i: Target.Int) =
  BEGIN
    M3Buf.PutChar (info, ' ');
    M3Buf.PutIntt (info, i);
  END OutZ;

PROCEDURE <A NAME="OutT"><procedure>OutT</procedure></A> (t: TEXT) =
  BEGIN
    M3Buf.PutText (info, t);
  END OutT;

CONST
  HexDigit = ARRAY [0..15] OF CHAR {
                 '0','1','2','3','4','5','6','7',
                 '8','9','a','b','c','d','e','f' };

PROCEDURE <A NAME="PutHex"><procedure>PutHex</procedure></A> (i: INTEGER) =
  VAR buf: ARRAY [0..7] OF CHAR;
  BEGIN
    FOR j := 7 TO 0 BY -1 DO
      buf[j] := HexDigit [Word.Mod (i, 16)];
      i := Word.Divide (i, 16);
    END;
    M3Buf.PutSub (info, buf);
  END PutHex;

PROCEDURE <A NAME="NL"><procedure>NL</procedure></A> () =
  BEGIN
    M3Buf.PutText (info, Target.EOL);
  END NL;

BEGIN
END WebInfo.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
