<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/AssertStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/AssertStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: AssertStmt.m3                                         

<P><PRE>MODULE <module><implements><A HREF="AssertStmt.i3">AssertStmt</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>, <A HREF="../misc/Error.i3">Error</A>;
IMPORT <A HREF="../misc/Host.i3">Host</A>, <A HREF="../exprs/EnumExpr.i3">EnumExpr</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/Bool.i3">Bool</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../builtinTypes/ErrType.i3">ErrType</A>;

TYPE
  P = Stmt.T OBJECT
        e: Expr.T;
      OVERRIDES
        check       := Check;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Stmt.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    StmtRep.Init (p);
    Scanner.Match (Token.T.tASSERT);
    p.e := Expr.Parse ();
    IF (Scanner.cur.token # Token.T.tENDPRAGMA) THEN
      Scanner.Fail (&quot;missing \'*&gt;\'&quot;);
    END;
    Scanner.cur.token := Token.T.tSEMI;  (* for the statement parser *)
    RETURN p;
  END Parse;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Stmt.CheckState) =
  VAR t: Type.T;
  BEGIN
    Expr.TypeCheck (p.e, cs);
    t := Type.Base (Expr.TypeOf(p.e));
    IF (t # Bool.T) AND (t # ErrType.T) THEN
      Error.Msg (&quot;ASSERT condition must be a BOOLEAN&quot;);
    END;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P): Stmt.Outcomes =
  VAR v: Expr.T;  i: Target.Int;  u: Type.T;   skip: CG.Label;
  BEGIN
    IF Host.doAsserts THEN
      i := TInt.MOne;
      v := Expr.ConstValue (p.e);
      IF (v = NIL) THEN
        skip := CG.Next_label ();
        Expr.PrepBranch (p.e, skip, CG.No_label, CG.Always);
        Expr.CompileBranch (p.e, skip, CG.No_label, CG.Always);
        CG.Assert_fault ();
        CG.Set_label (skip);
      ELSIF EnumExpr.Split (v, i, u) AND TInt.EQ (i, TInt.Zero) THEN
        (* ASSERT (FALSE) *)
        CG.Assert_fault ();
        RETURN Stmt.Outcomes {};
      ELSE &lt;* ASSERT TInt.EQ (i, TInt.One) *&gt;
        (* ASSERT (TRUE) *)
      END;
    END;
    RETURN Stmt.Outcomes {Stmt.Outcome.FallThrough};
  END Compile;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (&lt;*UNUSED*&gt; p: P): Stmt.Outcomes =
  BEGIN
    RETURN Stmt.Outcomes {Stmt.Outcome.FallThrough};
  END GetOutcome;

BEGIN
END AssertStmt.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
