<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/AssignStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/AssignStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: AssignStmt.m3                                         

<P><PRE>MODULE <module><implements><A HREF="AssignStmt.i3">AssignStmt</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../values/Module.i3">Module</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;
IMPORT <A HREF="../misc/Token.i3">Token</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="CallStmt.i3">CallStmt</A>, <A HREF="../builtinTypes/Addr.i3">Addr</A>, <A HREF="../exprs/CheckExpr.i3">CheckExpr</A>;
IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../exprs/NamedExpr.i3">NamedExpr</A>, <A HREF="../types/ArrayType.i3">ArrayType</A>;
IMPORT <A HREF="../exprs/QualifyExpr.i3">QualifyExpr</A>, <A HREF="../values/Variable.i3">Variable</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../types/OpenArrayType.i3">OpenArrayType</A>;
IMPORT <A HREF="../exprs/ProcExpr.i3">ProcExpr</A>, <A HREF="../types/ObjectType.i3">ObjectType</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../misc/Host.i3">Host</A>, <A HREF="../builtinOps/Narrow.i3">Narrow</A>;

TYPE
  P = Stmt.T OBJECT
	lhs     : Expr.T;
	rhs     : Expr.T;
      OVERRIDES
        check       := CheckMethod;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Stmt.T =
  VAR e: Expr.T;  p: P;  s: Stmt.T;  here := Scanner.offset;
  BEGIN
    e := Expr.Parse ();
    IF (Scanner.cur.token # Token.T.tASSIGN) THEN
      IF NOT CallExpr.Is (e) THEN
	Error.Msg (&quot;Expression is not a statement&quot;);
      END;
      s := CallStmt.New (e);
      s.origin := here;
      RETURN s;
    END;	

    p := NEW (P);
    StmtRep.Init (p);
    p.origin := here;
    Scanner.GetToken (); (* := *)
    p.lhs := e;
    p.rhs := Expr.Parse ();
    RETURN p;
  END Parse;

PROCEDURE <A NAME="CheckMethod"><procedure>CheckMethod</procedure></A> (p: P;  VAR cs: Stmt.CheckState) =
  VAR tlhs: Type.T;
  BEGIN
    Expr.TypeCheck (p.lhs, cs);
    Expr.TypeCheck (p.rhs, cs);

    tlhs := Expr.TypeOf (p.lhs);
    IF  NOT Expr.IsDesignator (p.lhs) THEN
      Error.Msg (&quot;left-hand side is not a designator&quot;);
    ELSIF NOT Expr.IsWritable (p.lhs) THEN
      Error.Msg (&quot;left-hand side is read-only&quot;);
    END;

    Check (tlhs, p.rhs, cs);
  END CheckMethod;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P): Stmt.Outcomes =
  BEGIN
    Expr.PrepLValue (p.lhs);
    Expr.Prep (p.rhs);
    Expr.CompileLValue (p.lhs);
    Emit (Expr.TypeOf (p.lhs), p.rhs);
    Expr.NoteWrite (p.lhs);
    RETURN Stmt.Outcomes {Stmt.Outcome.FallThrough};
  END Compile;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (&lt;*UNUSED*&gt; p: P): Stmt.Outcomes =
  BEGIN
    RETURN Stmt.Outcomes {Stmt.Outcome.FallThrough};
  END GetOutcome;
</PRE>--------------------------------------------------------- type checking ---

<P><PRE>PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (tlhs: Type.T;  rhs: Expr.T;  VAR cs: Stmt.CheckState) =
  VAR
    t := Type.Base (tlhs); (* strip renaming and packing *)
    trhs := Expr.TypeOf (rhs);
    lhs_info, t_info: Type.Info;
    c: Type.Class;
  BEGIN
    tlhs := Type.CheckInfo (tlhs, lhs_info);
    t := Type.CheckInfo (t, t_info);
    c := t_info.class;
    Expr.TypeCheck (rhs, cs);

    IF NOT Type.IsAssignable (tlhs, trhs) THEN
      Error.Msg (&quot;types are not assignable&quot;);

    ELSIF (Type.IsOrdinal (t)) THEN
      CheckOrdinal (tlhs, rhs);

    ELSIF (c = Type.Class.Ref) OR (c = Type.Class.Object)
       OR (c = Type.Class.Opaque) THEN
      CheckReference (tlhs, trhs, lhs_info);

    ELSIF (c = Type.Class.Procedure) THEN
      CheckProcedure (rhs);

    ELSE
      (* ok *)

    END;
  END Check;

PROCEDURE <A NAME="CheckOrdinal"><procedure>CheckOrdinal</procedure></A> (tlhs: Type.T;  rhs: Expr.T) =
  VAR lmin, lmax, rmin, rmax: Target.Int;  constant: Expr.T;
  BEGIN
    (* ok, but must generate a check *)
    constant := Expr.ConstValue (rhs);
    IF (constant # NIL) THEN rhs := constant END;
    Expr.GetBounds (rhs, rmin, rmax);
    EVAL Type.GetBounds (tlhs, lmin, lmax);
    IF TInt.LE (lmin, lmax) AND TInt.LE (rmin, rmax)
      AND (TInt.LT (lmax, rmin) OR TInt.LT (rmax, lmin)) THEN
      (* non-overlappling, non-empty ranges *)
      Error.Warn (2, &quot;value not assignable (range fault)&quot;);
    END;
  END CheckOrdinal;

PROCEDURE <A NAME="CheckReference"><procedure>CheckReference</procedure></A> (tlhs, trhs: Type.T;  READONLY lhs_info: Type.Info) =
  BEGIN
    IF Type.IsSubtype (trhs, tlhs) THEN
      (* ok *)
    ELSIF NOT Type.IsSubtype (tlhs, trhs) THEN
      Error.Msg (&quot;types are not assignable&quot;);
    ELSIF Type.IsEqual (trhs, Addr.T, NIL) THEN
      (* that is legal only in UNSAFE modules *)
      IF Module.IsSafe() THEN Error.Msg (&quot;unsafe implicit NARROW&quot;) END;
    ELSIF ObjectType.Is (trhs) THEN
      (* ok *)
    ELSIF lhs_info.isTraced THEN
      (* ok *)
    ELSE
      Error.Msg (&quot;types are not assignable&quot;);
    END;
  END CheckReference;

PROCEDURE <A NAME="CheckProcedure"><procedure>CheckProcedure</procedure></A> (rhs: Expr.T) =
  BEGIN
    IF NeedsClosureCheck (rhs, TRUE) THEN
      (* may generate more detailed message *)
    END;
  END CheckProcedure;

PROCEDURE <A NAME="NeedsClosureCheck"><procedure>NeedsClosureCheck</procedure></A> (proc: Expr.T;  errors: BOOLEAN): BOOLEAN =
  VAR name: M3ID.T;  obj: Value.T;  class: Value.Class;  nested: BOOLEAN;
  BEGIN
    IF NOT (NamedExpr.Split (proc, name, obj)
            OR QualifyExpr.Split (proc, obj)
	    OR ProcExpr.Split (proc, obj)) THEN
      (* non-constant, non-variable =&gt; OK *)
      RETURN FALSE;
    END;
    obj := Value.Base (obj);
    class := Value.ClassOf (obj);
    IF (class = Value.Class.Procedure) THEN
      nested := Procedure.IsNested (obj);
      IF (nested) AND (errors) THEN
        Error.ID (Value.CName (obj), &quot;cannot assign nested procedures&quot;);
      END;
      RETURN FALSE;
    ELSIF (class = Value.Class.Var) AND Variable.HasClosure (obj) THEN
      RETURN TRUE;
    ELSE (* non-formal, non-const =&gt; no check *)
      RETURN FALSE;
    END;
  END NeedsClosureCheck;
</PRE>------------------------------------------------------- code generation ---

<P><PRE>PROCEDURE <A NAME="Emit"><procedure>Emit</procedure></A> (tlhs: Type.T;  rhs: Expr.T) =
  (* on entry the lhs is compiled and the rhs is prepped. *)
  VAR
    t := Type.Base (tlhs); (* strip renaming and packing *)
    lhs_info, t_info: Type.Info;
  BEGIN
    t := Type.CheckInfo (t, t_info);
    tlhs := Type.CheckInfo (tlhs, lhs_info);

    CASE t_info.class OF
    | Type.Class.Integer, Type.Class.Subrange, Type.Class.Enum =&gt;
        AssignOrdinal (tlhs, rhs, lhs_info);
    | Type.Class.Real, Type.Class.Longreal, Type.Class.Extended =&gt;
        AssignFloat (rhs, lhs_info);
    | Type.Class.Object, Type.Class.Opaque, Type.Class.Ref =&gt;
        AssignReference (tlhs, rhs, lhs_info);
    | Type.Class.Array, Type.Class.OpenArray =&gt;
        AssignArray (tlhs, rhs, lhs_info);
    | Type.Class.Procedure =&gt;
        AssignProcedure (rhs, lhs_info);
    | Type.Class.Record =&gt;
        AssignRecord (tlhs, rhs, lhs_info);
    | Type.Class.Set =&gt;
        AssignSet (tlhs, rhs, lhs_info);
    ELSE &lt;* ASSERT FALSE *&gt;
    END;
  END Emit;

PROCEDURE <A NAME="AssignOrdinal"><procedure>AssignOrdinal</procedure></A> (tlhs: Type.T;  rhs: Expr.T;
                         READONLY lhs_info: Type.Info) =
  VAR min, max : Target.Int;
  BEGIN
    EVAL Type.GetBounds (tlhs, min, max);
    CheckExpr.Emit (rhs, min, max);
    CG.Store_indirect (lhs_info.cg_type, 0, lhs_info.size);
  END AssignOrdinal;

PROCEDURE <A NAME="AssignFloat"><procedure>AssignFloat</procedure></A> (rhs: Expr.T;  READONLY lhs_info: Type.Info) =
  BEGIN
    Expr.Compile (rhs);
    CG.Store_indirect (lhs_info.cg_type, 0, lhs_info.size);
  END AssignFloat;

PROCEDURE <A NAME="AssignReference"><procedure>AssignReference</procedure></A> (tlhs: Type.T;  rhs: Expr.T;
                           READONLY lhs_info: Type.Info) =
  VAR lhs: CG.Val;
  BEGIN
    lhs := CG.Pop ();
    Expr.Compile (rhs);
    IF Host.doNarrowChk THEN Narrow.Emit (tlhs, Expr.TypeOf (rhs)) END;
    CG.Push (lhs);
    CG.Swap ();
    CG.Store_indirect (lhs_info.cg_type, 0, lhs_info.size);
    CG.Free (lhs);
  END AssignReference;

PROCEDURE <A NAME="AssignProcedure"><procedure>AssignProcedure</procedure></A> (rhs: Expr.T;  READONLY lhs_info: Type.Info) =
  VAR ok: CG.Label;  lhs, t1: CG.Val;
  BEGIN
    IF NOT Host.doNarrowChk THEN
      Expr.Compile (rhs);
    ELSIF NOT NeedsClosureCheck (rhs, FALSE) THEN
      Expr.Compile (rhs);
    ELSE
      lhs := CG.Pop ();
      Expr.Compile (rhs);
      t1 := CG.Pop ();
      ok := CG.Next_label ();
      CG.If_closure (t1, CG.No_label, ok, CG.Always);
      CG.Narrow_fault ();
      CG.Set_label (ok);
      CG.Push (t1);  CG.Free (t1);
      CG.Push (lhs);
      CG.Swap ();
      CG.Free (lhs);
    END;
    CG.Store_indirect (lhs_info.cg_type, 0, lhs_info.size);
  END AssignProcedure;

PROCEDURE <A NAME="AssignRecord"><procedure>AssignRecord</procedure></A> (tlhs: Type.T;  rhs: Expr.T;
                        READONLY lhs_info: Type.Info) =
  BEGIN
    AssertSameSize (tlhs, Expr.TypeOf (rhs));
    IF Expr.IsDesignator (rhs)
      THEN Expr.CompileLValue (rhs);
      ELSE Expr.Compile (rhs);
    END;
    CG.Copy (lhs_info.size, overlap := FALSE);
  END AssignRecord;

PROCEDURE <A NAME="AssignSet"><procedure>AssignSet</procedure></A> (tlhs: Type.T;  rhs: Expr.T;
                     READONLY lhs_info: Type.Info) =
  BEGIN
    AssertSameSize (tlhs, Expr.TypeOf (rhs));
    IF Type.IsStructured (tlhs) THEN
      IF Expr.IsDesignator (rhs)
        THEN Expr.CompileLValue (rhs);
        ELSE Expr.Compile (rhs);
      END;
      CG.Copy (lhs_info.size, overlap := FALSE);
    ELSE (* small set *)
      Expr.Compile (rhs);
      CG.Store_indirect (lhs_info.cg_type, 0, lhs_info.size);
    END;
  END AssignSet;

PROCEDURE <A NAME="AssertSameSize"><procedure>AssertSameSize</procedure></A> (a, b: Type.T) =
  VAR a_info, b_info: Type.Info;
  BEGIN
    EVAL Type.CheckInfo (a, a_info);
    EVAL Type.CheckInfo (b, b_info);
    IF (a_info.size # b_info.size) THEN
      Error.Msg (&quot;INTERNAL ERROR: trying to assign values of differing sizes&quot;);
      &lt;* ASSERT FALSE *&gt;
    END;
  END AssertSameSize;

PROCEDURE <A NAME="AssignArray"><procedure>AssignArray</procedure></A> (tlhs: Type.T;  e_rhs: Expr.T;
                       READONLY lhs_info: Type.Info) =
  VAR
    trhs    := Expr.TypeOf (e_rhs);
    openRHS := OpenArrayType.Is (trhs);
    openLHS := OpenArrayType.Is (tlhs);
    alignLHS:= ArrayType.EltAlign (tlhs);
    alignRHS:= ArrayType.EltAlign (trhs);
    lhs, rhs: CG.Val;
    rhs_info: Type.Info;
  BEGIN
    (* capture the lhs &amp; rhs pointers *)
    IF (openRHS) OR (openLHS) THEN lhs := CG.Pop (); END;
    IF Expr.IsDesignator (e_rhs)
      THEN Expr.CompileLValue (e_rhs);
      ELSE Expr.Compile (e_rhs);
    END;
    IF (openRHS) OR (openLHS) THEN rhs := CG.Pop (); END;

    IF openRHS AND openLHS THEN
      GenOpenArraySizeChecks (lhs, rhs, tlhs, trhs);
      CG.Push (lhs);
      CG.Open_elt_ptr (alignLHS);
      CG.Force ();
      CG.Push (rhs);
      CG.Open_elt_ptr (alignRHS);
      CG.Force ();
      GenOpenArrayCopy (rhs, tlhs, trhs);

    ELSIF openRHS THEN
      GenOpenArraySizeChecks (lhs, rhs, tlhs, trhs);
      CG.Push (lhs);
      CG.Push (rhs);
      CG.Open_elt_ptr (alignRHS);
      CG.Copy (lhs_info.size, overlap := TRUE);

    ELSIF openLHS THEN
      EVAL Type.CheckInfo (trhs, rhs_info);
      GenOpenArraySizeChecks (lhs, rhs, tlhs, trhs);
      CG.Push (lhs);
      CG.Open_elt_ptr (alignLHS);
      CG.Push (rhs);
      CG.Copy (rhs_info.size, overlap := TRUE);

    ELSE (* both sides are fixed length arrays *)
      CG.Copy (lhs_info.size, overlap := TRUE);
    END;

    IF (openRHS) OR (openLHS) THEN
      CG.Free (lhs);
      CG.Free (rhs);
    END;
  END AssignArray;

PROCEDURE <A NAME="GenOpenArraySizeChecks"><procedure>GenOpenArraySizeChecks</procedure></A> (READONLY lhs, rhs: CG.Val;
                                           tlhs, trhs: Type.T) =
  VAR ilhs, irhs, elhs, erhs: Type.T;  n := 0;
  BEGIN
    IF NOT Host.doNarrowChk THEN RETURN END;
    WHILE ArrayType.Split (tlhs, ilhs, elhs)
      AND ArrayType.Split (trhs, irhs, erhs) DO

      IF (ilhs # NIL) AND (irhs # NIL) THEN
        RETURN;
      ELSIF (ilhs # NIL) THEN
        CG.Push (rhs);
        CG.Open_size (n);
        CG.Load_integer (Type.Number (ilhs));
        CG.Check_eq ();
      ELSIF (irhs # NIL) THEN
        CG.Push (lhs);
        CG.Open_size (n);
        CG.Load_integer (Type.Number (irhs));
        CG.Check_eq ();
      ELSE (* both arrays are open *)
        CG.Push (lhs);
        CG.Open_size (n);
        CG.Push (rhs);
        CG.Open_size (n);
        CG.Check_eq ();
      END;
      INC (n);
      tlhs := elhs;
      trhs := erhs;
    END;
  END GenOpenArraySizeChecks;

PROCEDURE <A NAME="GenOpenArrayCopy"><procedure>GenOpenArrayCopy</procedure></A> (READONLY rhs: CG.Val;  tlhs, trhs: Type.T) =
  VAR
    lhs_depth := OpenArrayType.OpenDepth (tlhs);
    rhs_depth := OpenArrayType.OpenDepth (trhs);
  BEGIN
    &lt;*ASSERT (lhs_depth &gt; 0) AND (rhs_depth &gt; 0) *&gt;

    FOR i := 0 TO MIN (lhs_depth, rhs_depth) - 1 DO
      CG.Push (rhs);
      CG.Open_size (i);
      IF (i # 0) THEN CG.Multiply (CG.Type.Word) END;
    END;

    IF (lhs_depth &lt; rhs_depth)
      THEN CG.Copy_n (OpenArrayType.EltPack (tlhs), overlap := TRUE);
      ELSE CG.Copy_n (OpenArrayType.EltPack (trhs), overlap := TRUE);
    END;
  END GenOpenArrayCopy;
</PRE>---------------------------------------- code generation: checking only ---

<P><PRE>PROCEDURE <A NAME="EmitCheck"><procedure>EmitCheck</procedure></A> (tlhs: Type.T;  rhs: Expr.T) =
  (* on entry the lhs is compiled and the rhs is prepped. *)
  VAR
    t := Type.Base (tlhs); (* strip renaming and packing *)
    lhs_info, t_info: Type.Info;
  BEGIN
    t := Type.CheckInfo (t, t_info);
    tlhs := Type.CheckInfo (tlhs, lhs_info);

    CASE t_info.class OF
    | Type.Class.Integer, Type.Class.Subrange, Type.Class.Enum =&gt;
        DoCheckOrdinal (tlhs, rhs);
    | Type.Class.Real, Type.Class.Longreal, Type.Class.Extended =&gt;
        DoCheckFloat (rhs);
    | Type.Class.Object, Type.Class.Opaque, Type.Class.Ref =&gt;
        DoCheckReference (tlhs, rhs);
    | Type.Class.Array, Type.Class.OpenArray =&gt;
        DoCheckArray (tlhs, rhs);
    | Type.Class.Procedure =&gt;
        DoCheckProcedure (rhs);
    | Type.Class.Record =&gt;
        DoCheckRecord (tlhs, rhs);
    | Type.Class.Set =&gt;
        DoCheckSet (tlhs, rhs);
    ELSE &lt;* ASSERT FALSE *&gt;
    END;
  END EmitCheck;

PROCEDURE <A NAME="DoCheckOrdinal"><procedure>DoCheckOrdinal</procedure></A> (tlhs: Type.T;  rhs: Expr.T) =
  VAR min, max : Target.Int;
  BEGIN
    EVAL Type.GetBounds (tlhs, min, max);
    CheckExpr.Emit (rhs, min, max);
  END DoCheckOrdinal;

PROCEDURE <A NAME="DoCheckFloat"><procedure>DoCheckFloat</procedure></A> (rhs: Expr.T) =
  BEGIN
    Expr.Compile (rhs);
  END DoCheckFloat;

PROCEDURE <A NAME="DoCheckReference"><procedure>DoCheckReference</procedure></A> (tlhs: Type.T;  rhs: Expr.T) =
  BEGIN
    Expr.Compile (rhs);
    IF Host.doNarrowChk THEN Narrow.Emit (tlhs, Expr.TypeOf (rhs)) END;
  END DoCheckReference;

PROCEDURE <A NAME="DoCheckProcedure"><procedure>DoCheckProcedure</procedure></A> (rhs: Expr.T) =
  VAR ok: CG.Label;  t1: CG.Val;
  BEGIN
    IF NOT Host.doNarrowChk THEN
      Expr.Compile (rhs);
    ELSIF NOT NeedsClosureCheck (rhs, FALSE) THEN
      Expr.Compile (rhs);
    ELSE
      Expr.Compile (rhs);
      t1 := CG.Pop ();
      ok := CG.Next_label ();
      CG.If_closure (t1, CG.No_label, ok, CG.Always);
      CG.Narrow_fault ();
      CG.Set_label (ok);
      CG.Push (t1);  CG.Free (t1);
    END;
  END DoCheckProcedure;

PROCEDURE <A NAME="DoCheckRecord"><procedure>DoCheckRecord</procedure></A> (tlhs: Type.T;  rhs: Expr.T) =
  BEGIN
    AssertSameSize (tlhs, Expr.TypeOf (rhs));
    IF Expr.IsDesignator (rhs)
      THEN Expr.CompileLValue (rhs);
      ELSE Expr.Compile (rhs);
    END;
  END DoCheckRecord;

PROCEDURE <A NAME="DoCheckSet"><procedure>DoCheckSet</procedure></A> (tlhs: Type.T;  rhs: Expr.T) =
  BEGIN
    AssertSameSize (tlhs, Expr.TypeOf (rhs));
    IF Type.IsStructured (tlhs) THEN
      IF Expr.IsDesignator (rhs)
        THEN Expr.CompileLValue (rhs);
        ELSE Expr.Compile (rhs);
      END;
    ELSE (* small set *)
      Expr.Compile (rhs);
    END;
  END DoCheckSet;

PROCEDURE <A NAME="DoCheckArray"><procedure>DoCheckArray</procedure></A> (tlhs: Type.T;  e_rhs: Expr.T) =
  VAR
    trhs    := Expr.TypeOf (e_rhs);
    openRHS := OpenArrayType.Is (trhs);
    openLHS := OpenArrayType.Is (tlhs);
    rhs     : CG.Val;
  BEGIN
    (* evaluate the right-hand side *)
    IF Expr.IsDesignator (e_rhs)
      THEN Expr.CompileLValue (e_rhs);
      ELSE Expr.Compile (e_rhs);
    END;

    IF openLHS THEN
      Error.Msg (&quot;INTERNAL ERROR: AssignStmt.EmitCheck (OPEN ARRAY)&quot;);

    ELSIF openRHS THEN
      rhs := CG.Pop ();
      GenOpenArraySizeChk (rhs, tlhs, trhs);
      CG.Push (rhs);
      CG.Open_elt_ptr (ArrayType.EltAlign (trhs));
      CG.Free (rhs);

    ELSE (* both sides are fixed length arrays *)
      (* no more code to generate *)

    END;

  END DoCheckArray;

PROCEDURE <A NAME="GenOpenArraySizeChk"><procedure>GenOpenArraySizeChk</procedure></A> (READONLY rhs: CG.Val;  tlhs, trhs: Type.T) =
  VAR ilhs, irhs, elhs, erhs: Type.T;  n := 0;
  BEGIN
    IF NOT Host.doNarrowChk THEN RETURN END;
    WHILE ArrayType.Split (tlhs, ilhs, elhs)
      AND ArrayType.Split (trhs, irhs, erhs)
      AND (irhs = NIL) DO

      CG.Push (rhs);
      CG.Open_size (n);
      CG.Load_integer (Type.Number (ilhs));
      CG.Check_eq ();

      INC (n);
      tlhs := elhs;
      trhs := erhs;
    END;
  END GenOpenArraySizeChk;

BEGIN
END AssignStmt.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
