<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/BlockStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/BlockStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: BlockStmt.m3                                          

<P><PRE>MODULE <module><implements><A HREF="BlockStmt.i3">BlockStmt</A></implements></module>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="../values/Decl.i3">Decl</A>, <A HREF="../misc/ESet.i3">ESet</A>, <A HREF="../misc/Tracer.i3">Tracer</A>;
FROM <A HREF="../misc/Scanner.i3">Scanner</A> IMPORT Match, cur;

TYPE
  P = Stmt.T OBJECT
	scope   : Scope.T;
        body    : Stmt.T;
        fails   : ESet.T;
        trace   : TraceNode;
      OVERRIDES
        check       := Check;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (needScope: BOOLEAN): Stmt.T =
  TYPE TK = Token.T;
  VAR p: P;
  BEGIN
    p := NEW (P);
    StmtRep.Init (p);
    p.fails := NIL;

    IF (needScope)
      THEN p.scope := Scope.PushNew (TRUE, M3ID.NoID, nested := TRUE);
      ELSE p.scope := NIL;
    END;

    WHILE (cur.token IN Token.DeclStart) DO
      Decl.Parse (FALSE, FALSE, p.fails);
    END;

    Match (TK.tBEGIN);
      p.trace := ParseTrace ();
      p.body := Stmt.Parse ();
    Match (TK.tEND);

    IF (needScope) THEN Scope.PopNew () END;
    RETURN p;
  END Parse;

PROCEDURE <A NAME="ExtractFails"><procedure>ExtractFails</procedure></A> (t: Stmt.T): ESet.T =
  VAR x: ESet.T;
  BEGIN
    TYPECASE t OF
    | NULL =&gt;  RETURN NIL;
    | P(p) =&gt;  x := p.fails;  p.fails := NIL;  RETURN x;
    ELSE       RETURN NIL;
    END;
  END ExtractFails;

PROCEDURE <A NAME="BodyOffset"><procedure>BodyOffset</procedure></A> (t: Stmt.T): INTEGER =
  BEGIN
    TYPECASE t OF
    | NULL =&gt;  RETURN Scanner.offset;
    | P(p) =&gt;  IF (p.body # NIL)
                 THEN RETURN p.body.origin;
                 ELSE RETURN Scanner.offset;
               END;
    ELSE       RETURN Scanner.offset;
    END;
  END BodyOffset;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Stmt.CheckState) =
  VAR old, new: Scope.T;
  BEGIN
    new := p.scope;
    IF (new # NIL) THEN old := Scope.Push (new) END;
    ESet.TypeCheck (p.fails);
    ESet.Push (cs, NIL, p.fails, stop := FALSE);
      IF (new # NIL) THEN Scope.TypeCheck (new, cs) END;
      IF (p.trace # NIL) THEN Stmt.TypeCheck (p.trace.body, cs) END;
      Stmt.TypeCheck (p.body, cs);
      IF (new # NIL) THEN Scope.WarnUnused (new) END;
    ESet.Pop (cs, NIL, p.fails, stop := FALSE);
    IF (new # NIL) THEN Scope.Pop (old) END;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P): Stmt.Outcomes =
  VAR oc: Stmt.Outcomes;  zz: Scope.T;
  BEGIN
    IF (p.scope # NIL) THEN
      zz := Scope.Push (p.scope);
      Scope.Enter (p.scope);
      Scope.InitValues (p.scope);
      Tracer.Push (p.trace);
      oc := Stmt.Compile (p.body);
      Tracer.Pop (p.trace);
      Scope.Exit (p.scope);
      Scope.Pop (zz);
    ELSE
      Tracer.Push (p.trace);
      oc := Stmt.Compile (p.body);
      Tracer.Pop (p.trace);
    END;
    RETURN oc;
  END Compile;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (p: P): Stmt.Outcomes =
  BEGIN
    RETURN Stmt.GetOutcome (p.body);
  END GetOutcome;
</PRE>------------------------------------------------------- tracing support ---

<P><PRE>TYPE TraceNode = Tracer.T OBJECT body: Stmt.T OVERRIDES apply := DoTrace END;

PROCEDURE <A NAME="ParseTrace"><procedure>ParseTrace</procedure></A> (): Tracer.T =
  TYPE TK = Token.T;
  VAR s: Stmt.T;
  BEGIN
    IF (cur.token # TK.tTRACE) THEN RETURN NIL END;
    Match (TK.tTRACE);
    s := Stmt.Parse ();
    Match (TK.tENDPRAGMA);
    IF (s = NIL) THEN RETURN NIL END;
    RETURN NEW (TraceNode, body := s);
  END ParseTrace;

PROCEDURE <A NAME="DoTrace"><procedure>DoTrace</procedure></A> (x: TraceNode) =
  BEGIN
    EVAL Stmt.Compile (x.body);
  END DoTrace;

PROCEDURE <A NAME="CheckTrace"><procedure>CheckTrace</procedure></A> (tt: Tracer.T;  VAR cs: Stmt.CheckState) =
  VAR x: TraceNode := tt;
  BEGIN
    IF (tt = NIL) THEN RETURN END;
    Stmt.TypeCheck (x.body, cs);
  END CheckTrace;

BEGIN
END BlockStmt.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
