<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/CallStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/CallStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: CallStmt.m3                                           

<P><PRE>MODULE <module><implements><A HREF="CallStmt.i3">CallStmt</A></implements></module>;

IMPORT <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/ErrType.i3">ErrType</A>;

TYPE
  P = Stmt.T BRANDED &quot;CallStmt.P&quot; OBJECT
        e       : Expr.T;
      OVERRIDES
        check       := Check;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (e: Expr.T): Stmt.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    StmtRep.Init (p);
    p.e := e;
    RETURN p;
  END New;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Stmt.CheckState) =
  VAR t: Type.T;
  BEGIN
    Expr.TypeCheck (p.e, cs);
    t := Type.Base (Expr.TypeOf (p.e));
    IF (t # NIL) AND (t # ErrType.T) THEN
      Error.Msg (&quot;Expression is not a statement&quot;);
    END;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P): Stmt.Outcomes =
  BEGIN
    Expr.Prep (p.e);
    Expr.Compile (p.e);
    RETURN Stmt.Outcomes {Stmt.Outcome.FallThrough};
  END Compile;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (&lt;*UNUSED*&gt; p: P): Stmt.Outcomes =
  BEGIN
    RETURN Stmt.Outcomes {Stmt.Outcome.FallThrough};
  END GetOutcome;

BEGIN
END CallStmt.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
