<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/EvalStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/EvalStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: EvalStmt.m3                                           

<P><PRE>MODULE <module><implements><A HREF="EvalStmt.i3">EvalStmt</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/Type.i3">Type</A>;

TYPE
  P = Stmt.T OBJECT
        e       : Expr.T;
      OVERRIDES
        check       := Check;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Stmt.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    StmtRep.Init (p);
    Scanner.Match (Token.T.tEVAL);
    p.e := Expr.Parse ();
    RETURN p;
  END Parse;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Stmt.CheckState) =
  BEGIN
    Expr.TypeCheck (p.e, cs);
    IF (Expr.TypeOf (p.e) = NIL) THEN
      Error.Msg (&quot;expression doesn\'t have a value&quot;);
    END;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P): Stmt.Outcomes =
  BEGIN
    Expr.Prep (p.e);
    Expr.Compile (p.e);
    CG.Discard (Type.CGType (Expr.TypeOf (p.e)));
    RETURN Stmt.Outcomes {Stmt.Outcome.FallThrough};
  END Compile;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (&lt;*UNUSED*&gt; p: P): Stmt.Outcomes =
  BEGIN
    RETURN Stmt.Outcomes {Stmt.Outcome.FallThrough};
  END GetOutcome;

BEGIN
END EvalStmt.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
