<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/ExitStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/ExitStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ExitStmt.m3                                           

<P><PRE>MODULE <module><implements><A HREF="ExitStmt.i3">ExitStmt</A></implements></module>;

IMPORT <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="../misc/Marker.i3">Marker</A>;

TYPE
  P = Stmt.T OBJECT
      OVERRIDES
        check       := Check;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Stmt.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    StmtRep.Init (p);
    Scanner.Match (Token.T.tEXIT);
    RETURN p;
  END Parse;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (&lt;*UNUSED*&gt; p: P;  &lt;*UNUSED*&gt; VAR cs: Stmt.CheckState) =
  BEGIN
    IF NOT Marker.ExitOK () THEN
      Error.Msg (&quot;EXIT not contained in a loop&quot;);
    END;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (&lt;*UNUSED*&gt; p: P): Stmt.Outcomes =
  BEGIN
    Marker.EmitExit ();
    RETURN Stmt.Outcomes {Stmt.Outcome.Exits};
  END Compile;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (&lt;*UNUSED*&gt; p: P): Stmt.Outcomes =
  BEGIN
    RETURN Stmt.Outcomes {Stmt.Outcome.Exits};
  END GetOutcome;

BEGIN
END ExitStmt.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
