<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/LoopStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/LoopStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: LoopStmt.m3                                           

<P><PRE>MODULE <module><implements><A HREF="LoopStmt.i3">LoopStmt</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>, <A HREF="../misc/Marker.i3">Marker</A>, <A HREF="../misc/Token.i3">Token</A>;

TYPE
  P = Stmt.T OBJECT
        body    : Stmt.T;
      OVERRIDES
        check       := Check;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Stmt.T =
  TYPE TK = Token.T;
  VAR p := NEW (P);
  BEGIN
    StmtRep.Init (p);
    Scanner.Match (TK.tLOOP);
    p.body := Stmt.Parse ();
    Scanner.Match (TK.tEND);
    RETURN p;
  END Parse;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Stmt.CheckState) =
  BEGIN
    Marker.PushExit (CG.No_label);
    Stmt.TypeCheck (p.body, cs);
    Marker.Pop ();
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P): Stmt.Outcomes =
  VAR oc: Stmt.Outcomes;  top := CG.Next_label (2);
  BEGIN
    Marker.PushExit (top+1);
      CG.Set_label (top);
      oc := Stmt.Compile (p.body);
      IF (Stmt.Outcome.FallThrough IN oc) THEN
        CG.Jump (top);
        oc := oc - Stmt.Outcomes {Stmt.Outcome.FallThrough};
      END;
      CG.Set_label (top+1);
    Marker.Pop ();
    IF (Stmt.Outcome.Exits IN oc) THEN
      oc := oc + Stmt.Outcomes {Stmt.Outcome.FallThrough}
               - Stmt.Outcomes {Stmt.Outcome.Exits};
    END;
    RETURN oc;
  END Compile;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (p: P): Stmt.Outcomes =
  VAR oc := Stmt.GetOutcome (p.body);
  BEGIN
    oc := oc - Stmt.Outcomes {Stmt.Outcome.FallThrough};
    IF (Stmt.Outcome.Exits IN oc) THEN
      oc := oc + Stmt.Outcomes {Stmt.Outcome.FallThrough}
               - Stmt.Outcomes {Stmt.Outcome.Exits};
    END;
    RETURN oc;
  END GetOutcome;

BEGIN
END LoopStmt.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
