<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/RaiseStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/RaiseStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: RaiseStmt.m3                                          

<P><PRE>MODULE <module><implements><A HREF="RaiseStmt.i3">RaiseStmt</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../misc/ESet.i3">ESet</A>;
IMPORT <A HREF="../values/Value.i3">Value</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../values/Exceptionz.i3">Exceptionz</A>, <A HREF="AssignStmt.i3">AssignStmt</A>;

TYPE
  P = Stmt.T OBJECT
        scope   : Scope.T;
        qid     : M3.QID;
        except  : Value.T;
        arg     : Expr.T;
      OVERRIDES
        check       := Check;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Stmt.T =
  TYPE TK = Token.T;
  VAR p: P;
  BEGIN
    p := NEW (P);
    StmtRep.Init (p);
    Scanner.Match (TK.tRAISE);
    p.scope      := Scope.Top ();
    p.except     := NIL;
    p.arg        := NIL;
    p.qid.module := M3ID.NoID;
    p.qid.item   := Scanner.MatchID ();
    IF (Scanner.cur.token = TK.tDOT) THEN
      Scanner.GetToken (); (* . *)
      p.qid.module := p.qid.item;
      p.qid.item := Scanner.MatchID ();
    END;
    IF (Scanner.cur.token = TK.tLPAREN) THEN
      Scanner.GetToken ();  (* ( *)
      p.arg := Expr.Parse ();
      Scanner.Match (TK.tRPAREN);
    END;
    RETURN p;
  END Parse;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Stmt.CheckState) =
  VAR t, u: Type.T;  v: Value.T;
  BEGIN
    Expr.TypeCheck (p.arg, cs);
    t := Expr.TypeOf (p.arg);

    v := Scope.LookUpQID (p.scope, p.qid);
    Value.TypeCheck (v, cs);
    IF (v = NIL) THEN
      Error.QID (p.qid, &quot;undefined&quot;);
    ELSIF (Value.ClassOf (v) # Value.Class.Exception) THEN
      Error.QID (p.qid, &quot;not an exception&quot;);
    ELSE
      p.except := v;
      ESet.NoteException (cs, v);
    END;

    u := Exceptionz.ArgType (p.except);
    IF (p.except = NIL) THEN
      (* we've already generated an error... *)
      Expr.TypeCheck (p.arg, cs);
    ELSIF (u = NIL) THEN
      (* takes no argument *)
      IF (p.arg # NIL) THEN
        Error.QID (p.qid, &quot;exception takes no argument&quot;);
      END;
    ELSIF (p.arg = NIL) THEN
      Error.QID (p.qid, &quot;exception requires an argument&quot;);
    ELSIF NOT Type.IsAssignable (u, t) THEN
      Error.QID (p.qid, &quot;argument has wrong type&quot;);
    ELSE
      (* argument is passed by reference *)
      AssignStmt.Check (t, p.arg, cs);
    END;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P): Stmt.Outcomes =
  BEGIN
    Exceptionz.EmitRaise (p.except, p.arg);
    RETURN Stmt.Outcomes {(* Raises *)};
  END Compile;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (&lt;*UNUSED*&gt; p: P): Stmt.Outcomes =
  BEGIN
    RETURN Stmt.Outcomes {(* Raises *)};
  END GetOutcome;

BEGIN
END RaiseStmt.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
