<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/RepeatStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/RepeatStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: RepeatStmt.m3                                         

<P><PRE>MODULE <module><implements><A HREF="RepeatStmt.i3">RepeatStmt</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/Bool.i3">Bool</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>;
IMPORT <A HREF="../misc/Token.i3">Token</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="../misc/Marker.i3">Marker</A>;

TYPE
  P = Stmt.T OBJECT
        body    : Stmt.T;
        expr    : Expr.T;
        e_origin: INTEGER;
      OVERRIDES
        check       := Check;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Stmt.T =
  TYPE TK = Token.T;
  VAR p := NEW (P);
  BEGIN
    StmtRep.Init (p);
    Scanner.Match (TK.tREPEAT);
    p.body := Stmt.Parse ();
    Scanner.Match (TK.tUNTIL);
    p.e_origin := Scanner.offset;
    p.expr := Expr.Parse ();
    RETURN p;
  END Parse;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Stmt.CheckState) =
  VAR t: Type.T;
  BEGIN
    Marker.PushExit (CG.No_label);
    Stmt.TypeCheck (p.body, cs);
    Marker.Pop ();
    Expr.TypeCheck (p.expr, cs);
    t := Expr.TypeOf (p.expr);
    IF (Type.Base (t) # Bool.T) THEN
      Error.Msg (&quot;REPEAT condition must be a BOOLEAN&quot;);
    END;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P): Stmt.Outcomes =
  VAR oc: Stmt.Outcomes;  top := CG.Next_label (2);
  BEGIN
    Marker.PushExit (top+1);
      CG.Set_label (top);
      oc := Stmt.Compile (p.body);
      IF (Stmt.Outcome.FallThrough IN oc) THEN
        CG.Gen_location (p.e_origin);
        Expr.PrepBranch (p.expr, CG.No_label, top, CG.Likely);
        Expr.CompileBranch (p.expr, CG.No_label, top, CG.Likely);
      END;
      CG.Set_label (top+1);
    Marker.Pop ();

    IF (Stmt.Outcome.Exits IN oc) THEN
      oc := oc  + Stmt.Outcomes {Stmt.Outcome.FallThrough}
                - Stmt.Outcomes {Stmt.Outcome.Exits};
    END;
    RETURN oc;
  END Compile;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (p: P): Stmt.Outcomes =
  VAR oc := Stmt.GetOutcome (p.body);
  BEGIN
    IF (Stmt.Outcome.Exits IN oc) THEN
      oc := oc  + Stmt.Outcomes {Stmt.Outcome.FallThrough}
                - Stmt.Outcomes {Stmt.Outcome.Exits};
    END;
    RETURN oc;
  END GetOutcome;

BEGIN
END RepeatStmt.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
