<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/ReturnStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/ReturnStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ReturnStmt.m3                                         

<P><PRE>MODULE <module><implements><A HREF="ReturnStmt.i3">ReturnStmt</A></implements></module>;

IMPORT <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="AssignStmt.i3">AssignStmt</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="../misc/Scanner.i3">Scanner</A>;
IMPORT <A HREF="../values/Variable.i3">Variable</A>, <A HREF="../misc/Marker.i3">Marker</A>, <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>;

TYPE
  P = Stmt.T OBJECT
        expr    : Expr.T;
      OVERRIDES
        check       := Check;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Stmt.T =
  VAR p := NEW (P);
  BEGIN
    StmtRep.Init (p);
    p.expr := NIL;
    Scanner.Match (Token.T.tRETURN);
    IF (Scanner.cur.token IN Token.ExprStart) THEN
      p.expr := Expr.Parse ();
    END;
    RETURN p;
  END Parse;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Stmt.CheckState) =
  VAR t: Type.T;  v: Variable.T;
  BEGIN
    Expr.TypeCheck (p.expr, cs);
    IF NOT Marker.ReturnOK () THEN
      Error.Msg (&quot;RETURN not in a procedure&quot;);
      RETURN ;
    END;
    Marker.ReturnVar (t, v);
    IF (p.expr = NIL) THEN
      IF (t # NIL) THEN Error.Msg (&quot;missing return result&quot;) END;
    ELSIF (t = NIL) THEN
      Error.Msg (&quot;procedure does not have a return result&quot;);
    ELSE
      AssignStmt.Check (t, p.expr, cs);
    END;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P): Stmt.Outcomes =
  BEGIN
    Marker.EmitReturn (p.expr, fromFinally := FALSE);
    RETURN Stmt.Outcomes {Stmt.Outcome.Returns};
  END Compile;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (&lt;*UNUSED*&gt; p: P): Stmt.Outcomes =
  BEGIN
    RETURN Stmt.Outcomes {Stmt.Outcome.Returns};
  END GetOutcome;

BEGIN
END ReturnStmt.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
