<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/Stmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/Stmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Stmt.m3                                               

<P><PRE>MODULE <module>Stmt</module> EXPORTS <A HREF="Stmt.i3"><implements>Stmt</A></implements>, <A HREF="StmtRep.i3"><implements>StmtRep</A></implements>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="AssertStmt.i3">AssertStmt</A>, <A HREF="AssignStmt.i3">AssignStmt</A>, <A HREF="BlockStmt.i3">BlockStmt</A>, <A HREF="CaseStmt.i3">CaseStmt</A>, <A HREF="ExitStmt.i3">ExitStmt</A>;
IMPORT <A HREF="EvalStmt.i3">EvalStmt</A>, <A HREF="ForStmt.i3">ForStmt</A>, <A HREF="IfStmt.i3">IfStmt</A>, <A HREF="LockStmt.i3">LockStmt</A>, <A HREF="LoopStmt.i3">LoopStmt</A>, <A HREF="RepeatStmt.i3">RepeatStmt</A>;
IMPORT <A HREF="ReturnStmt.i3">ReturnStmt</A>, <A HREF="RaiseStmt.i3">RaiseStmt</A>, <A HREF="TryStmt.i3">TryStmt</A>, <A HREF="TypeCaseStmt.i3">TypeCaseStmt</A>, <A HREF="WhileStmt.i3">WhileStmt</A>, <A HREF="WithStmt.i3">WithStmt</A>;
IMPORT <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="../misc/Coverage.i3">Coverage</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../misc/Tracer.i3">Tracer</A>;
FROM <A HREF="../misc/Scanner.i3">Scanner</A> IMPORT GetToken, cur;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): T =
  TYPE TK = Token.T;
  VAR t, first, last: T;
  BEGIN
    first := NIL;  last := NIL;
    LOOP
      CASE cur.token OF
      | TK.tCONST,
        TK.tTYPE,
        TK.tREVEAL,
        TK.tVAR,
        TK.tEXTERNAL,
        TK.tINLINE,
        TK.tUNUSED,
        TK.tOBSOLETE,
        TK.tEXCEPTION,
        TK.tCALLCONV,
        TK.tPROCEDURE,
        TK.tFATAL,
        TK.tBEGIN    =&gt; t := BlockStmt.Parse (TRUE);
      | TK.tIDENT,
        TK.tLPAREN,
        TK.tARRAY,
        TK.tRECORD   =&gt; t := AssignStmt.Parse ();
      | TK.tASSERT   =&gt; t := AssertStmt.Parse ();
      | TK.tCASE     =&gt; t := CaseStmt.Parse ();
      | TK.tEXIT     =&gt; t := ExitStmt.Parse ();
      | TK.tEVAL     =&gt; t := EvalStmt.Parse ();
      | TK.tFOR      =&gt; t := ForStmt.Parse ();
      | TK.tIF       =&gt; t := IfStmt.Parse ();
      | TK.tLOCK     =&gt; t := LockStmt.Parse ();
      | TK.tLOOP     =&gt; t := LoopStmt.Parse ();
      | TK.tRAISE    =&gt; t := RaiseStmt.Parse ();
      | TK.tREPEAT   =&gt; t := RepeatStmt.Parse ();
      | TK.tRETURN   =&gt; t := ReturnStmt.Parse ();
      | TK.tTRY      =&gt; t := TryStmt.Parse ();
      | TK.tTYPECASE =&gt; t := TypeCaseStmt.Parse ();
      | TK.tWHILE    =&gt; t := WhileStmt.Parse ();
      | TK.tWITH     =&gt; t := WithStmt.Parse ();
      ELSE RETURN first;
      END;
      IF (first = NIL) THEN first := t ELSE last.next := t END;
      last := t;
      IF (cur.token # TK.tSEMI) THEN RETURN first END;
      GetToken (); (* ; *)
    END;
    (* RETURN first; *)
  END Parse;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t: T) =
  BEGIN
    t.next   := NIL;
    t.origin := Scanner.offset;
    Coverage.NoteLine ();
  END Init;

PROCEDURE <A NAME="TypeCheck"><procedure>TypeCheck</procedure></A> (t: T;  VAR cs: CheckState) =
  BEGIN
    WHILE (t # NIL) DO
      Scanner.offset := t.origin;
      t.check (cs);
      t := t.next;
    END;
  END TypeCheck;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (t: T): Outcomes =
  VAR oc, xc: Outcomes;  (**** x: T; ***)
  BEGIN
    (*** x := t; ****)
    oc := Outcomes {Outcome.FallThrough};
    WHILE (t # NIL) DO
      CG.Free_temps ();
      Scanner.offset := t.origin;
      CG.Gen_location (t.origin);
      Coverage.CountLine ();
      Tracer.EmitPending ();
      xc := t.compile ();
      (**** DumpOutcome (t, xc); ****)
      oc := oc + xc;
      IF (Outcome.FallThrough IN xc) THEN
        t := t.next;
      ELSE
        IF (t.next # NIL) THEN
          Scanner.offset := t.next.origin;
          Error.Warn (1, &quot;unreachable statement&quot;);
        END;
        t := NIL;
        oc := oc - Outcomes {Outcome.FallThrough};
      END;
    END;
    Tracer.EmitPending ();
    (*** DumpOutcome (x, oc); ****)
    CG.Free_temps ();
    RETURN oc;
  END Compile;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (t: T): Outcomes =
  VAR oc, xc: Outcomes;  x: T;
  BEGIN
    x := t;
    oc := Outcomes {Outcome.FallThrough};
    WHILE (t # NIL) DO
      xc := t.outcomes ();
      (**** DumpOutcome (t, xc); ****)
      oc := oc + xc;
      IF (Outcome.FallThrough IN xc) THEN
        t := t.next;
      ELSE
        t := NIL;
        oc := oc - Outcomes {Outcome.FallThrough};
      END;
    END;
    (*** DumpOutcome (x, oc); ****)
    RETURN oc;
  END GetOutcome;
</PRE>**
PROCEDURE DumpOutcome (t: T;  READONLY oc: Outcomes) =
  CONST
    Msg = ARRAY [0..7] OF TEXT {
       <CODE>stmt -&gt; {}</CODE>,
       <CODE>stmt -&gt; {FallThrough}</CODE>,
       <CODE>stmt -&gt; {Exit}</CODE>,
       <CODE>stmt -&gt; {FallThrough, Exit}</CODE>,
       <CODE>stmt -&gt; {Return}</CODE>,
       <CODE>stmt -&gt; {FallThrough, Return}</CODE>,
       <CODE>stmt -&gt; {Exit, Return}</CODE>,
       <CODE>stmt -&gt; {FallThrough, Exit, Return}</CODE>
    };
  VAR i := 0;  save: INTEGER;
  BEGIN
    IF (Outcome.FallThrough IN oc) THEN INC (i, 1) END;
    IF (Outcome.Exits       IN oc) THEN INC (i, 2) END;
    IF (Outcome.Returns     IN oc) THEN INC (i, 4) END;
    save := Scanner.offset;
    Scanner.offset := t.origin;
    Error.Warn (1, Msg[i]);
    Scanner.offset := save;
  END DumpOutcome;
****

<P><PRE>BEGIN
END Stmt.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
