<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/TryFinStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/TryFinStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: TryFinStmt.m3                                         

<P><PRE>MODULE <module><implements><A HREF="TryFinStmt.i3">TryFinStmt</A></implements></module>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>, <A HREF="../misc/Marker.i3">Marker</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;
IMPORT <A HREF="../misc/Runtime.i3">Runtime</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../misc/ProcBody.i3">ProcBody</A>, <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../misc/Host.i3">Host</A>, <A HREF="../values/Module.i3">Module</A>;
FROM <A HREF="Stmt.i3">Stmt</A> IMPORT Outcome;

TYPE
  P = Stmt.T OBJECT
        body     : Stmt.T;
        finally  : Stmt.T;
        forigin  : INTEGER;
        viaProc  : BOOLEAN;
        scope    : Scope.T;
        handler  : HandlerProc;
      OVERRIDES
        check       := Check;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

TYPE
  HandlerProc = ProcBody.T OBJECT
    self: P;
  OVERRIDES
    gen_decl := EmitDecl;
    gen_body := EmitBody;
  END;

VAR
  last_name : INTEGER := 0;
  next_uid  : INTEGER := 0;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (body: Stmt.T;  ): Stmt.T =
  TYPE TK = Token.T;
  VAR p := NEW (P);
  BEGIN
    StmtRep.Init (p);
    p.body := body;
    Scanner.Match (TK.tFINALLY);
    p.forigin := Scanner.offset;
    IF Target.Has_stack_walker THEN
      p.viaProc := FALSE;
      p.scope   := NIL;
      p.finally := Stmt.Parse ();
    ELSE
      p.handler := NEW (HandlerProc, self := p);
      ProcBody.Push (p.handler);
      p.scope := Scope.PushNew (TRUE, M3ID.NoID);
      p.finally := Stmt.Parse ();
      Scope.PopNew ();
      ProcBody.Pop ();
    END;
    Scanner.Match (TK.tEND);
    RETURN p;
  END Parse;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Stmt.CheckState) =
  VAR zz: Scope.T;  oc: Stmt.Outcomes;  name: INTEGER;
  BEGIN
    Marker.PushFinally (CG.No_label, CG.No_label, NIL);
    Stmt.TypeCheck (p.body, cs);
    Marker.Pop ();
    IF Target.Has_stack_walker THEN
      Stmt.TypeCheck (p.finally, cs);
    ELSE
      oc := Stmt.GetOutcome (p.finally);
      IF (Stmt.Outcome.Exits IN oc) OR (Stmt.Outcome.Returns IN oc) THEN
        p.viaProc := FALSE;
        Stmt.TypeCheck (p.finally, cs);
      ELSE
        p.viaProc := TRUE;
        name := p.forigin MOD 10000;
        p.handler.name := Module.Prefix (NIL) &amp; &quot;_LINE_&quot; &amp; Fmt.Int (name);
        IF (name = last_name) THEN
          INC (next_uid);
          p.handler.name := p.handler.name &amp; &quot;_&quot; &amp; Fmt.Int (next_uid);
        ELSE
          last_name := name;
          next_uid := 0;
        END;
        zz := Scope.Push (p.scope);
          Scope.TypeCheck (p.scope, cs);
          Stmt.TypeCheck (p.finally, cs);
        Scope.Pop (zz);
      END;
    END;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P): Stmt.Outcomes =
  BEGIN
    IF Target.Has_stack_walker THEN RETURN Compile1 (p);
    ELSIF p.viaProc            THEN RETURN Compile2 (p);
    ELSE                            RETURN Compile3 (p);
    END;
  END Compile;

PROCEDURE <A NAME="Compile1"><procedure>Compile1</procedure></A> (p: P): Stmt.Outcomes =
  VAR
    oc, xc, o: Stmt.Outcomes;
    l: CG.Label;
    info: CG.Var;
    proc: Procedure.T;
  BEGIN
    (* declare and initialize the info record *)
    info := CG.Declare_local (M3ID.NoID, M3RT.EI_SIZE, Target.Address.align,
                              CG.Type.Struct, 0, in_memory := TRUE,
                              up_level := FALSE, f := CG.Never);
    CG.Load_nil ();
    CG.Store_addr (info, M3RT.EI_exception);

    (* compile the body *)
    l := CG.Next_label (2);
    CG.Set_label (l, barrier := TRUE);
    Marker.PushFinally (l, l+1, info);
    Marker.SaveFrame ();
      oc := Stmt.Compile (p.body);
    Marker.Pop ();
    CG.Set_label (l+1, barrier := TRUE);

    (* compile the handler *)
    Scanner.offset := p.forigin;
    CG.Gen_location (p.forigin);
      xc := Stmt.Compile (p.finally);

    (* generate the bizzare end-tests *)

    IF (Outcome.Returns IN oc) THEN
      l := CG.Next_label ();
      CG.Load_int (info, M3RT.EI_exception);
      CG.Load_intt (Marker.Return_exception);
      CG.If_ne (l, CG.Type.Int, CG.Always);
      Marker.EmitReturn (NIL, fromFinally := TRUE);
      CG.Set_label (l);
    END;

    IF (Outcome.Exits IN oc) THEN
      l := CG.Next_label ();
      CG.Load_int (info, M3RT.EI_exception);
      CG.Load_intt (Marker.Exit_exception);
      CG.If_ne (l, CG.Type.Int, CG.Always);
      Marker.EmitExit ();
      CG.Set_label (l);
    END;

    (* resume the exception *)
    proc := Runtime.LookUpProc (Runtime.Hook.ResumeRaise);
    l := CG.Next_label ();
    CG.Load_addr (info, M3RT.EI_exception);
    CG.Load_nil ();
    CG.If_eq (l, CG.Type.Addr, CG.Always);
    Procedure.StartCall (proc);
    CG.Load_addr_of (info, 0, Target.Address.align);
    CG.Pop_param (CG.Type.Addr);
    EVAL Procedure.EmitCall (proc);
    CG.Set_label (l);

    o := Stmt.Outcomes {};
    IF Outcome.FallThrough IN xc THEN o := oc END;
    IF Outcome.Exits IN xc   THEN o := o + Stmt.Outcomes {Outcome.Exits} END;
    IF Outcome.Returns IN xc THEN o := o + Stmt.Outcomes {Outcome.Returns} END;
    RETURN o;
  END Compile1;

PROCEDURE <A NAME="Compile2"><procedure>Compile2</procedure></A> (p: P): Stmt.Outcomes =
  VAR
    oc, xc, o: Stmt.Outcomes;
    l: CG.Label;
    frame: CG.Var;
  BEGIN
    &lt;*ASSERT p.viaProc*&gt;

    (* declare and initialize the info record *)
    frame := CG.Declare_local (M3ID.NoID, M3RT.EF2_SIZE, Target.Address.align,
                               CG.Type.Struct, 0, in_memory := TRUE,
                               up_level := FALSE, f := CG.Never);
    CG.Load_procedure (p.handler.cg_proc);
    CG.Store_addr (frame, M3RT.EF2_handler);
    CG.Load_static_link (p.handler.cg_proc);
    CG.Store_addr (frame, M3RT.EF2_frame);

    (* compile the body *)
    l := CG.Next_label (2);
    CG.Set_label (l, barrier := TRUE);
    Marker.PushFrame (frame, M3RT.HandlerClass.FinallyProc);
    Marker.PushFinallyProc (l, l+1, frame);
      oc := Stmt.Compile (p.body);
    Marker.Pop ();
    IF (Outcome.FallThrough IN oc) THEN
      Marker.PopFrame (frame);
      CG.Start_call_direct (p.handler.cg_proc, p.handler.level, CG.Type.Void);
      CG.Call_direct (p.handler.cg_proc, CG.Type.Void);
    END;
    CG.Set_label (l+1, barrier := TRUE);

    Scanner.offset := p.forigin;
    CG.Gen_location (p.forigin);
    IF (Host.inline_nested_procs) THEN
      CG.Begin_procedure (p.handler.cg_proc);
      xc := Stmt.Compile (p.finally);
      CG.Exit_proc (CG.Type.Void);
      CG.End_procedure (p.handler.cg_proc);
    ELSE
      CG.Note_procedure_origin (p.handler.cg_proc);
      xc := Stmt.GetOutcome (p.finally);
    END;

    o := Stmt.Outcomes {};
    IF Outcome.FallThrough IN xc THEN o := oc END;
    IF Outcome.Exits IN xc   THEN o := o + Stmt.Outcomes {Outcome.Exits} END;
    IF Outcome.Returns IN xc THEN o := o + Stmt.Outcomes {Outcome.Returns} END;
    RETURN o;
  END Compile2;

PROCEDURE <A NAME="EmitDecl"><procedure>EmitDecl</procedure></A> (x: HandlerProc) =
  VAR p := x.self;  par: CG.Proc := NIL;
  BEGIN
    IF (p.viaProc) THEN
      IF (x.parent # NIL) THEN par := x.parent.cg_proc; END;
      x.cg_proc := CG.Declare_procedure (M3ID.Add (x.name), 0, CG.Type.Void,
                                         x.level, Target.DefaultCall,
                                         exported := FALSE, parent := par);
    END;
  END EmitDecl;

PROCEDURE <A NAME="EmitBody"><procedure>EmitBody</procedure></A> (x: HandlerProc) =
  VAR p := x.self;
  BEGIN
    IF (p.viaProc) AND (NOT Host.inline_nested_procs) THEN
      Scanner.offset := p.forigin;
      CG.Gen_location (p.forigin);
      CG.Begin_procedure (x.cg_proc);
      EVAL Stmt.Compile (p.finally);
      CG.Exit_proc (CG.Type.Void);
      CG.End_procedure (x.cg_proc);
    END;
  END EmitBody;

PROCEDURE <A NAME="Compile3"><procedure>Compile3</procedure></A> (p: P): Stmt.Outcomes =
  VAR
    oc, xc, o: Stmt.Outcomes;
    l, xx: CG.Label;
    frame: CG.Var;
    returnSeen, exitSeen: BOOLEAN;
    proc: Procedure.T;
  BEGIN
    &lt;* ASSERT NOT p.viaProc *&gt;

    (* declare and initialize the info record *)
    frame := CG.Declare_local (M3ID.NoID, M3RT.EF1_SIZE, M3RT.EF1_ALIGN,
                               CG.Type.Struct, 0, in_memory := TRUE,
                               up_level := FALSE, f := CG.Never);
    CG.Load_nil ();
    CG.Store_addr (frame, M3RT.EF1_exception);

    l := CG.Next_label (3);
    CG.Set_label (l, barrier := TRUE);
    Marker.PushFrame (frame, M3RT.HandlerClass.Finally);
    Marker.CaptureState (frame, l+1);

    (* compile the body *)
    Marker.PushFinally (l, l+1, frame);
      oc := Stmt.Compile (p.body);
    Marker.PopFinally (returnSeen, exitSeen);
    IF (Outcome.FallThrough IN oc) THEN
      Marker.PopFrame (frame);
    END;
    CG.Set_label (l+1, barrier := TRUE);

    (* compile the handler *)
    Scanner.offset := p.forigin;
    CG.Gen_location (p.forigin);
    xc := Stmt.Compile (p.finally);

    IF (Outcome.FallThrough IN xc) THEN
      (* generate the bizzare end-tests *)

      (* exceptional outcome? *)
      CG.Load_addr (frame, M3RT.EF1_exception);
      CG.Load_nil ();
      CG.If_eq (l+2, CG.Type.Addr, CG.Always);

      IF (exitSeen) THEN
        xx := CG.Next_label ();
        CG.Load_int (frame, M3RT.EF1_exception);
        CG.Load_intt (Marker.Exit_exception);
        CG.If_ne (xx, CG.Type.Int, CG.Always);
        Marker.EmitExit ();
        CG.Set_label (xx);
      END;

      IF (returnSeen) THEN
        xx := CG.Next_label ();
        CG.Load_int (frame, M3RT.EF1_exception);
        CG.Load_intt (Marker.Return_exception);
        CG.If_ne (xx, CG.Type.Int, CG.Always);
        Marker.EmitReturn (NIL, fromFinally := TRUE);
        CG.Set_label (xx);
      END;

      (* ELSE, a real exception is being raised =&gt; resume it *)
      proc := Runtime.LookUpProc (Runtime.Hook.ResumeRaise);
      Procedure.StartCall (proc);
      CG.Load_addr_of (frame, M3RT.EF1_exception, Target.Address.align);
      CG.Pop_param (CG.Type.Addr);
      EVAL Procedure.EmitCall (proc);

      CG.Set_label (l+2, barrier := TRUE);
    END;

    o := Stmt.Outcomes {};
    IF Outcome.FallThrough IN xc THEN o := oc END;
    IF Outcome.Exits IN xc   THEN o := o + Stmt.Outcomes {Outcome.Exits} END;
    IF Outcome.Returns IN xc THEN o := o + Stmt.Outcomes {Outcome.Returns} END;
    RETURN o;
  END Compile3;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (p: P): Stmt.Outcomes =
  VAR oc, xc, o: Stmt.Outcomes;
  BEGIN
    oc := Stmt.GetOutcome (p.body);
    xc := Stmt.GetOutcome (p.finally);
    o := Stmt.Outcomes {};
    IF Outcome.FallThrough IN xc THEN o := oc END;
    IF Outcome.Exits IN xc THEN o := o + Stmt.Outcomes {Outcome.Exits} END;
    IF Outcome.Returns IN xc THEN o := o + Stmt.Outcomes {Outcome.Returns} END;
    RETURN o;
  END GetOutcome;

BEGIN
END TryFinStmt.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
