<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/TryStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/TryStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: TryStmt.m3                                            

<P><PRE>MODULE <module><implements><A HREF="TryStmt.i3">TryStmt</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="../values/Variable.i3">Variable</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../values/Exceptionz.i3">Exceptionz</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../misc/Marker.i3">Marker</A>;
IMPORT <A HREF="../types/Type.i3">Type</A>, <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>, <A HREF="TryFinStmt.i3">TryFinStmt</A>, <A HREF="../misc/Token.i3">Token</A>;
IMPORT <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="../misc/ESet.i3">ESet</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>, <A HREF="../misc/Tracer.i3">Tracer</A>;
FROM <A HREF="../misc/Scanner.i3">Scanner</A> IMPORT Match, MatchID, GetToken, Fail, cur;

TYPE
  P = Stmt.T OBJECT
        scope     : Scope.T;
        body      : Stmt.T;
        h_origin  : INTEGER;
        handles   : Handler;
        hasElse   : BOOLEAN;
        elseBody  : Stmt.T;
        handled   : ESet.T;
      OVERRIDES
        check       := Check;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

TYPE
  Handler = REF RECORD
              next   : Handler;
              tags   : Except;
              type   : Type.T;
              var    : Variable.T;
              scope  : Scope.T;
              body   : Stmt.T;
              origin : INTEGER;
            END;

TYPE
  Except = REF RECORD
             next : Except;
             name : M3.QID;
             obj  : Value.T;
           END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Stmt.T =
  TYPE TK = Token.T;
  VAR s: Stmt.T;  p: P;  bar: BOOLEAN;  here := Scanner.offset;
  BEGIN
    Match (TK.tTRY);
    s := Stmt.Parse ();
    IF (cur.token = TK.tFINALLY) THEN
      s := TryFinStmt.Parse (s);
      s.origin := here;
      RETURN s;
    END;

    p := NEW (P);
    StmtRep.Init (p);
    p.origin   := here;
    p.scope    := Scope.Top ();
    p.body     := s;
    p.hasElse  := FALSE;
    p.elseBody := NIL;
    p.handled  := NIL;
    p.handles  := NIL;

    Match (TK.tEXCEPT);
    p.h_origin := Scanner.offset;
    bar := (cur.token = TK.tBAR);
    IF (bar) THEN GetToken (); (* | *)  END;
    LOOP
      IF (cur.token = TK.tELSE) THEN EXIT END;
      IF (cur.token = TK.tEND) THEN EXIT END;
      bar := FALSE;
      ParseHandler (p);
      IF (cur.token # TK.tBAR) THEN EXIT END;
      bar := TRUE; GetToken (); (* | *)
    END;

    ReverseHandlers (p);
    IF (bar) THEN
      Fail (&quot;missing handler&quot;);
    END;

    IF (cur.token = TK.tELSE) THEN
      GetToken (); (* ELSE *)
      p.hasElse := TRUE;
      p.elseBody := Stmt.Parse ();
    END;

    Match (TK.tEND);
    RETURN p;
  END Parse;

PROCEDURE <A NAME="ParseHandler"><procedure>ParseHandler</procedure></A> (p: P) =
  TYPE TK = Token.T;
  VAR h: Handler;  e: Except;  id: M3ID.T;  trace: Tracer.T;
  BEGIN
    h := NEW (Handler);
    h.next   := p.handles;  p.handles := h;
    h.tags   := NIL;
    h.type   := NIL;
    h.var    := NIL;
    h.scope  := NIL;
    h.body   := NIL;
    h.origin := Scanner.offset;
    LOOP
      e := NEW (Except);
      e.next := h.tags;  h.tags := e;
      e.obj  := NIL;
      e.name.module := M3ID.NoID;
      e.name.item   := MatchID ();
      IF (cur.token = TK.tDOT) THEN
        GetToken (); (* . *)
        e.name.module := e.name.item;
        e.name.item   := MatchID ();
      END;
      IF (cur.token # TK.tCOMMA) THEN EXIT END;
      GetToken (); (* , *)
    END;
    IF (cur.token = TK.tLPAREN) THEN
      GetToken (); (* ( *)
      id := MatchID ();
      trace := Variable.ParseTrace ();
      Match (TK.tRPAREN);
      h.var := Variable.New (id, FALSE);
      h.scope := Scope.New1 (h.var);
      Variable.BindTrace (h.var, trace);
      Match (TK.tIMPLIES);
      h.body := Stmt.Parse ();
      Scope.PopNew ();
    ELSE
      Match (TK.tIMPLIES);
      h.body := Stmt.Parse ();
    END;
  END ParseHandler;

PROCEDURE <A NAME="ReverseHandlers"><procedure>ReverseHandlers</procedure></A> (p: P) =
  VAR h1, h2, h3: Handler;
  BEGIN
    h1 := p.handles;
    h3 := NIL;
    WHILE (h1 # NIL) DO
      h2 := h1.next;
      h1.next := h3;
      h3 := h1;
      h1 := h2;
    END;
    p.handles := h3;
  END ReverseHandlers;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Stmt.CheckState) =
  VAR h: Handler;  handled: ESet.T;
  BEGIN
    h := p.handles;
    WHILE (h # NIL) DO CheckLabels (h, p.scope, cs); h := h.next; END;

    IF (p.hasElse) THEN
      Marker.PushTryElse (CG.No_label, CG.No_label, NIL);
      handled := ESet.NewAny ();
    ELSE
      handled := ESet.NewEmpty (p.scope);
      h := p.handles;
      WHILE (h # NIL) DO PushRaises (h, handled); h := h.next; END;
      p.handled := handled;
      Marker.PushTry (CG.No_label, CG.No_label, NIL, handled);
    END;
    ESet.TypeCheck (handled);

    ESet.Push (cs, handled, NIL, stop := FALSE);
    Stmt.TypeCheck (p.body, cs);
    ESet.Pop  (cs, handled, NIL, stop := FALSE);
    Marker.Pop ();

    (* check each handler *)
    h := p.handles;
    WHILE (h # NIL) DO CheckHandler (h, cs); h := h.next; END;
    Stmt.TypeCheck (p.elseBody, cs);
  END Check;

PROCEDURE <A NAME="CheckLabels"><procedure>CheckLabels</procedure></A> (h: Handler;  scope: Scope.T;  VAR cs: Stmt.CheckState) =
  VAR e: Except;  obj: Value.T;  t: Type.T;
  BEGIN
    Scanner.offset := h.origin;
    e := h.tags;
    WHILE (e # NIL) DO
      obj := Scope.LookUpQID (scope, e.name);
      IF (obj = NIL) THEN Error.QID (e.name, &quot;undefined&quot;) END;
      e.obj := obj;
      Value.TypeCheck (obj, cs);
      IF (Value.ClassOf (obj) # Value.Class.Exception) THEN
        Error.QID (e.name, &quot;is not an exception&quot;);
      ELSE
        IF (h.scope # NIL) THEN
          t := Exceptionz.ArgType (obj);
          IF (e = h.tags) THEN (* first one *)
            h.type := t;
          ELSIF NOT Type.IsEqual (t, h.type, NIL) THEN
            Error.Msg (&quot;exceptions have incompatible types&quot;);
          END;
        END;
      END;
      e := e.next;
    END;
  END CheckLabels;

PROCEDURE <A NAME="PushRaises"><procedure>PushRaises</procedure></A> (h: Handler;  handled: ESet.T) =
  VAR e: Except;
  BEGIN
    Scanner.offset := h.origin;
    e := h.tags;
    WHILE (e # NIL) DO
      ESet.Add (handled, e.name, e.obj);
      e := e.next;
    END;
  END PushRaises;

PROCEDURE <A NAME="CheckHandler"><procedure>CheckHandler</procedure></A> (h: Handler;  VAR cs: Stmt.CheckState) =
  VAR zz: Scope.T;
  BEGIN
    Scanner.offset := h.origin;
    IF (h.scope # NIL) THEN
      IF (h.type = NIL) THEN
        Error.Msg (&quot;exception(s) don\'t have a return argument&quot;);
      END;
      Variable.BindType (h.var, h.type, indirect := FALSE, readonly := FALSE,
                         needs_init := FALSE, open_array_ok := FALSE);
      IF Exceptionz.ArgByReference (h.type) THEN
        Variable.NeedsAddress (h.var);
      END;
      Scope.TypeCheck (h.scope, cs);
      zz :=Scope.Push (h.scope);
        Stmt.TypeCheck (h.body, cs);
        Scope.WarnUnused (h.scope);
      Scope.Pop (zz);
    ELSE
      Stmt.TypeCheck (h.body, cs);
    END;
  END CheckHandler;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P): Stmt.Outcomes =
  BEGIN
    IF (p.handles = NIL) AND (NOT p.hasElse) THEN
      RETURN Stmt.Compile (p.body);
    END;
    IF Target.Has_stack_walker
      THEN RETURN Compile1 (p);
      ELSE RETURN Compile2 (p);
    END;
  END Compile;

PROCEDURE <A NAME="Compile1"><procedure>Compile1</procedure></A> (p: P): Stmt.Outcomes =
  VAR
    oc: Stmt.Outcomes;
    h: Handler;
    l: CG.Label;
    info: CG.Var;
    next_handler: CG.Label;
    another: BOOLEAN;
    next_info: CG.Var;
  BEGIN
    (* declare and initialize the info record *)
    info := CG.Declare_local (M3ID.NoID, M3RT.EI_SIZE, Target.Address.align,
                              CG.Type.Struct, 0, in_memory := TRUE,
                              up_level := FALSE, f := CG.Never);
    CG.Load_nil ();
    CG.Store_addr (info, M3RT.EI_exception);

    (* compile the body *)
    l := CG.Next_label (3);
    CG.Set_label (l, barrier := TRUE);
    IF (p.hasElse)
      THEN Marker.PushTryElse (l, l+1, info);
      ELSE Marker.PushTry (l, l+1, info, p.handled);
    END;
    Marker.SaveFrame ();
      oc := Stmt.Compile (p.body);
    Marker.Pop ();
    CG.Jump (l+2);

    IF (p.hasElse) THEN
      (* EXITs and RETURNs from the body are caught by the ELSE clause *)
      oc := oc - Stmt.Outcomes {Stmt.Outcome.Returns, Stmt.Outcome.Exits};
    END;

    (* check for enclosing handlers *)
    another := Marker.NextHandler (next_handler, next_info);

    (* compile each of the handlers *)
    CG.Set_label (l+1, barrier := TRUE);
    Scanner.offset := p.h_origin;
    CG.Gen_location (p.h_origin);
    h := p.handles;
    WHILE (h # NIL) DO
      oc := oc + CompileHandler1 (h, info, l+2,
                       (NOT p.hasElse) AND (h.next = NIL) AND (NOT another));
      h := h.next;
    END;

    IF (p.hasElse) THEN
      oc := oc + Stmt.Compile (p.elseBody);
    ELSIF another THEN
      (* we didn't eat this exception =&gt; mark and invoke the next handler *)
      CG.Load_addr  (info, M3RT.EI_exception);
      CG.Store_addr (next_info, M3RT.EI_exception);
      CG.Load_addr  (info, M3RT.EI_arg);
      CG.Store_addr (next_info, M3RT.EI_arg);
      CG.Jump (next_handler);
    END;

    CG.Set_label (l+2);

    RETURN oc;
  END Compile1;

PROCEDURE <A NAME="CompileHandler1"><procedure>CompileHandler1</procedure></A> (h: Handler;  info: CG.Var;
                         resume: CG.Label;  last: BOOLEAN): Stmt.Outcomes =
  VAR
    e: Except;
    oc: Stmt.Outcomes;
    zz: Scope.T;
    top: CG.Label;
    need_top := FALSE;
    t_info: Type.Info;
  BEGIN
    top := CG.Next_label (2);

    CG.Gen_location (h.origin);

    IF (NOT last) THEN
      (* check for a match *)
      e := h.tags;
      &lt;*ASSERT e # NIL*&gt;
      WHILE (e # NIL) DO
        Value.Load (e.obj);
        CG.Load_addr (info, M3RT.EI_exception);
        e := e.next;
        IF (e # NIL)
          THEN CG.If_eq (top, CG.Type.Addr, CG.Maybe);  need_top := TRUE;
          ELSE CG.If_ne (top+1, CG.Type.Addr, CG.Maybe);
        END;
      END;
      (*** CG.Jump (top+1); ***)
    END;

    IF (need_top) THEN CG.Set_label (top) END;

    IF (h.scope # NIL) THEN
      zz := Scope.Push (h.scope);
        Scope.Enter (h.scope);
        Scope.InitValues (h.scope);
        Variable.LoadLValue (h.var);
        EVAL Type.CheckInfo (h.type, t_info);
        IF Exceptionz.ArgByReference (h.type) THEN
          CG.Load_addr (info, M3RT.EI_arg);
          CG.Boost_alignment (t_info.alignment);
          CG.Copy (t_info.size, overlap := FALSE);
        ELSE
          CG.Load_addr (info, M3RT.EI_arg);
          CG.Loophole (CG.Type.Addr, t_info.cg_type);
          CG.Store_indirect (t_info.cg_type, 0, t_info.size);
        END;
        Variable.ScheduleTrace (h.var);
        oc := Stmt.Compile (h.body);
        IF (Stmt.Outcome.FallThrough IN oc) THEN CG.Jump (resume) END;
        (* for the debugger's sake, this Jump should be inside the scope *)
        Scope.Exit (h.scope);
      Scope.Pop (zz);
    ELSE
      oc := Stmt.Compile (h.body);
      IF (Stmt.Outcome.FallThrough IN oc) THEN CG.Jump (resume) END;
    END;

    CG.Set_label (top+1);
    RETURN oc;
  END CompileHandler1;

PROCEDURE <A NAME="Compile2"><procedure>Compile2</procedure></A> (p: P): Stmt.Outcomes =
  VAR
    oc: Stmt.Outcomes;
    h: Handler;
    l: CG.Label;
    frame, eset: CG.Var;
    eoffset: INTEGER;
  BEGIN
    l := CG.Next_label (3);
    CG.Set_label (l, barrier := TRUE);

    (* declare and initialize the info record *)
    frame := CG.Declare_local (M3ID.NoID, M3RT.EF1_SIZE, M3RT.EF1_ALIGN,
                               CG.Type.Struct, 0, in_memory := TRUE,
                               up_level := FALSE, f := CG.Never);

    (**********************************************
    (* mark the frame: no exception happened yet *)
    CG.Load_nil ();
    CG.Store_addr (frame, M3RT.EF1_exception);
    ***********************************************)

    IF (p.hasElse) THEN
      Marker.PushTryElse (l, l+1, frame);
      Marker.PushFrame (frame, M3RT.HandlerClass.ExceptElse);
    ELSE
      Marker.PushTry (l, l+1, frame, p.handled);
      ESet.GetAddress (p.handled, eset, eoffset);
      CG.Load_addr_of (eset, eoffset, Target.Address.align);
      CG.Store_addr (frame, M3RT.EF1_handles);
      Marker.PushFrame (frame, M3RT.HandlerClass.Except);
    END;

    (* capture the machine state *)
    Marker.CaptureState (frame, l+1);

    (* compile the body *)
    oc := Stmt.Compile (p.body);
    Marker.Pop ();
    IF (Stmt.Outcome.FallThrough IN oc) THEN
      Marker.PopFrame (frame);
      CG.Jump (l+2);
    END;

    IF (p.hasElse) THEN
      (* EXITs and RETURNs from the body are caught by the ELSE clause *)
      oc := oc - Stmt.Outcomes {Stmt.Outcome.Returns, Stmt.Outcome.Exits};
    END;

    (* compile each of the handlers *)
    CG.Set_label (l+1, barrier := TRUE);
    Scanner.offset := p.h_origin;
    CG.Gen_location (p.h_origin);
    h := p.handles;
    WHILE (h # NIL) DO
      oc := oc + CompileHandler2 (h, frame, l+2,
                                  (NOT p.hasElse) AND (h.next = NIL));
      h := h.next;
    END;

    IF (p.hasElse) THEN
      oc := oc + Stmt.Compile (p.elseBody);
    END;

    CG.Set_label (l+2);

    RETURN oc;
  END Compile2;

PROCEDURE <A NAME="CompileHandler2"><procedure>CompileHandler2</procedure></A> (h: Handler;  frame: CG.Var;
                         resume: CG.Label;  last: BOOLEAN): Stmt.Outcomes =
  VAR
    e: Except;
    oc: Stmt.Outcomes;
    zz: Scope.T;
    top: CG.Label;
    need_top := FALSE;
    t_info: Type.Info;
  BEGIN
    top := CG.Next_label (2);

    CG.Gen_location (h.origin);

    IF (NOT last) THEN
      (* check for a match *)
      e := h.tags;
      &lt;*ASSERT e # NIL*&gt;
      WHILE (e # NIL) DO
        Value.Load (e.obj);
        CG.Load_addr (frame, M3RT.EF1_exception);
        e := e.next;
        IF (e # NIL)
          THEN CG.If_eq (top, CG.Type.Addr, CG.Maybe);  need_top := TRUE;
          ELSE CG.If_ne (top+1, CG.Type.Addr, CG.Maybe);
        END;
      END;
      (*** CG.Jump (top+1); ***)
    END;

    IF (need_top) THEN CG.Set_label (top) END;

    IF (h.scope # NIL) THEN
      zz := Scope.Push (h.scope);
        Scope.Enter (h.scope);
        Scope.InitValues (h.scope);
        Variable.LoadLValue (h.var);
        EVAL Type.CheckInfo (h.type, t_info);
        IF Exceptionz.ArgByReference (h.type) THEN
          CG.Load_addr (frame, M3RT.EF1_arg);
          CG.Boost_alignment (t_info.alignment);
          CG.Copy (t_info.size, overlap := FALSE);
        ELSE
          CG.Load_addr (frame, M3RT.EF1_arg);
          CG.Loophole (CG.Type.Addr, t_info.cg_type);
          CG.Store_indirect (t_info.cg_type, 0, t_info.size);
        END;
        Variable.ScheduleTrace (h.var);
        oc := Stmt.Compile (h.body);
        IF (Stmt.Outcome.FallThrough IN oc) THEN CG.Jump (resume) END;
        (* for the debugger's sake, this Jump should be inside the scope *)
        Scope.Exit (h.scope);
      Scope.Pop (zz);
    ELSE
      oc := Stmt.Compile (h.body);
      IF (Stmt.Outcome.FallThrough IN oc) THEN CG.Jump (resume) END;
    END;

    CG.Set_label (top+1);
    RETURN oc;
  END CompileHandler2;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (p: P): Stmt.Outcomes =
  VAR h: Handler;  oc := Stmt.GetOutcome (p.body);
  BEGIN
    IF (p.hasElse) THEN
      (* EXITs and RETURNs from the body are caught by the ELSE clause *)
      oc := oc - Stmt.Outcomes {Stmt.Outcome.Returns, Stmt.Outcome.Exits};
    END;

    h := p.handles;
    WHILE (h # NIL) DO
      oc := oc + Stmt.GetOutcome (h.body);
      h := h.next;
    END;

    IF (p.hasElse) THEN
      oc := oc + Stmt.GetOutcome (p.elseBody)
    END;

    RETURN oc;
  END GetOutcome;

BEGIN
END TryStmt.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
