<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/stmts/WhileStmt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/stmts/WhileStmt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: WhileStmt.m3                                          

<P><PRE>MODULE <module><implements><A HREF="WhileStmt.i3">WhileStmt</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/Bool.i3">Bool</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../misc/Marker.i3">Marker</A>, <A HREF="../builtinTypes/ErrType.i3">ErrType</A>;
IMPORT <A HREF="Stmt.i3">Stmt</A>, <A HREF="StmtRep.i3">StmtRep</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="../misc/Scanner.i3">Scanner</A>;

TYPE
  P = Stmt.T OBJECT
        cond    : Expr.T;
        body    : Stmt.T;
      OVERRIDES
        check       := Check;
	compile     := Compile;
        outcomes    := GetOutcome;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Stmt.T =
  TYPE TK = Token.T;
  VAR p := NEW (P);
  BEGIN
    StmtRep.Init (p);
    Scanner.Match (TK.tWHILE);
    p.cond := Expr.Parse ();
    Scanner.Match (TK.tDO);
    p.body := Stmt.Parse ();
    Scanner.Match (TK.tEND);
    RETURN p;
  END Parse;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Stmt.CheckState) =
  VAR t: Type.T;
  BEGIN
    Expr.TypeCheck (p.cond, cs);
    t := Expr.TypeOf (p.cond);
    IF (Type.Base (t) # Bool.T) AND (t # ErrType.T) THEN
      Error.Msg (&quot;WHILE condition must be a BOOLEAN&quot;);
    END;
    Marker.PushExit (CG.No_label);
    Stmt.TypeCheck (p.body, cs);
    Marker.Pop ();
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P): Stmt.Outcomes =
  VAR oc: Stmt.Outcomes;  top := CG.Next_label (3);
  BEGIN
    Marker.PushExit (top+2);
      CG.Jump (top+1);
      CG.Set_label (top);
      oc := Stmt.Compile (p.body);
      CG.Gen_location (p.origin);
      CG.Set_label (top+1);
      Expr.PrepBranch (p.cond, top, CG.No_label, CG.Likely);
      Expr.CompileBranch (p.cond, top, CG.No_label, CG.Likely);
      CG.Set_label (top+2);
    Marker.Pop ();

    (* A WHILE statement can always FallThrough; consider the case where
       the condition is initially FALSE *)
    RETURN oc + Stmt.Outcomes {Stmt.Outcome.FallThrough}
              - Stmt.Outcomes {Stmt.Outcome.Exits};
  END Compile;

PROCEDURE <A NAME="GetOutcome"><procedure>GetOutcome</procedure></A> (p: P): Stmt.Outcomes =
  BEGIN
    RETURN Stmt.GetOutcome (p.body)
            + Stmt.Outcomes {Stmt.Outcome.FallThrough}
            - Stmt.Outcomes {Stmt.Outcome.Exits};
  END GetOutcome;

BEGIN
END WhileStmt.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
