<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/types/EnumType.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/types/EnumType.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: EnumType.m3                                           

<P><PRE>MODULE <module><implements><A HREF="EnumType.i3">EnumType</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="Type.i3">Type</A>, <A HREF="TypeRep.i3">TypeRep</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="../values/Ident.i3">Ident</A>;
IMPORT <A HREF="../values/EnumElt.i3">EnumElt</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="../builtinTypes/CChar.i3">CChar</A>, <A HREF="../builtinTypes/Bool.i3">Bool</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../misc/TipeMap.i3">TipeMap</A>, <A HREF="../misc/TipeDesc.i3">TipeDesc</A>;
IMPORT <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../../../m3middle/src/TargetMap.i3">TargetMap</A>;

TYPE
  Rep = [FIRST (TargetMap.Int_types) .. LAST (TargetMap.Int_types)];

TYPE
  P = Type.T BRANDED &quot;EnumType.m3&quot; OBJECT
	n_elts     : INTEGER;
	scope      : Scope.T;
	rep        : Rep;
      OVERRIDES
        check      := Check;
        check_align:= CheckAlign;
        isEqual    := EqualChk;
        isSubtype  := Subtyper;
        compile    := Compiler;
        initCost   := InitCoster;
        initValue  := TypeRep.InitToZeros;
        mapper     := GenMap;
        gen_desc   := GenDesc;
        fprint     := FPrinter;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Type.T =
  TYPE TK = Token.T;
  VAR n, j: INTEGER;  p: P;  val: Target.Int;  b: BOOLEAN;
  BEGIN
    p := Create (Scope.PushNew (FALSE, M3ID.NoID));
    n := 0;
    Scanner.Match (TK.tLBRACE);
    IF (Scanner.cur.token = TK.tIDENT) THEN
      n := Ident.ParseList ();
      j := Ident.top - n;
      FOR i := 0 TO n - 1 DO
        b := TInt.FromInt (i, val); &lt;*ASSERT b*&gt;
        Scope.Insert (EnumElt.New (Ident.stack[j + i], val, p));
      END;
      DEC (Ident.top, n);
    END;
    Scanner.Match (TK.tRBRACE);
    Scope.PopNew ();
    p.n_elts := n;
    SetRep (p);
    RETURN p;
  END Parse;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (n_elts: INTEGER;  elts: Scope.T): Type.T =
  VAR p: P;
  BEGIN
    p := Create (elts);
    p.n_elts := n_elts;
    SetRep (p);
    RETURN p;
  END New;

PROCEDURE <A NAME="Reduce"><procedure>Reduce</procedure></A> (t: Type.T): P =
  BEGIN
    IF (t = NIL) THEN RETURN NIL END;
    IF (t.info.class = Type.Class.Named) THEN t := Type.Strip (t) END;
    IF (t.info.class # Type.Class.Enum) THEN RETURN NIL END;
    RETURN t;
  END Reduce;

PROCEDURE <A NAME="Is"><procedure>Is</procedure></A> (t: Type.T): BOOLEAN =
  BEGIN
    RETURN (Reduce (t) # NIL);
  END Is;

PROCEDURE <A NAME="LookUp"><procedure>LookUp</procedure></A> (t: Type.T;  name: M3ID.T;  VAR value: Value.T): BOOLEAN =
  VAR p := Reduce (t);
  BEGIN
    IF (p = NIL) THEN RETURN FALSE END;
    value := Scope.LookUp (p.scope, name, TRUE);
    RETURN (value # NIL);
  END LookUp;

PROCEDURE <A NAME="NumElts"><procedure>NumElts</procedure></A> (t: Type.T): INTEGER =
  VAR p: P := t;
  BEGIN
    RETURN p.n_elts;
  END NumElts;
</PRE>**********************************************************************

<P><PRE>PROCEDURE <A NAME="Create"><procedure>Create</procedure></A> (elts: Scope.T): P =
  VAR p: P;
  BEGIN
    p := NEW (P);
    TypeRep.Init (p, Type.Class.Enum);
    p.scope := elts;
    p.n_elts := 0;
    RETURN p;
  END Create;

PROCEDURE <A NAME="SetRep"><procedure>SetRep</procedure></A> (p: P) =
  VAR max: Target.Int;
  BEGIN
    IF NOT TInt.FromInt (p.n_elts-1, max) THEN
      Error.Msg (&quot;enumeration type too large&quot;);
    END;
    FOR i := FIRST (Rep) TO LAST (Rep) DO
      IF TInt.LE (max, TargetMap.Int_types[i].max) THEN
        p.rep := i; RETURN;
      END;
    END;
    p.rep := LAST (Rep);
  END SetRep;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P) =
  VAR v: Value.T;  hash: INTEGER;  cs := M3.OuterCheckState;
  BEGIN
    Scope.TypeCheck (p.scope, cs);
    v := Scope.ToList (p.scope);
    hash := 37;
    WHILE (v # NIL) DO
      hash := Word.Plus (Word.Times (hash, 67), M3ID.Hash (Value.CName (v)));
      v := v.next;
    END;

    p.info.size      := TargetMap.Int_types[p.rep].size;
    p.info.min_size  := MinSize (p);
    p.info.alignment := TargetMap.Int_types[p.rep].align;
    p.info.cg_type   := TargetMap.CG_Base [TargetMap.Int_types[p.rep].cg_type];
    p.info.class     := Type.Class.Enum;
    p.info.isTraced  := FALSE;
    p.info.isEmpty   := (p.n_elts &lt;= 0);
    p.info.isSolid   := TRUE;
    p.info.hash      := hash;
  END Check;

PROCEDURE <A NAME="CheckAlign"><procedure>CheckAlign</procedure></A> (p: P;  offset: INTEGER): BOOLEAN =
  VAR
    sz := TargetMap.Int_types [p.rep].size;
    z0 := offset DIV Target.Integer.align * Target.Integer.align;
  BEGIN
    RETURN (offset + sz) &lt;= (z0 + Target.Integer.size);
  END CheckAlign;

PROCEDURE <A NAME="Compiler"><procedure>Compiler</procedure></A> (p: P) =
  VAR v := Scope.ToList (p.scope);
  BEGIN
    CG.Declare_enum (Type.GlobalUID (p), p.n_elts,
                     TargetMap.Int_types[p.rep].size);
    WHILE (v # NIL) DO
      CG.Declare_enum_elt (Value.CName (v));
      v := v.next;
    END;
  END Compiler;

PROCEDURE <A NAME="EqualChk"><procedure>EqualChk</procedure></A> (a: P;  t: Type.T;  &lt;*UNUSED*&gt;x: Type.Assumption): BOOLEAN =
  VAR b: P := t;  oa, ob : Value.T;
  BEGIN
    IF (a.n_elts # b.n_elts) THEN RETURN FALSE END;
    IF (a.n_elts = 0) THEN RETURN TRUE END;
    IF (a.scope = NIL) OR (b.scope = NIL) THEN
      RETURN (a.scope = b.scope);
    END;

    (* get a handle on the elements *)
    oa := Scope.ToList (a.scope);
    ob := Scope.ToList (b.scope);

    (* compare the elements *)
    WHILE (oa # NIL) AND (ob # NIL) AND EnumElt.IsEqual (oa, ob) DO
      oa := oa.next;  ob := ob.next;
    END;

    RETURN (oa = NIL) AND (ob = NIL);
  END EqualChk;

PROCEDURE <A NAME="Subtyper"><procedure>Subtyper</procedure></A> (a: P;  t: Type.T): BOOLEAN =
  BEGIN
    RETURN Type.IsEqual (a, t, NIL);
  END Subtyper;

PROCEDURE <A NAME="MinSize"><procedure>MinSize</procedure></A> (p: P): INTEGER =
  VAR i, j, n: INTEGER;
  BEGIN
    j := 1;  i := 2;  n := p.n_elts;
    WHILE (n &gt; i) DO INC (j); INC (i, i);  END;
    RETURN j;
  END MinSize;

PROCEDURE <A NAME="InitCoster"><procedure>InitCoster</procedure></A> (p: P;  zeroed: BOOLEAN): INTEGER =
  VAR max: Target.Int;
  BEGIN
    IF (p.n_elts &lt;= 0) OR (zeroed) THEN RETURN 0; END;
    IF NOT TInt.FromInt (p.n_elts-1, max) THEN RETURN 1 END;
    IF TInt.EQ (TargetMap.Int_types[p.rep].min, TInt.Zero)
      AND TInt.EQ (TargetMap.Int_types[p.rep].max, max)
      THEN RETURN 0;
      ELSE RETURN 1;
    END;
  END InitCoster;

PROCEDURE <A NAME="GenMap"><procedure>GenMap</procedure></A> (&lt;*UNUSED*&gt; p: P; offset, size: INTEGER; refs_only: BOOLEAN) =
  VAR bit_offset := offset MOD Target.Byte;  op: TipeMap.Op;
  BEGIN
    IF (refs_only) THEN RETURN END;
    IF (bit_offset # 0) THEN             op := TipeMap.Op.Word_Field;
    ELSIF (size = 1 * Target.Byte) THEN  op := TipeMap.Op.Word_1;
    ELSIF (size = 2 * Target.Byte) THEN  op := TipeMap.Op.Word_2;
    ELSIF (size = 4 * Target.Byte) THEN  op := TipeMap.Op.Word_4;
    ELSIF (size = 8 * Target.Byte) THEN  op := TipeMap.Op.Word_8;
    ELSE (* weird size *)                op := TipeMap.Op.Word_Field;
    END;
    TipeMap.Add (offset, op, bit_offset + 256 * size);
  END GenMap;

PROCEDURE <A NAME="GenDesc"><procedure>GenDesc</procedure></A> (p: P) =
  BEGIN
    IF Type.IsEqual (p, CChar.T, NIL) THEN
      EVAL TipeDesc.AddO (TipeDesc.Op.Char, p);
    ELSIF Type.IsEqual (p, Bool.T, NIL) THEN
      EVAL TipeDesc.AddO (TipeDesc.Op.Boolean, p);
    ELSIF TipeDesc.AddO (TipeDesc.Op.Enum, p) THEN
      TipeDesc.AddI (p.n_elts);
    END;
  END GenDesc;

PROCEDURE <A NAME="FPrinter"><procedure>FPrinter</procedure></A> (p: P;  VAR x: M3.FPInfo) =
  VAR v: Value.T;
  BEGIN
    x.n_nodes := 0;
    IF Type.IsEqual (p, CChar.T, NIL) THEN
      x.tag := &quot;$char&quot;;
    ELSIF Type.IsEqual (p, Bool.T, NIL) THEN
      x.tag := &quot;$boolean&quot;;
    ELSE
      M3Buf.PutText (x.buf, &quot;ENUM&quot;);
      v := Scope.ToList (p.scope);
      WHILE (v # NIL) DO
        M3Buf.PutChar (x.buf, ' ');
        M3ID.Put      (x.buf, Value.CName (v));
        v := v.next;
      END;
    END;
  END FPrinter;

BEGIN
END EnumType.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
