<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/types/NamedType.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/types/NamedType.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: NamedType.m3                                          

<P><PRE>MODULE <module><implements><A HREF="NamedType.i3">NamedType</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="Type.i3">Type</A>, <A HREF="TypeRep.i3">TypeRep</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="ObjectType.i3">ObjectType</A>;
IMPORT <A HREF="../misc/Error.i3">Error</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="RefType.i3">RefType</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../builtinTypes/ErrType.i3">ErrType</A>;

TYPE
  P = Type.T BRANDED &quot;NamedType.T&quot; OBJECT
        scope      : Scope.T;
	qid        : M3.QID;
	type       : Type.T;
        obj        : Value.T;
      OVERRIDES
        check      := Check;
        check_align:= CheckAlign;
        isEqual    := TypeRep.NeverEqual;
        isSubtype  := TypeRep.NoSubtypes;
        compile    := Compiler;
        initCost   := InitCoster;
        initValue  := GenInit;
        mapper     := GenMap;
        gen_desc   := GenDesc;
        fprint     := FPrinter;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Type.T =
  TYPE TK = Token.T;
  VAR p: P;  t: Type.T;
  BEGIN
    IF (Scanner.cur.token = TK.tIDENT)
      AND (Scanner.cur.defn # NIL)
      AND (Value.ClassOf (Scanner.cur.defn) = Value.Class.Type) THEN
      (* this identifier is reserved! *)
      t := Value.ToType (Scanner.cur.defn);
      Scanner.GetToken (); (* IDENT *)
    ELSE
      (* this is a non-reserved ID *)
      p := NEW (P);
      TypeRep.Init (p, Type.Class.Named);
      p.scope      := Scope.Top ();
      p.type       := NIL;
      p.obj        := NIL;
      p.qid.module := M3ID.NoID;
      p.qid.item   := Scanner.MatchID ();
      IF (Scanner.cur.token = TK.tDOT) THEN
        Scanner.GetToken (); (* . *)
        p.qid.module := p.qid.item;
        p.qid.item   := Scanner.MatchID ();
      END;
      t := p;
    END;

    IF (Scanner.cur.token = TK.tBRANDED) THEN
      t := ObjectType.Parse (t, FALSE, RefType.ParseBrand ());
    ELSIF (Scanner.cur.token = TK.tOBJECT) THEN
      t := ObjectType.Parse (t, FALSE, NIL);
    END;
    RETURN t;
  END Parse;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (t: Type.T): Type.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    TypeRep.Init (p, Type.Class.Named);
    p.scope      := NIL;
    p.qid.module := M3ID.NoID;
    p.qid.item   := M3ID.NoID;
    p.type       := t;
    p.obj        := NIL;
    RETURN p;
  END New;

PROCEDURE <A NAME="Create"><procedure>Create</procedure></A> (m, n: M3ID.T): Type.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    TypeRep.Init (p, Type.Class.Named);
    p.scope      := Scope.Top ();
    p.qid.module := m;
    p.qid.item   := n;
    p.type       := NIL;
    p.obj        := NIL;
    RETURN p;
  END Create;

PROCEDURE <A NAME="Reduce"><procedure>Reduce</procedure></A> (t: Type.T): P =
  BEGIN
    IF (t = NIL) THEN RETURN NIL END;
    IF (t.info.class # Type.Class.Named) THEN RETURN NIL END;
    RETURN t;
  END Reduce;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (t: Type.T;  VAR name: M3.QID): BOOLEAN =
  VAR p := Reduce (t);
  BEGIN
    IF (p = NIL) THEN RETURN FALSE END;
    name := p.qid;
    RETURN TRUE;
  END Split;

PROCEDURE <A NAME="SplitV"><procedure>SplitV</procedure></A> (t: Type.T;  VAR v: Value.T): BOOLEAN =
  VAR p := Reduce (t);
  BEGIN
    IF (p = NIL) THEN RETURN FALSE END;
    Resolve (p);
    v := p.obj;
    RETURN TRUE;
  END SplitV;

PROCEDURE <A NAME="Resolve"><procedure>Resolve</procedure></A> (p: P) =
  VAR o: Value.T;  t: Type.T;  save: INTEGER;
  BEGIN
    IF (p.type = NIL) THEN
      o := Scope.LookUpQID (p.scope, p.qid);
      p.obj := o;
      IF (o = NIL) THEN
        save := Scanner.offset;
        Scanner.offset := p.origin;
        Error.QID (p.qid, &quot;undefined&quot;);
        Scanner.offset := save;
        t := ErrType.T;
      ELSIF (Value.ClassOf (o) = Value.Class.Type) THEN
        t := Value.ToType (o);
      ELSE
        save := Scanner.offset;
        Scanner.offset := p.origin;
        Error.QID (p.qid, &quot;name isn\'t bound to a type&quot;);
        Scanner.offset := save;
        t := ErrType.T;
      END;
      p.type := t;
    END;
  END Resolve;

PROCEDURE <A NAME="Strip"><procedure>Strip</procedure></A> (t: Type.T): Type.T =
  VAR p: P := t;
  BEGIN
    IF (p.type = NIL) THEN Resolve (p) END;
    RETURN p.type;
  END Strip;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P) =
  VAR cs := M3.OuterCheckState;  nErrs, nWarns, nErrsB: INTEGER;
  BEGIN
    IF (p.type = NIL) THEN Resolve (p) END;
    nErrs := 0;  nErrsB := 0;
    IF (p.obj # NIL) THEN
      Error.Count (nErrs, nWarns);
      Value.TypeCheck (p.obj, cs);
      Error.Count (nErrsB, nWarns);
    END;
    IF (nErrs = nErrsB) THEN
      (* no errors yet... *)
      p.type := Type.CheckInfo (p.type, p.info);
    ELSE (* some sort of error (probably illegal recursion...) *)
      EVAL Type.CheckInfo (ErrType.T, p.info);
    END;
    p.info.class := Type.Class.Named; (* this node is still a Named node *)
  END Check;

PROCEDURE <A NAME="CheckAlign"><procedure>CheckAlign</procedure></A> (p: P;  offset: INTEGER): BOOLEAN =
  BEGIN
    IF (p.type = NIL) THEN Resolve (p) END;
    RETURN Type.IsAlignedOk (p.type, offset);
  END CheckAlign;

PROCEDURE <A NAME="Compiler"><procedure>Compiler</procedure></A> (p: P) =
  BEGIN
    IF (p.type = NIL) THEN Resolve (p) END;
    (*** Type.Compile (p.type);  ***)
    IF (p.type # NIL) THEN
      Scanner.offset := p.type.origin;
      p.type.compile ();
    END;
  END Compiler;

PROCEDURE <A NAME="InitCoster"><procedure>InitCoster</procedure></A> (p: P;  zeroed: BOOLEAN): INTEGER =
  BEGIN
    IF (p.type = NIL) THEN Resolve (p) END;
    RETURN Type.InitCost (p.type, zeroed);
  END InitCoster;

PROCEDURE <A NAME="GenInit"><procedure>GenInit</procedure></A> (p: P;  zeroed: BOOLEAN) =
  BEGIN
    IF (p.type = NIL) THEN Resolve (p) END;
    Type.InitValue (p.type, zeroed);
  END GenInit;

PROCEDURE <A NAME="GenMap"><procedure>GenMap</procedure></A> (p: P;  offset, size: INTEGER;  refs_only: BOOLEAN) =
  BEGIN
    IF (p.type = NIL) THEN Resolve (p) END;
    Type.GenMap (p.type, offset, size, refs_only);
  END GenMap;

PROCEDURE <A NAME="GenDesc"><procedure>GenDesc</procedure></A> (p: P) =
  BEGIN
    IF (p.type = NIL) THEN Resolve (p) END;
    Type.GenDesc (p.type);
  END GenDesc;

PROCEDURE <A NAME="FPrinter"><procedure>FPrinter</procedure></A> (p: P;  VAR x: M3.FPInfo) =
  BEGIN
    Error.QID (p.qid, &quot;INTERNAL ERROR: fingerprint of named type&quot;);
    IF (p.type = NIL) THEN Resolve (p) END;
    IF (p.type # NIL) THEN p.type.fprint (x); END;
  END FPrinter;

BEGIN
END NamedType.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
