<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/types/ObjectType.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/types/ObjectType.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ObjectType.i3                                         
 Last Modified On Mon Jul 25 08:44:06 PDT 1994 By kalsow     
      Modified On Fri Oct  5 07:29:44 1990 By muller         

<P>
<P><PRE>INTERFACE <interface><A HREF="ObjectType.m3">ObjectType</A></interface>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="Type.i3">Type</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../exprs/Expr.i3">Expr</A>;

PROCEDURE <A HREF="ObjectType.m3#Parse">Parse</A> (super: Type.T;  traced: BOOLEAN;  brand: Expr.T): Type.T;

PROCEDURE <A HREF="ObjectType.m3#New">New</A>   (super: Type.T;  traced: BOOLEAN;  brand: Expr.T;
                                        fields, methods: Scope.T): Type.T;

PROCEDURE <A HREF="ObjectType.m3#Is">Is</A> (t: Type.T): BOOLEAN;

PROCEDURE <A HREF="ObjectType.m3#IsBranded">IsBranded</A> (t: Type.T): BOOLEAN;

PROCEDURE <A HREF="ObjectType.m3#LookUp">LookUp</A> (t: Type.T;  id: M3ID.T;
                      VAR value: Value.T;  VAR visible: Type.T): BOOLEAN;

PROCEDURE <A HREF="ObjectType.m3#MethodOffset">MethodOffset</A> (t: Type.T): INTEGER;
</PRE><BLOCKQUOTE><EM> Returns the bit offset of the methods defined in object type t if
   all of its parents are visible, otherwise returns -1 </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ObjectType.m3#GetFieldOffset">GetFieldOffset</A> (t: Type.T;  VAR offset, align: INTEGER);
</PRE><BLOCKQUOTE><EM> Sets 'align' to the alignment of 't's fields.  If all the parents of 't'
   are visible, sets 'offset' to the bit offset of 't's fields,
   otherwise sets 'offset' to -1. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ObjectType.m3#FieldAlignment">FieldAlignment</A> (t: Type.T): INTEGER;
</PRE><BLOCKQUOTE><EM> Return the alignment of 't's fields. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ObjectType.m3#Super">Super</A> (t: Type.T): Type.T;
</PRE><BLOCKQUOTE><EM> Returns the super type of 't' if 't' is an object and it
   has been typechecked, otherwise NIL </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ObjectType.m3#NoteOffsets">NoteOffsets</A> (t, u: Type.T);
</PRE><BLOCKQUOTE><EM> If 'u' is an object type, generate the magic information for the
   field offsets of 'u' under the name of 't'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ObjectType.m3#NoteRefName">NoteRefName</A> (t: Type.T;  name: TEXT);
</PRE><BLOCKQUOTE><EM> record a user name for the ref type 't' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ObjectType.m3#InitTypecell">InitTypecell</A> (t: Type.T;  offset, prev: INTEGER);

END ObjectType.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
