<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/types/OpenArrayType.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/types/OpenArrayType.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: OpenArrayType.i3                                      
 Last Modified On Thu Jun 17 16:13:36 PDT 1993 By kalsow     
      Modified On Sat Nov 10 01:11:37 1990 By muller         

<P><PRE>INTERFACE <interface><A HREF="OpenArrayType.m3">OpenArrayType</A></interface>;

IMPORT <A HREF="Type.i3">Type</A>, <A HREF="../misc/CG.i3">CG</A>;

PROCEDURE <A HREF="OpenArrayType.m3#New">New</A> (element: Type.T): Type.T;

PROCEDURE <A HREF="OpenArrayType.m3#Is">Is</A> (t: Type.T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return TRUE iff 't' is an open array type </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="OpenArrayType.m3#Split">Split</A> (t: Type.T;  VAR element: Type.T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> If 't' is an open array type, returns TRUE and sets 'element'
   to the appropriate type.  Otherwise, returns FALSE </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="OpenArrayType.m3#EltPack">EltPack</A> (array: Type.T): INTEGER;
</PRE><BLOCKQUOTE><EM> If 'array' is an open array type, returns the packed size in bits of
   the elements.  Otherwise, returns 0. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="OpenArrayType.m3#EltAlign">EltAlign</A> (array: Type.T): INTEGER;
</PRE><BLOCKQUOTE><EM> If 'array' is an open array type, returns the bit alignment of
   the elements.  Otherwise, returns Target.Byte. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="OpenArrayType.m3#OpenDepth">OpenDepth</A> (t: Type.T): INTEGER;
</PRE><BLOCKQUOTE><EM> If 't' is an n-dimensional open array, returns n else returns 0 </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="OpenArrayType.m3#OpenType">OpenType</A> (t: Type.T): Type.T;
</PRE><BLOCKQUOTE><EM> If 't' is an n-dimensional open array, returns the type of the base
   elements; otherwise, returns t. That is, strip all the ARRAY OF in 
   front of t </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="OpenArrayType.m3#DeclareTemp">DeclareTemp</A> (t: Type.T): CG.Var;
</PRE><BLOCKQUOTE><EM> If 't' is an open array, declare and return a temporary to hold its
   dope vector, otherwise abort. </EM></BLOCKQUOTE><PRE>

END OpenArrayType.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
