<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/types/PackedType.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/types/PackedType.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: PackedType.m3                                         

<P><PRE>MODULE <module><implements><A HREF="PackedType.i3">PackedType</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="Type.i3">Type</A>, <A HREF="TypeRep.i3">TypeRep</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;
IMPORT <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="../misc/TipeDesc.i3">TipeDesc</A>;

CONST
  NO_SIZE = -1;

TYPE
  P = Type.T OBJECT
        sizeE      : Expr.T;
        newSize    : INTEGER;
        baseType   : Type.T;
      OVERRIDES
        check      := Check;
        check_align:= CheckAlign;
        isEqual    := EqualChk;
        isSubtype  := Subtyper;
        compile    := Compiler;
        initCost   := InitCoster;
        initValue  := GenInit;
        mapper     := GenMap;
        gen_desc   := GenDesc;
        fprint     := FPrinter;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): Type.T =
  TYPE TK = Token.T;
  VAR p: P := New (NO_SIZE, NIL);
  BEGIN
    Scanner.Match (TK.tBITS);
    p.sizeE := Expr.Parse ();
    Scanner.Match (TK.tFOR);
    p.baseType := Type.Parse ();
    RETURN p;
  END Parse;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (size: INTEGER;  base: Type.T): Type.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    TypeRep.Init (p, Type.Class.Packed);
    p.sizeE    := NIL;
    p.newSize  := size;
    p.baseType := base;
    RETURN p;
  END New;

PROCEDURE <A NAME="Reduce"><procedure>Reduce</procedure></A> (t: Type.T): P =
  BEGIN
    IF (t = NIL) THEN RETURN NIL END;
    IF (t.info.class = Type.Class.Named) THEN t := Type.Strip (t) END;
    IF (t.info.class # Type.Class.Packed) THEN RETURN NIL END;
    RETURN t;
  END Reduce;

PROCEDURE <A NAME="GetSize"><procedure>GetSize</procedure></A> (p: P): INTEGER =
  VAR new_sz: INTEGER;  new_size: Target.Int;  e: Expr.T;
  BEGIN
    IF (p.newSize = NO_SIZE) AND (p.sizeE # NIL) THEN
      e := Expr.ConstValue (p.sizeE);
      IF (e = NIL) OR NOT IntegerExpr.Split (e, new_size)
        OR NOT TInt.ToInt (new_size, new_sz)
        THEN Error.Msg (&quot;BITS FOR size must be a constant integer&quot;);
        ELSE p.sizeE := e;  p.newSize := new_sz;
      END;
    END;
    RETURN p.newSize;
  END GetSize;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (t: Type.T;  VAR size: INTEGER;  VAR base: Type.T) =
  VAR p := Reduce (t);
  BEGIN
    size := GetSize (p);
    base := p.baseType;
  END Split;

PROCEDURE <A NAME="Base"><procedure>Base</procedure></A> (t: Type.T): Type.T =
  VAR p: P := t;
  BEGIN
    RETURN p.baseType;
  END Base;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P) =
  VAR
    new_sz, old_min: INTEGER;
    cs := M3.OuterCheckState;
    info: Type.Info;
  BEGIN
    p.baseType := Type.CheckInfo (p.baseType, info);
    old_min := info.min_size;
    new_sz  := info.size;

    IF (p.sizeE # NIL) THEN
      Expr.TypeCheck (p.sizeE, cs);
      new_sz := GetSize (p);
      IF (new_sz = NO_SIZE) THEN new_sz := info.size; END;
    END;

    IF (new_sz &lt; old_min) THEN
      Error.Int (old_min, &quot;BITS FOR size too small, must be at least&quot;);
    END;

    p.info.size      := new_sz;
    p.info.min_size  := new_sz;
    p.info.alignment := info.alignment;
    p.info.cg_type   := info.cg_type;
    p.info.class     := Type.Class.Packed;
    p.info.isTraced  := info.isTraced;
    p.info.isEmpty   := info.isEmpty;
    p.info.isSolid   := info.isSolid;
    p.info.hash      := Word.Plus (Word.Times (61, info.hash), new_sz);
  END Check;

PROCEDURE <A NAME="CheckAlign"><procedure>CheckAlign</procedure></A> (p: P;  offset: INTEGER): BOOLEAN =
  VAR z0: INTEGER;  info: Type.Info;  sz: INTEGER;
  BEGIN
    EVAL Type.CheckInfo (p.baseType, info);
    sz := GetSize (p);
    IF (info.size = sz) THEN
      RETURN Type.IsAlignedOk (p.baseType, offset);
    ELSIF Type.IsStructured (p.baseType) THEN
      (* the scalar crossing can't be any worse than in the full structure *)
      RETURN Type.IsAlignedOk (p.baseType, offset);
    ELSE
      z0 := offset DIV Target.Integer.align * Target.Integer.align;
      RETURN (offset + sz) &lt;= (z0 + Target.Integer.size);
    END;
  END CheckAlign;

PROCEDURE <A NAME="Compiler"><procedure>Compiler</procedure></A> (p: P) =
  BEGIN
    Type.Compile (p.baseType);
    CG.Declare_packed (Type.GlobalUID (p), p.newSize,
                       Type.GlobalUID (p.baseType));
  END Compiler;

PROCEDURE <A NAME="EqualChk"><procedure>EqualChk</procedure></A> (a: P;  t: Type.T;  x: Type.Assumption): BOOLEAN =
  VAR b: P := t;
  BEGIN
    RETURN GetSize (a) = GetSize (b)
       AND Type.IsEqual (a.baseType, b.baseType, x);
  END EqualChk;

PROCEDURE <A NAME="Subtyper"><procedure>Subtyper</procedure></A> (a: P;  b: Type.T): BOOLEAN =
  BEGIN
    RETURN Type.IsEqual (b, a.baseType, NIL);
  END Subtyper;

PROCEDURE <A NAME="InitCoster"><procedure>InitCoster</procedure></A> (p: P;  zeroed: BOOLEAN): INTEGER =
  BEGIN
    RETURN Type.InitCost (p.baseType, zeroed);
  END InitCoster;

PROCEDURE <A NAME="GenInit"><procedure>GenInit</procedure></A> (p: P;  zeroed: BOOLEAN) =
  BEGIN
    Type.InitValue (p.baseType, zeroed);  (* BUG!! *)
  END GenInit;

PROCEDURE <A NAME="GenMap"><procedure>GenMap</procedure></A> (p: P;  offset, size: INTEGER;  refs_only: BOOLEAN) =
  BEGIN
    &lt;*ASSERT size &lt;= p.newSize*&gt;
    Type.GenMap (p.baseType, offset, size, refs_only);
  END GenMap;

PROCEDURE <A NAME="GenDesc"><procedure>GenDesc</procedure></A> (p: P) =
  BEGIN
    IF TipeDesc.AddO (TipeDesc.Op.Packed, p) THEN
      TipeDesc.AddI (p.newSize);
      Type.GenDesc (p.baseType);
    END;
  END GenDesc;

PROCEDURE <A NAME="FPrinter"><procedure>FPrinter</procedure></A> (p: P;  VAR x: M3.FPInfo) =
  BEGIN
    M3Buf.PutText (x.buf, &quot;BITS-FOR &quot;);
    M3Buf.PutInt  (x.buf, p.newSize);
    x.n_nodes  := 1;
    x.nodes[0] := p.baseType;
  END FPrinter;

BEGIN
END PackedType.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
