<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/types/Type.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/types/Type.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Type.i3                                               
 Last Modified On Wed Sep  7 15:30:33 PDT 1994 by kalsow     
      Modified On Fri Dec 21 00:57:36 1990 by muller         

<P><PRE>INTERFACE <interface><A HREF="Type.m3">Type</A></interface>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;

TYPE
  T          = M3.Type;
  <A HREF="Type.m3#Assumption">Assumption</A> &lt;: ADDRESS;
  <A HREF="Type.m3#ModuleInfo">ModuleInfo</A> &lt;: REFANY;

TYPE
  Class = { Error, Named, Integer, Real, Longreal, Extended,
            Array, Enum, Object, Opaque, OpenArray, Packed,
            Procedure, Record, Ref, Set, Subrange };

VAR
  recursionDepth: INTEGER := 0;
  (* incremented(decremented) every time the type checker enters(leaves)
     one of the types that's allowed to introduce recursions.
     (ie. REF, OBJECT, PROC) *)

TYPE
  Info = RECORD
    size      : INTEGER;  (* size in bits, -1 if variable sized *)
    min_size  : INTEGER;  (* minimum size in bits. *)
    alignment : INTEGER;  (* minimum alignment in bits *)
    hash      : INTEGER;  (* internal hash code *)
    cg_type   : CG.Type;  (* code generator representation *)
    class     : Class;
    isTraced  : M3.Flag;
    isEmpty   : M3.Flag;
    isSolid   : M3.Flag;
  END;
</PRE>** phase 0 **

<P><PRE>PROCEDURE <A HREF="Type.m3#Initialize">Initialize</A> ();
PROCEDURE <A HREF="Type.m3#Reset">Reset</A> ();
</PRE><BLOCKQUOTE><EM> initializes the module and all other type modules. </EM></BLOCKQUOTE><PRE>
</PRE>** phase 1 **

<P><PRE>PROCEDURE <A HREF="Type.m3#Parse">Parse</A> (): T;
</PRE><BLOCKQUOTE><EM> parse a type expression </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#SetModule">SetModule</A> (x: ModuleInfo): ModuleInfo;
</PRE><BLOCKQUOTE><EM> sets the current module's type info to 'x' and returns
   the previous module's type info.  This routine is only called
   when the <CODE>current</CODE> module changes. </EM></BLOCKQUOTE><PRE>
</PRE>** phase 2 **

<P><PRE>PROCEDURE <A HREF="Type.m3#Check">Check</A> (t: T): T;
</PRE><BLOCKQUOTE><EM> type check type 't'.   Return the underlying constructed
   (ie. class # Class.Named) type node. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#CheckInfo">CheckInfo</A> (t: T;  VAR(*OUT*) x: Info): T;
</PRE><BLOCKQUOTE><EM> type check type 't'.  Return the underlying constructed
   (ie. class # Class.Named) type node and in 'x' its info. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#IsAlignedOk">IsAlignedOk</A> (t: T;  offs: INTEGER): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Returns TRUE iff no scalars within a value of type 't' at a bit offset
   of 'offs' cross word boundaries.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#Strip">Strip</A> (t: T): T;
</PRE><BLOCKQUOTE><EM> return the constructed type of 't' (ie. strip renaming) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#Base">Base</A> (t: T): T;
</PRE><BLOCKQUOTE><EM> return the base type of 't' (strip renaming, packing &amp; subranges) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#CGType">CGType</A> (t: T): CG.Type;
</PRE><BLOCKQUOTE><EM> returns the code generator's stack representation for 't'  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#IsStructured">IsStructured</A> (t: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> &lt;=&gt; rec, set, or array &lt;=&gt; is represented as an address on the CG stack </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#LoadScalar">LoadScalar</A> (t: T);
</PRE><BLOCKQUOTE><EM> If 't' is not a structured type, generate code to load the scalar
   pointed to by the address on the CG stack </EM></BLOCKQUOTE><PRE>
</PRE>** phase 3 **

<P><PRE>PROCEDURE <A HREF="Type.m3#BeginSetGlobals">BeginSetGlobals</A> ();
</PRE><BLOCKQUOTE><EM> Prepares the types of the current module for calls to SetGlobals </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#SetGlobals">SetGlobals</A> (origin: INTEGER);
</PRE><BLOCKQUOTE><EM> assign offsets to any needed global data for any types in the
   current module that occured lexically at or before 'origin'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#IsOrdinal">IsOrdinal</A> (t: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> return TRUE if the type is an ordinal (Integer, Enum, Subrange) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#Number">Number</A> (t: T): Target.Int;
</PRE><BLOCKQUOTE><EM> return the number of values of the type;  -1 if t is not an ordinal type </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#GetBounds">GetBounds</A> (t: T;  VAR min, max: Target.Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> return the bounds and true for ordinal types, 
   [0,-1] and FALSE for non-ordinal types </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#IsEqual">IsEqual</A> (a, b: T;  x: Assumption): BOOLEAN;
</PRE><BLOCKQUOTE><EM> TRUE iff (a == b) given the assumptions x </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#IsSubtype">IsSubtype</A> (a, b: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> TRUE iff (a &lt;: b) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#IsAssignable">IsAssignable</A> (a, b: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> TRUE iff (a := b) typechecks </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#Name">Name</A> (t: T): TEXT;
PROCEDURE <A HREF="Type.m3#GlobalUID">GlobalUID</A> (t: T): INTEGER;
</PRE><BLOCKQUOTE><EM> return the unique id for the type in the generated code </EM></BLOCKQUOTE><PRE>
</PRE>** phase 4 **

<P><PRE>PROCEDURE <A HREF="Type.m3#CompileAll">CompileAll</A> ();
</PRE><BLOCKQUOTE><EM> compile all the local types for the current module </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#Compile">Compile</A> (t: T);
</PRE><BLOCKQUOTE><EM> generates the debugging declarations for 't' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#LoadInfo">LoadInfo</A> (t: T;  offset: INTEGER;  addr := FALSE);
</PRE><BLOCKQUOTE><EM> loads the specified field of 't's typecell.  If 'offset' is less than
   zero, 'LoadInfo' loads the address of the typecell.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#InitValue">InitValue</A> (t: T;  zeroed: BOOLEAN);
</PRE><BLOCKQUOTE><EM> initialize the variable addressed by s0.A to an arbitrary value of type 't'.
   If 'zeroed' the variable is assumed to already have all bits set to zero. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#Zero">Zero</A> (t: T);
</PRE><BLOCKQUOTE><EM> initialize the variable of type 't' addressed by s0.A to zeros. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#InitCost">InitCost</A> (t: T;  ifZeroed: BOOLEAN): INTEGER;
</PRE><BLOCKQUOTE><EM> the cost of initializing a 't'.  (0 IFF no init required) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#GenMap">GenMap</A> (t: T;  offset, size: INTEGER;  refs_only: BOOLEAN);
</PRE><BLOCKQUOTE><EM> emits the type map for type 't' occupying 'size' bits at 'offset'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#GenDesc">GenDesc</A> (t: T);
</PRE><BLOCKQUOTE><EM> generate the runtime description for type 't' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#GenTag">GenTag</A> (t: T;  tag: TEXT;  offset: INTEGER);
</PRE><BLOCKQUOTE><EM> generate a comment with 'tag' and 't's name </EM></BLOCKQUOTE><PRE>
</PRE>** phase 5 **

<P><PRE>PROCEDURE <A HREF="Type.m3#GenCells">GenCells</A> (): INTEGER;
</PRE><BLOCKQUOTE><EM> generate the current module's linked list of typecells
   and return its offset in the module global data. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#GenCellPtrs">GenCellPtrs</A> (): INTEGER;
</PRE><BLOCKQUOTE><EM> generate the current module's linked list of pointers to typecells
   and return its offset in the module global data. </EM></BLOCKQUOTE><PRE>

END Type.
</PRE><P>
  The following sets of procedures are may be called during the
  various phases of the compilation:
<P>
   initialization:
     { Initialize* }
   parsing:
     { Parse, NoteDeclaration }
   type checking:
     { Check, Number, GetBounds, Base, IsEqual,
       IsSubtype, IsAssignable }
   code generation:
     { Name, Number, GetBounds, Base, IsEqual,
       IsSubtype, IsAssignable }
<P>
   ( * =&gt; may only be called once )


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
