<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/types/TypeRep.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/types/TypeRep.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: TypeRep.i3                                            
 Last Modified On Wed Nov 16 14:38:18 PST 1994 by kalsow     
      Modified On Fri Dec 21 00:53:14 1990 by muller         

<P><PRE>INTERFACE <interface><A HREF="Type.m3">TypeRep</A></interface>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="../../../m3middle/src/M3FP.i3">M3FP</A>, <A HREF="Type.i3">Type</A>;

CONST
  NO_UID   = -1;
  NO_SCC   = 0;

TYPE
  TT = M3.Type;

REVEAL
  M3.<A NAME="Type">Type</A> = M3.Node BRANDED &quot;Type.T&quot; OBJECT
    fp          : M3FP.T;
    info        : Type.Info;
    uid         : INTEGER;
    scc_id      : INTEGER;
    rep_id      : INTEGER;
    checkDepth  : BITS 12 FOR [-2048..2047];
    checked     : M3.Flag;
    errored     : M3.Flag;
    next        : TT;   (* linked list of all types in the same module *)
  METHODS
    check       ();
    check_align (offset: INTEGER): BOOLEAN;
    isEqual     (t: TT;  x: Type.Assumption): BOOLEAN;
    isSubtype   (t: TT): BOOLEAN := NoSubtypes;
    compile     ();
    initCost    (zeroed: BOOLEAN): INTEGER;
    initValue   (zeroed: BOOLEAN);
    mapper      (offset, size: INTEGER; refs: BOOLEAN);
    gen_desc    ();
    fprint      (VAR x: M3.FPInfo);
  END;

PROCEDURE <A HREF="Type.m3#Init">Init</A> (t: TT;  c: Type.Class);
</PRE><BLOCKQUOTE><EM> initialize the shared fields of a Type.T </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#NeverEqual">NeverEqual</A> (a, b: TT;  x: Type.Assumption): BOOLEAN;
</PRE><BLOCKQUOTE><EM> == RETURN FALSE </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#NoSubtypes">NoSubtypes</A> (a, b: TT): BOOLEAN;
</PRE><BLOCKQUOTE><EM> == RETURN FALSE </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#InitToZeros">InitToZeros</A> (t: TT;  zeroed: BOOLEAN);
</PRE><BLOCKQUOTE><EM> == initialize Size(t) bits to zero </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#GenRefMap">GenRefMap</A> (t: TT;  offset, size: INTEGER;  refs_only: BOOLEAN);
</PRE><BLOCKQUOTE><EM> == TypeMap.Add (offset, Op.{Untraced}Ref, 0) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#GenRefDesc">GenRefDesc</A> (t: TT);
</PRE><BLOCKQUOTE><EM> == TypeDesc.AddO (Op.{Untraced}Ref); TypeDesc.AddI (UID(t)) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Type.m3#ScalarAlign">ScalarAlign</A> (t: TT;  offset: INTEGER): BOOLEAN;
</PRE><BLOCKQUOTE><EM> == RETURN (t.alignment MOD offset = 0) </EM></BLOCKQUOTE><PRE>

END TypeRep.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
