<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/types/TypeTbl.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/types/TypeTbl.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: TypeTbl.i3                                            

<P><PRE>MODULE <module><implements><A HREF="TypeTbl.i3">TypeTbl</A></implements></module>;

IMPORT <A HREF="Type.i3">Type</A>, <A HREF="TypeRep.i3">TypeRep</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

REVEAL
  <A NAME="T">T</A> = BRANDED &quot;TypeTbl.T&quot; REF RECORD
    cnt   : INTEGER := 0;
    mask  : INTEGER := 0;
    shift : INTEGER := 0;
    map   : Map     := NIL;
  END;

TYPE
  Map = REF ARRAY OF RECORD key: Type.T;  value: REFANY;  END;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A> (VAR t: T;  key: Type.T;  value: REFANY): REFANY =
  VAR
    uid  := Type.GlobalUID (key);
    hash := uid;
    old  : REFANY;
    x, shift, mask, cnt: INTEGER;
  BEGIN
    &lt;*ASSERT uid = key.uid*&gt;
    IF (t = NIL) THEN
      t := NEW (T, mask := 255, shift := 24, map := NEW (Map, 256));
    END;
    LOOP
      shift := Word.RightShift (t.shift, 1);
      mask  := t.mask;
      cnt   := NUMBER (t.map^);
      REPEAT
        x := Word.And (Word.RightShift (hash, shift), mask);
        WITH z = t.map[x] DO
          IF (z.key = NIL) THEN
            z.key := key;
            z.value := value;
            INC (t.cnt);
            IF (2 * t.cnt &gt; NUMBER (t.map^)) THEN Expand (t) END;
            RETURN NIL;
          ELSIF (z.key.uid = uid) THEN
            old := z.value;
            z.value := value;
            RETURN old;
          END;
        END;
        hash := Word.Times (hash, 16_9e3779b9 (*== 2^32/phi*)) + 1;
        DEC (cnt);
      UNTIL (cnt &lt;= 0);
      Expand (t);
    END;
  END Put;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (t: T;  key: Type.T): REFANY =
  VAR
    uid  := Type.GlobalUID (key);
    hash := uid;
    x, shift, mask, cnt: INTEGER;
  BEGIN
    &lt;*ASSERT uid = key.uid*&gt;
    IF (t = NIL) THEN RETURN NIL END;

      shift := Word.RightShift (t.shift, 1);
      mask  := t.mask;
      cnt   := NUMBER (t.map^);
      REPEAT
        x := Word.And (Word.RightShift (hash, shift), mask);
        WITH z = t.map[x] DO
          IF (z.key = NIL) THEN
            RETURN NIL;
          ELSIF (z.key.uid = uid) THEN
            RETURN z.value;
          END;
        END;
        hash := Word.Times (hash, 16_9e3779b9 (*== 2^32/phi*)) + 1;
        DEC (cnt);
      UNTIL (cnt &lt;= 0);

    RETURN NIL;
  END Get;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> (t: T) =
  BEGIN
    IF (t = NIL) THEN RETURN; END;
    t.cnt := 0;
    FOR i := 0 TO LAST (t.map^) DO
      WITH z = t.map[i] DO  z.key := NIL;  z.value := NIL;  END;
    END;
  END Reset;

PROCEDURE <A NAME="Expand"><procedure>Expand</procedure></A> (t: T) =
  VAR
    n   := NUMBER (t.map^);
    old := t.map;
  BEGIN
    t.cnt   := 0;
    t.map   := NEW (Map, n + n);
    t.mask  := t.mask + t.mask + 1;
    t.shift := t.shift - 1;
    FOR i := 0 TO n-1 DO
      WITH z = old[i] DO
        IF z.key # NIL THEN EVAL Put (t, z.key, z.value); END;
      END;
    END;
  END Expand;

BEGIN
END TypeTbl.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
