<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/Constant.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/Constant.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Constant.m3                                           
 Last Modified On Tue Dec 20 15:23:08 PST 1994 By kalsow     

<P><PRE>MODULE <module><implements><A HREF="Constant.i3">Constant</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="Value.i3">Value</A>, <A HREF="ValueRep.i3">ValueRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../misc/Error.i3">Error</A>;
IMPORT <A HREF="../misc/Token.i3">Token</A>, <A HREF="../stmts/AssignStmt.i3">AssignStmt</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="../types/UserProc.i3">UserProc</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>;
IMPORT <A HREF="Decl.i3">Decl</A>, <A HREF="../types/ProcType.i3">ProcType</A>, <A HREF="Procedure.i3">Procedure</A>, <A HREF="../types/OpenArrayType.i3">OpenArrayType</A>, <A HREF="Module.i3">Module</A>;
FROM <A HREF="../misc/Scanner.i3">Scanner</A> IMPORT GetToken, Match, MatchID, cur;

TYPE
  T = Value.T BRANDED &quot;Constant.T&quot; OBJECT
        tipe     : Type.T;
	value    : Expr.T;
        offset   : INTEGER;
	explicit : BOOLEAN;
      OVERRIDES
        typeCheck   := Check;
        set_globals := SetGlobals;
        load        := Load;
        declare     := Declarer;
        need_init   := ValueRep.Never;
        lang_init   := ValueRep.NoInit;
        user_init   := ValueRep.NoInit;
	toExpr      := ToExpr;
	toType      := ValueRep.NoType;
        typeOf      := TypeOf;
        base        := ValueRep.Self;
        add_fp_tag  := AddFPTag;
        fp_type     := TypeOf;
      END;

PROCEDURE <A NAME="ParseDecl"><procedure>ParseDecl</procedure></A> (READONLY att: Decl.Attributes) =
  TYPE TK = Token.T;
  VAR t: T; id: M3ID.T;
  BEGIN
    IF att.isInline   THEN Error.Msg (&quot;a constant cannot be inline&quot;); END;
    IF att.isExternal THEN
      Error.Msg (&quot;a constant cannot be external&quot;);
    ELSIF att.callingConv # NIL THEN
      Error.Msg (&quot;a constant does not have a calling convention&quot;);
    END;

    Match (TK.tCONST);
    WHILE (cur.token = TK.tIDENT) DO
      id := MatchID ();
      t := Create (id);
      t.unused := att.isUnused;
      t.obsolete := att.isObsolete;
      IF (cur.token = TK.tCOLON) THEN
        GetToken (); (* : *)
        t.tipe := Type.Parse ();
      END;
      Match (TK.tEQUAL);
      t.value := Expr.Parse ();
      Scope.Insert (t);
      Match (TK.tSEMI);
    END;
  END ParseDecl;

PROCEDURE <A NAME="Create"><procedure>Create</procedure></A> (name: M3ID.T): T =
  VAR t: T;
  BEGIN
    t := NEW (T);
    ValueRep.Init (t, name, Value.Class.Expr);
    t.readonly := TRUE;
    t.tipe     := NIL;
    t.value    := NIL;
    t.offset   := 0;
    t.explicit := FALSE;
    RETURN t;
  END Create;

PROCEDURE <A NAME="Declare"><procedure>Declare</procedure></A> (name: TEXT;  value: Expr.T;  reserved: BOOLEAN) =
  VAR t: T;
  BEGIN
    t := Create (M3ID.Add (name));
    t.tipe := Expr.TypeOf (value);
    t.value := value;
    Scope.Insert (t);
    IF (reserved) THEN Scanner.NoteReserved (t.name, t) END;
  END Declare;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (t: T): Type.T =
  BEGIN
    IF (t.tipe = NIL) THEN t.tipe := Expr.TypeOf (t.value) END;
    RETURN t.tipe;
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (t: T;  VAR cs: Value.CheckState) =
  VAR e: Expr.T;  proc: Value.T;
  BEGIN
    Expr.TypeCheck (t.value, cs);
    t.tipe := Type.Check (TypeOf (t));

    IF ProcType.Is (t.tipe)
      AND UserProc.IsProcedureLiteral (t.value, proc)
      AND Procedure.IsNested (proc) THEN
      Error.Msg (&quot;nested procedures are not constants&quot;);
    END;

    AssignStmt.Check (t.tipe, t.value, cs);
    e := Expr.ConstValue (t.value);
    IF (t.value # NIL) AND (e = NIL)
      THEN Error.Msg (&quot;value is not constant&quot;);
      ELSE t.value := e;
    END;
    t.explicit := Type.IsStructured (t.tipe);
  END Check;

PROCEDURE <A NAME="SetGlobals"><procedure>SetGlobals</procedure></A> (t: T) =
  VAR size, align, depth: INTEGER;  info: Type.Info;
  BEGIN
    (* Type.SetGlobals (t.tipe); *)
    IF (t.offset # 0) OR (NOT t.explicit) THEN RETURN END;

    EVAL Type.CheckInfo (t.tipe, info);
    size  := info.size;
    align := info.alignment;
    depth := OpenArrayType.OpenDepth (t.tipe);

    IF (depth &gt; 0) THEN
      (* t.tipe is an open array *)
      size := Target.Address.pack + depth * Target.Integer.pack;
      align := MAX (Target.Address.align, Target.Integer.align);
    END;

    t.offset := Module.Allocate (size, align, &quot;constant &quot;, id := t.name);
  END SetGlobals;

PROCEDURE <A NAME="Load"><procedure>Load</procedure></A> (t: T) =
</PRE><BLOCKQUOTE><EM> Note: because a named constant may be the default value for
   a procedure parameter, it is possible for a structured constant
   to be used in a compilation unit without anywhere mentioning
   its name =&gt; its use will not be detected =&gt; it won't be
   imported =&gt; we force the import here by calling Scope.ToUnit. </EM></BLOCKQUOTE><PRE>
  BEGIN
    IF (t.explicit) THEN
      SetGlobals (t);
      CG.Load_addr_of (Scope.ToUnit (t), t.offset, CG.Max_alignment);
    ELSE
      Expr.Prep (t.value);
      Expr.Compile (t.value);
    END;
  END Load;

PROCEDURE <A NAME="Declarer"><procedure>Declarer</procedure></A> (t: T): BOOLEAN =
  VAR type: CG.TypeUID;  size, depth: INTEGER;  info: Type.Info;
  BEGIN
    IF (t.exported) THEN Type.Compile (t.tipe) END;
    IF (NOT t.explicit) THEN RETURN TRUE END;

    EVAL Type.CheckInfo (t.tipe, info);
    Type.Compile (t.tipe);
    type  := Type.GlobalUID (t.tipe);
    size  := info.size;
    depth := OpenArrayType.OpenDepth (t.tipe);

    IF (depth &gt; 0) THEN
      (* t.tipe is an open array *)
      size := Target.Address.pack + depth * Target.Integer.pack;
    END;

    IF (t.imported) THEN
      EVAL Scope.ToUnit (t); (* force the module to be imported *)
    ELSE
      SetGlobals (t);
      CG.Declare_global_field (t.name, t.offset, size, type);
      CG.Comment (t.offset, &quot;constant &quot;, M3ID.ToText (t.name));
      Expr.PrepLiteral (t.value, t.tipe);
      Expr.GenLiteral (t.value, t.offset, t.tipe);
    END;

    RETURN TRUE;
  END Declarer;

PROCEDURE <A NAME="ToExpr"><procedure>ToExpr</procedure></A> (t: T): Expr.T =
  BEGIN
    RETURN t.value;
  END ToExpr;

PROCEDURE <A NAME="AddFPTag"><procedure>AddFPTag</procedure></A> (t: T;  VAR x: M3.FPInfo): CARDINAL =
  BEGIN
    ValueRep.FPStart (t, x, &quot;CONST &quot;, t.offset, global := TRUE);
    M3Buf.PutText (x.buf, &quot; = &quot;);
    Expr.GenFPLiteral (t.value, x.buf);
    RETURN 1;
  END AddFPTag;

BEGIN
END Constant.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
