<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/Decl.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/Decl.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Decl.m3                                               

<P><PRE>MODULE <module><implements><A HREF="Decl.i3">Decl</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="../misc/M3String.i3">M3String</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../misc/ESet.i3">ESet</A>, <A HREF="Module.i3">Module</A>, <A HREF="Exceptionz.i3">Exceptionz</A>;
IMPORT <A HREF="Constant.i3">Constant</A>, <A HREF="Tipe.i3">Tipe</A>, <A HREF="Variable.i3">Variable</A>, <A HREF="Procedure.i3">Procedure</A>, <A HREF="Revelation.i3">Revelation</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;
FROM <A HREF="../misc/Scanner.i3">Scanner</A> IMPORT GetToken, Match, cur;

TYPE
  TK = Token.T;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (interface, top_level: BOOLEAN;  VAR fails: M3.ExSet) =
  VAR att: Attributes;
  BEGIN
    att.isInline    := FALSE;
    att.isExternal  := FALSE;
    att.isUnused    := FALSE;
    att.isObsolete  := FALSE;
    att.alias       := M3ID.NoID;
    att.callingConv := NIL;
    LOOP
      CASE cur.token OF
      | TK.tEXTERNAL =&gt;
          IF NOT Module.IsInterface () THEN
            Error.Msg (&quot;External declarations only allowed in interfaces&quot;);
          END;
          ParseExternalPragma (att.alias, att.callingConv);
          att.isExternal := TRUE;
      | TK.tINLINE   =&gt;
          att.isInline := TRUE;
          GetToken (); (* INLINE *)
          Match (TK.tENDPRAGMA);
      | TK.tUNUSED   =&gt;
          att.isUnused := TRUE;
          GetToken (); (* UNUSED *)
          Match (TK.tENDPRAGMA);
      | TK.tOBSOLETE =&gt;
          att.isObsolete := TRUE;
          GetToken (); (* OBSOLETE *)
          Match (TK.tENDPRAGMA);
      | TK.tCALLCONV   =&gt;
          att.callingConv := Target.FindConvention (M3ID.ToText (cur.id));
          GetToken (); (* convention name *)
          Match (TK.tENDPRAGMA);
      ELSE EXIT;
      END;
    END;

    CASE cur.token OF
    | TK.tCONST =&gt;
        att.isExternal := att.isExternal OR Module.IsExternal ();
        Constant.ParseDecl (att);
    | TK.tTYPE =&gt;
        Tipe.Parse (att);
    | TK.tVAR =&gt;
        att.isExternal := att.isExternal OR Module.IsExternal ();
        Variable.ParseDecl (att);
    | TK.tPROCEDURE =&gt;
        att.isExternal := att.isExternal OR Module.IsExternal ();
        Procedure.ParseDecl (att, interface);
    | TK.tREVEAL =&gt;
        IF (NOT top_level) THEN Error.Msg (&quot;nested revelation&quot;) END;
        Revelation.Parse (att);
    | TK.tEXCEPTION =&gt;
        IF (NOT top_level) THEN Error.Msg (&quot;nested exception declaration&quot;) END;
        att.isExternal := att.isExternal OR Module.IsExternal ();
        Exceptionz.ParseDecl (att);
    | TK.tFATAL =&gt;
        fails := ESet.ParseFails (fails);
    ELSE
        IF att.isInline OR att.isExternal OR att.isUnused
           OR att.isObsolete THEN
          Error.Msg (&quot;declaration pragma not followed by a declaration&quot;);
        END;
    END;
  END Parse;

PROCEDURE <A NAME="ParseExternalPragma"><procedure>ParseExternalPragma</procedure></A> (VAR alias : M3ID.T;
                               VAR cc    : CG.CallingConvention) =
  BEGIN
    &lt;* ASSERT cur.token = TK.tEXTERNAL *&gt;
    GetToken (); (* EXTERNAL *)

    alias := M3ID.NoID;  (* default =&gt; use the Modula-3 name *)
    cc    := Target.DefaultCall;

    IF (cur.token = TK.tIDENT) OR (cur.token = TK.tTEXTCONST) THEN
      IF (cur.token = TK.tIDENT)
        THEN alias := cur.id;
        ELSE alias := M3ID.Add (M3String.ToText (cur.str));
      END;
      GetToken (); (* IDENT, TEXTCONST *)

      IF (cur.token = TK.tCOLON) THEN
        GetToken (); (* : *)
        IF (cur.token = TK.tIDENT) OR (cur.token = TK.tTEXTCONST) THEN
          cc := Target.FindConvention (M3ID.ToText (cur.id));
          IF (cc = NIL) THEN
            Error.ID (cur.id, &quot;unsupported language or calling convention&quot;);
            cc := Target.DefaultCall;
          END;
          GetToken (); (* IDENT/TEXTCONST *)
        ELSE
          Error.Msg (&quot;Missing language for &lt;*EXTERNAL*&gt; pragma&quot;);
        END;
      END;

    END;

    Match (TK.tENDPRAGMA);
  END ParseExternalPragma;

BEGIN
END Decl.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
