<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/EnumElt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/EnumElt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: EnumElt.m3                                            

<P><PRE>MODULE <module><implements><A HREF="EnumElt.i3">EnumElt</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="Value.i3">Value</A>, <A HREF="ValueRep.i3">ValueRep</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/EnumExpr.i3">EnumExpr</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;

TYPE
  T = Value.T BRANDED OBJECT
	value  : Target.Int;
	parent : Type.T;
      OVERRIDES
        typeCheck   := Check;
        set_globals := ValueRep.NoInit;
        load        := Load;
        declare     := ValueRep.Never;
        need_init   := ValueRep.Never;
        lang_init   := ValueRep.NoInit;
        user_init   := ValueRep.NoInit;
	toExpr      := ToExpr;
	toType      := ValueRep.NoType;
        typeOf      := TypeOf;
        base        := ValueRep.Self;
        add_fp_tag  := AddFPTag;
        fp_type     := FPType;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (name: M3ID.T;  READONLY value: Target.Int;
                                             parent: Type.T): Value.T =
  VAR t := NEW (T);
  BEGIN
    ValueRep.Init (t, name, Value.Class.Expr);
    t.readonly := TRUE;
    t.value    := value;
    t.parent   := parent;
    RETURN t;
  END New;

PROCEDURE <A NAME="IsEqual"><procedure>IsEqual</procedure></A> (va, vb: Value.T): BOOLEAN =
  VAR a: T := va;  b: T := vb;
  BEGIN
    RETURN (a.name = b.name) AND TInt.EQ (a.value, b.value);
  END IsEqual;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (&lt;*UNUSED*&gt; t: T;  &lt;*UNUSED*&gt; VAR cs: Value.CheckState) =
  BEGIN
    (* no checking needed *)
  END Check;

PROCEDURE <A NAME="Load"><procedure>Load</procedure></A> (t: T) =
  BEGIN
    CG.Load_integer (t.value);
  END Load;

PROCEDURE <A NAME="ToExpr"><procedure>ToExpr</procedure></A> (t: T): Expr.T =
  BEGIN
    RETURN EnumExpr.New (t.parent, t.value);
  END ToExpr;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (t: T): Type.T =
  BEGIN
    RETURN t.parent;
  END TypeOf;

PROCEDURE <A NAME="AddFPTag"><procedure>AddFPTag</procedure></A> (t: T;  VAR x: M3.FPInfo): CARDINAL =
  BEGIN
    ValueRep.FPStart (t, x, &quot;ENUM-ELT &quot;, 0, global := FALSE);
    RETURN 0;
  END AddFPTag;

PROCEDURE <A NAME="FPType"><procedure>FPType</procedure></A> (&lt;*UNUSED*&gt; t: T): Type.T =
  BEGIN
    RETURN NIL;
  END FPType;

BEGIN
END EnumElt.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
