<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/Field.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/Field.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Field.m3                                              

<P><PRE>MODULE <module><implements><A HREF="Field.i3">Field</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="Value.i3">Value</A>, <A HREF="ValueRep.i3">ValueRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../misc/Error.i3">Error</A>;
IMPORT <A HREF="../stmts/AssignStmt.i3">AssignStmt</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>;

TYPE
  T = Value.T BRANDED OBJECT
        index   : INTEGER;
        offset  : INTEGER;
        tipe    : Type.T;
        dfault  : Expr.T;
      OVERRIDES
        typeCheck   := TypeCheck;
        set_globals := SetGlobals;
        load        := ValueRep.NoLoader;
        declare     := ValueRep.Never;
        need_init   := ValueRep.Never;
        lang_init   := Compile;
        user_init   := ValueRep.NoInit;
	toExpr      := ValueRep.NoExpr;
	toType      := ValueRep.NoType;
        typeOf      := TypeOf;
        base        := ValueRep.Self;
        add_fp_tag  := AddFPTag;
        fp_type     := TypeOf;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (READONLY info: Info): Value.T =
  VAR t := NEW (T);
  BEGIN
    ValueRep.Init (t, info.name, Value.Class.Field);
    t.index  := info.index;
    t.offset := info.offset;
    t.tipe   := info.type;
    t.dfault := info.dfault;
    RETURN t;
  END New;

PROCEDURE <A NAME="Is"><procedure>Is</procedure></A> (v: Value.T): BOOLEAN =
  BEGIN
    TYPECASE v OF
    | NULL =&gt;  RETURN FALSE;
    | T    =&gt;  RETURN TRUE;
    ELSE       RETURN FALSE;
    END;
  END Is;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (field: Value.T;  VAR info: Info) =
  VAR t: T := field;
  BEGIN
    info.name   := t.name;
    info.index  := t.index;
    info.offset := t.offset;
    info.type   := t.tipe;
    info.dfault := t.dfault;
  END Split;

PROCEDURE <A NAME="SetOffset"><procedure>SetOffset</procedure></A> (field: Value.T;  newOffset: INTEGER) =
  VAR t: T := field;
  BEGIN
    t.offset := newOffset;
  END SetOffset;

PROCEDURE <A NAME="EmitDeclaration"><procedure>EmitDeclaration</procedure></A> (field: Value.T) =
  VAR
    t: T := field;
    info : Type.Info;
  BEGIN
    EVAL Type.CheckInfo (t.tipe, info);
    Type.Compile (t.tipe);
    CG.Declare_field (t.name, t.offset, info.size, Type.GlobalUID (t.tipe));
  END EmitDeclaration;

PROCEDURE <A NAME="IsEqual"><procedure>IsEqual</procedure></A> (va, vb: Value.T;  x: Type.Assumption): BOOLEAN =
  VAR a: T := va;  b: T := vb;
  BEGIN
    RETURN (a # NIL) AND (b # NIL)
       AND (a.name = b.name)
       AND (a.index = b.index)
       (*******  only good after it's checked AND (a.offset = b.offset) ****)
       AND Type.IsEqual (TypeOf (a), TypeOf (b), x)
       AND Expr.IsEqual (Expr.ConstValue (a.dfault),
                         Expr.ConstValue (b.dfault));
  END IsEqual;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (t: T): Type.T =
  BEGIN
    IF (t.tipe = NIL) THEN t.tipe := Expr.TypeOf (t.dfault) END;
    RETURN t.tipe;
  END TypeOf;

PROCEDURE <A NAME="TypeCheck"><procedure>TypeCheck</procedure></A> (t: T;  VAR cs: Value.CheckState) =
  VAR info: Type.Info;
  BEGIN
    t.tipe := Type.CheckInfo (TypeOf (t), info);
    IF (info.isEmpty) THEN
      Error.ID (t.name, &quot;empty field type&quot;);
    END;
    IF (info.class = Type.Class.OpenArray) THEN
      Error.ID (t.name, &quot;fields may not be open arrays&quot;);
    END;
    t.checked := TRUE;

    IF (t.dfault # NIL) THEN
      (* check for assignability!! *)
      AssignStmt.Check (t.tipe, t.dfault, cs);
      Expr.TypeCheck (t.dfault, cs);
      IF (Expr.ConstValue (t.dfault) = NIL) THEN
        Error.ID (t.name, &quot;default is not a constant&quot;);
      END;
      (* NOTE: we don't save the constant-folded version of the default,
         otherwise we'd loose references to large named constants. *)
    END;
  END TypeCheck;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (t: T) =
  BEGIN
    Type.Compile (t.tipe);
  END Compile;

PROCEDURE <A NAME="SetGlobals"><procedure>SetGlobals</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    (* Type.SetGlobals (t.tipe); *)
    (* IF (t.dfault # NIL) THEN Type.SetGlobals (Expr.TypeOf (t.dfault)) END; *)
  END SetGlobals;

PROCEDURE <A NAME="AddFPTag"><procedure>AddFPTag</procedure></A>  (t: T;  VAR x: M3.FPInfo): CARDINAL =
  BEGIN
    ValueRep.FPStart (t, x, &quot;FIELD &quot;, 0, global := FALSE);
    IF (t.dfault # NIL) THEN
      M3Buf.PutText (x.buf, &quot; := &quot;);
      Expr.GenFPLiteral (t.dfault, x.buf);
    END;
    RETURN 1;
  END AddFPTag;

BEGIN
END Field.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
