<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/Formal.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/Formal.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Formal.i3                                             
 Last Modified On Mon Dec  5 15:19:54 PST 1994 By kalsow     
      Modified On Wed Feb  7 01:02:52 1990 By muller         

<P><PRE>INTERFACE <interface><A HREF="Formal.m3">Formal</A></interface>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="Value.i3">Value</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../misc/Tracer.i3">Tracer</A>;

TYPE Mode = {mVALUE, mVAR, mCONST};

TYPE
  Info = RECORD
    name   : M3ID.T;
    mode   : Mode;
    offset : INTEGER;
    type   : Type.T;
    dfault : Expr.T;
    unused : BOOLEAN;
    trace  : Tracer.T;
  END;

PROCEDURE <A HREF="Formal.m3#New">New</A> (READONLY info: Info): Value.T;

PROCEDURE <A HREF="Formal.m3#NewBuiltin">NewBuiltin</A> (name: TEXT;  offset: INTEGER;  type: Type.T): Value.T;

PROCEDURE <A HREF="Formal.m3#Split">Split</A> (formal: Value.T;  VAR info: Info);

PROCEDURE <A HREF="Formal.m3#HasClosure">HasClosure</A> (formal: Value.T): BOOLEAN;

PROCEDURE <A HREF="Formal.m3#RefOpenArray">RefOpenArray</A> (formal: Value.T;  VAR ref: Type.T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> if 'formal' is a <CODE>VALUE ARRAY OF X</CODE> formal, sets 'ref' to <CODE>REF ARRAY OF X</CODE>
   and returns TRUE, otherwise returns FALSE. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Formal.m3#CheckArgs">CheckArgs</A> (VAR cs       : Value.CheckState;
                     VAR actuals  : Expr.List;
                         formals  : Value.T;
                         proc     : Expr.T): BOOLEAN;

PROCEDURE <A HREF="Formal.m3#PrepArg">PrepArg</A> (formal: Value.T;  actual: Expr.T);
PROCEDURE <A HREF="Formal.m3#EmitArg">EmitArg</A> (proc: Expr.T;  formal: Value.T;  actual: Expr.T);
</PRE><BLOCKQUOTE><EM> generate code to pass 'actual' as a 'formal'.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Formal.m3#EmitDeclaration">EmitDeclaration</A> (formal: Value.T;  types_only, param: BOOLEAN);

PROCEDURE <A HREF="Formal.m3#GenCopy">GenCopy</A> (t: Type.T);
</PRE><BLOCKQUOTE><EM> Load the address of a temporary that holds the value of type 't'
   that is currently on top of the stack. </EM></BLOCKQUOTE><PRE>

END Formal.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
