<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/Formal.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/Formal.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Formal.m3                                             

<P><PRE>MODULE <module><implements><A HREF="Formal.i3">Formal</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="Value.i3">Value</A>, <A HREF="ValueRep.i3">ValueRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../types/ProcType.i3">ProcType</A>;
IMPORT <A HREF="../exprs/KeywordExpr.i3">KeywordExpr</A>, <A HREF="../types/OpenArrayType.i3">OpenArrayType</A>, <A HREF="../types/RefType.i3">RefType</A>, <A HREF="../exprs/CheckExpr.i3">CheckExpr</A>;
IMPORT <A HREF="../types/ArrayType.i3">ArrayType</A>, <A HREF="../misc/Host.i3">Host</A>, <A HREF="../builtinOps/Narrow.i3">Narrow</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../misc/Tracer.i3">Tracer</A>;
IMPORT <A HREF="Procedure.i3">Procedure</A>, <A HREF="../types/UserProc.i3">UserProc</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>;

TYPE
  T = Value.T BRANDED OBJECT
        offset   : INTEGER;
        tipe     : Type.T;
        dfault   : Expr.T;
        refType  : Type.T;
        cg_type  : CG.TypeUID;
        mode     : Mode;
        kind     : Type.Class;
        trace    : Tracer.T;
      OVERRIDES
        typeCheck   := Check;
        set_globals := SetGlobals;
        load        := Load;
        declare     := ValueRep.Never;
        need_init   := ValueRep.Never;
        lang_init   := Compile;
        user_init   := ValueRep.NoInit;
	toExpr      := ValueRep.NoExpr;
	toType      := ValueRep.NoType;
        typeOf      := TypeOf;
        base        := ValueRep.Self;
        add_fp_tag  := AddFPTag;
        fp_type     := TypeOf;
      END;

TYPE
  ArgSlot = RECORD
    formal  : T;
    actual  : Expr.T;
    name    : M3ID.T;
    matched : BOOLEAN;
    errored : BOOLEAN;
  END;

PROCEDURE <A NAME="NewBuiltin"><procedure>NewBuiltin</procedure></A> (name: TEXT;  offset: INTEGER;  type: Type.T): Value.T =
  VAR t := NEW (T);
  BEGIN
    ValueRep.Init (t, M3ID.Add (name), Value.Class.Formal);
    t.readonly := FALSE;
    t.offset   := offset;
    t.mode     := Mode.mVALUE;
    t.tipe     := type;
    t.dfault   := NIL;
    t.unused   := FALSE;
    t.kind     := Type.Class.Error;
    t.refType  := NIL;
    t.cg_type  := 0;
    t.trace    := NIL;
    RETURN t;
  END NewBuiltin;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (READONLY info: Info): Value.T =
  VAR t := NEW (T);
  BEGIN
    ValueRep.Init (t, info.name, Value.Class.Formal);
    t.readonly := (info.mode = Mode.mCONST);
    t.offset   := info.offset;
    t.mode     := info.mode;
    t.tipe     := info.type;
    t.dfault   := info.dfault;
    t.unused   := info.unused;
    t.kind     := Type.Class.Error;
    t.refType  := NIL;
    t.cg_type  := 0;
    t.trace    := info.trace;
    RETURN t;
  END New;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (formal: Value.T;  VAR info: Info) =
  VAR t: T := formal;
  BEGIN
    info.name   := t.name;
    info.offset := t.offset;
    info.mode   := t.mode;
    info.type   := TypeOf (t);
    info.dfault := t.dfault;
    info.unused := t.unused;
    info.trace  := t.trace;
  END Split;

PROCEDURE <A NAME="EmitDeclaration"><procedure>EmitDeclaration</procedure></A> (formal: Value.T;  types_only, param: BOOLEAN) =
  VAR
    t     : T := formal;
    type  : Type.T;
    mtype : CG.Type;
    size  : CG.Size;
    align : CG.Alignment;
    info  : Type.Info;
  BEGIN
    IF (types_only) THEN
      type := TypeOf (t);
      Type.Compile (type);
      t.cg_type := Type.GlobalUID (type);
      IF (t.mode # Mode.mVALUE) OR (t.refType # NIL) THEN
        t.cg_type := CG.Declare_indirect (t.cg_type);
        Type.Compile (t.refType);
      END;
    ELSIF (param) THEN
      type  := TypeOf (t);
      IF (t.mode = Mode.mVALUE) AND (t.refType = NIL) THEN
        EVAL Type.CheckInfo (type, info);
        size  := info.size;
        align := info.alignment;
        mtype := info.cg_type;
      ELSE
        size  := Target.Address.size;
        align := Target.Address.align;
        mtype := CG.Type.Addr;
      END;
      EVAL CG.Declare_param (t.name, size, align, mtype,
                             t.cg_type, in_memory := FALSE, up_level := FALSE,
                             f := CG.Maybe);
    ELSE
      CG.Declare_formal (t.name, t.cg_type);
    END;
  END EmitDeclaration;

PROCEDURE <A NAME="HasClosure"><procedure>HasClosure</procedure></A> (formal: Value.T): BOOLEAN =
  BEGIN
    TYPECASE formal OF
    | NULL =&gt; RETURN FALSE;
    | T(t) =&gt; RETURN (t.mode = Mode.mVALUE)
                 AND ((t.kind = Type.Class.Procedure)
                      OR ProcType.Is (Type.Base (TypeOf (t))));
    ELSE      RETURN FALSE;
    END;
  END HasClosure;

PROCEDURE <A NAME="RefOpenArray"><procedure>RefOpenArray</procedure></A> (formal: Value.T;  VAR ref: Type.T): BOOLEAN =
  BEGIN
    TYPECASE formal OF
    | NULL =&gt; RETURN FALSE;
    | T(t) =&gt; ref := t.refType;  RETURN (ref # NIL);
    ELSE      RETURN FALSE;
    END;
  END RefOpenArray;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (t: T): Type.T =
  BEGIN
    IF (t.tipe = NIL) THEN t.tipe := Expr.TypeOf (t.dfault) END;
    RETURN t.tipe;
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (t: T;  VAR cs: Value.CheckState) =
  VAR info: Type.Info;
  BEGIN
    t.tipe := Type.CheckInfo (TypeOf (t), info);
    t.kind := info.class;
    IF (info.class = Type.Class.Packed) THEN
      EVAL Type.CheckInfo (Type.Base (t.tipe), info);
      t.kind := info.class;
    END;

    IF (t.dfault # NIL) THEN
      Expr.TypeCheck (t.dfault, cs);
      IF (t.mode = Mode.mVAR) THEN
        Error.ID (t.name, &quot;VAR parameters cannot have defaults&quot;);
      END;
      IF  NOT Type.IsAssignable (t.tipe, Expr.TypeOf (t.dfault)) THEN
        Error.ID (t.name, &quot;default is not assignable to formal&quot;);
      END;
      IF (Expr.ConstValue (t.dfault) = NIL) THEN
        Error.ID (t.name, &quot;default is not constant&quot;);
      END;
      (* NOTE: we don't save the constant-folded version of the default,
         otherwise we'd loose references to large named constants. *)
    END;

    IF (t.mode = Mode.mVALUE) AND OpenArrayType.Is (Type.Base (t.tipe)) THEN
      t.refType := RefType.New (t.tipe, traced := TRUE, brand := NIL);
      t.refType := Type.Check (t.refType);
    END;

  END Check;

PROCEDURE <A NAME="Load"><procedure>Load</procedure></A> (t: T) =
  BEGIN
    IF (t.dfault = NIL) THEN
      Error.ID (t.name, &quot;formal has no default value&quot;);
    END;
    Expr.Prep (t.dfault);
    Expr.Compile (t.dfault);
  END Load;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (t: T) =
  BEGIN
    Type.Compile (t.tipe);
    Type.Compile (t.refType);
    IF (t.dfault # NIL) THEN
      Type.Compile (Expr.TypeOf (t.dfault));
    END;
  END Compile;

PROCEDURE <A NAME="SetGlobals"><procedure>SetGlobals</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    (* Type.SetGlobals (t.tipe); *)
    (* Type.SetGlobals (t.refType); *)
    (* IF (t.dfault # NIL) THEN Type.SetGlobals (Expr.TypeOf (t.dfault)) END; *)
  END SetGlobals;

PROCEDURE <A NAME="AddFPTag"><procedure>AddFPTag</procedure></A>  (t: T;  VAR x: M3.FPInfo): CARDINAL =
  CONST Tags = ARRAY Mode OF TEXT { &quot;VALUE &quot;, &quot;VAR &quot;, &quot;READONLY &quot;};
  BEGIN
    ValueRep.FPStart (t, x, Tags[t.mode], 0, global := FALSE);
    IF (t.dfault # NIL) THEN
      M3Buf.PutText (x.buf, &quot; := &quot;);
      Expr.GenFPLiteral (t.dfault, x.buf);
    END;
    RETURN 1;
  END AddFPTag;
</PRE>--------------------------------------------------- actual typechecking ---

<P><PRE>PROCEDURE <A NAME="CheckArgs"><procedure>CheckArgs</procedure></A> (VAR cs       : Value.CheckState;
                     VAR actuals  : Expr.List;
                         formals  : Value.T;
                         proc     : Expr.T): BOOLEAN =
  VAR slots: ARRAY [0..19] OF ArgSlot;  v: Value.T;  n: INTEGER;
  BEGIN
    v := formals;  n := 0;
    WHILE (v # NIL) DO  INC (n);  v := v.next;  END;
    IF (n &lt;= NUMBER (slots))
      THEN RETURN DoCheckArgs (cs, actuals, formals, n, slots, proc);
      ELSE RETURN DoCheckArgs (cs, actuals, formals, n,
                                NEW (REF ARRAY OF ArgSlot, n)^, proc);
    END;
  END CheckArgs;

PROCEDURE <A NAME="DoCheckArgs"><procedure>DoCheckArgs</procedure></A> (VAR cs       : Value.CheckState;
                       VAR actuals  : Expr.List;
                           formals  : Value.T;
                           nFormals : INTEGER;
                       VAR slots    : ARRAY OF ArgSlot;
                           proc     : Expr.T): BOOLEAN =
  VAR
    j                 : INTEGER;
    e, value          : Expr.T;
    index, elt, t, te : Type.T;
    posOK, ok         : BOOLEAN;
    name              : M3ID.T;
    tt                : T;
  BEGIN
    ok := TRUE;

    IF (nFormals &lt; NUMBER (actuals^)) THEN
      Error.Msg (&quot;too many actual parameters&quot; &amp; ProcName (proc));
      ok := FALSE;
    END;

    (* initialize the argument list *)
    tt := formals;
    WHILE (tt # NIL) DO
      WITH z = slots[tt.offset] DO
        z.formal  := tt;
        z.actual  := tt.dfault;
        z.matched := FALSE;
        z.errored := FALSE;
        z.name    := tt.name;
      END;
      tt := tt.next;
    END;

    (* bind the parameters *)
    posOK := TRUE;
    FOR i := 0 TO MIN (LAST (actuals^) , nFormals -1) DO
      e := actuals[i];
      IF KeywordExpr.Split (e, name, value) THEN
        posOK := FALSE;
        e := value;
        j := 0;
        LOOP
          IF (j &gt;= nFormals) THEN
            Error.ID (name, &quot;unknown parameter&quot;);
            ok := FALSE;
            j := i;
            EXIT;
          END;
          IF (slots[j].name = name) THEN EXIT END;
          INC (j);
        END;
      ELSE
        IF (NOT posOK) THEN
          Error.Msg (&quot;positional parameters must precede keyword parameters&quot;
                       &amp; ProcName (proc));
          ok := FALSE;
        END;
        j := i;
      END;
      WITH z = slots[j] DO
        IF (z.matched) THEN
          Err (z, &quot;parameter already specified&quot;);
          ok := FALSE;
        END;
        z.matched := TRUE;
        z.actual := e;
      END;
    END;

    (* check for any unspecified parameters *)
    FOR i := 0 TO nFormals - 1 DO
      IF (slots[i].actual # NIL) THEN slots[i].matched := TRUE END;
      IF NOT slots[i].matched THEN
        Err (slots[i], &quot;parameter not specified&quot;);
        ok := FALSE;
      END;
    END;

    (* typecheck each binding *)
    FOR i := 0 TO nFormals - 1 DO
      e  := slots[i].actual;
      tt := slots[i].formal;
      IF (e # NIL) AND (tt # NIL) THEN
        (* we've got both a formal and an actual *)
        Expr.TypeCheck (e, cs);

        (* try to fold scalar constant values *)
        (* NOTE: if we fold named structured constants, we lose the
             names and hence generate code to build the value... *)
        IF NOT Type.IsStructured (tt.tipe) THEN
          value := Expr.ConstValue (e);
          IF (value # NIL) THEN e := value;  slots[i].actual := e END;
        END;

        te := Expr.TypeOf (e);
        t  := tt.tipe;
        CASE tt.mode OF
        | Mode.mVALUE =&gt;
            IF NOT Type.IsAssignable (t, te) THEN
              Err (slots[i], &quot;incompatible types&quot;);
              ok := FALSE;
            END;
        | Mode.mVAR =&gt;
            IF NOT Expr.IsDesignator (e) THEN
              Err (slots[i], &quot;VAR actual must be a designator&quot;);
              ok := FALSE;
            ELSIF NOT Expr.IsWritable (e) THEN
              Err (slots[i], &quot;VAR actual must be writable&quot;);
              ok := FALSE;
            ELSIF Type.IsEqual (t, te, NIL) THEN
              Expr.NeedsAddress (e);
            ELSIF ArrayType.Split (t, index, elt)
              AND Type.IsAssignable (t, te) THEN
              Expr.NeedsAddress (e);
            ELSE
              Err (slots[i], &quot;incompatible types&quot;);
              ok := FALSE;
            END;
        | Mode.mCONST =&gt;
            IF NOT Type.IsAssignable (t, te) THEN
              Err (slots[i], &quot;incompatible types&quot;);
              ok := FALSE;
            ELSIF NOT Expr.IsDesignator (e) THEN
              (* we'll make a copy when it's generated *)
            ELSIF Type.IsEqual (t, te, NIL) THEN
              Expr.NeedsAddress (e);
            ELSE (* Type.IsAssignable (t, te) *)
              (* we'll make a copy when it's generated *)
            END;
        END; (*case*)
      END; (* if got actual &amp; formal *)
    END; (* for *)

    IF (NOT ok) THEN RETURN FALSE END;

    (* no more possible errors =&gt; build the new argument list *)
    IF (NUMBER (actuals^) # nFormals) THEN
      actuals := NEW (Expr.List, nFormals)
    END;
    FOR i := 0 TO nFormals - 1 DO  actuals[i] := slots[i].actual  END;
    RETURN TRUE;
  END DoCheckArgs;

PROCEDURE <A NAME="Err"><procedure>Err</procedure></A> (VAR slot: ArgSlot;  msg: TEXT) =
  BEGIN
    IF (NOT slot.errored) THEN
      Error.ID (slot.name, msg);
      slot.errored := TRUE;
    END;
  END Err;

PROCEDURE <A NAME="ProcName"><procedure>ProcName</procedure></A> (proc: Expr.T): TEXT =
  VAR v: Value.T;
  BEGIN
    IF (proc # NIL) AND UserProc.IsProcedureLiteral (proc, v) THEN
      RETURN &quot;: &quot; &amp; Value.GlobalName (v, dots := TRUE, with_module := TRUE);
    ELSE
      RETURN &quot;&quot;;
    END;
  END ProcName;
</PRE>----------------------------------------------------------- caller code ---

<P><PRE>PROCEDURE <A NAME="PrepArg"><procedure>PrepArg</procedure></A> (formal: Value.T; actual: Expr.T) =
  VAR t: T := formal;
  BEGIN
    CASE t.mode OF
    | Mode.mVALUE =&gt;
        Expr.Prep (actual);
    | Mode.mVAR =&gt;
        Expr.PrepLValue (actual);
    | Mode.mCONST =&gt;
        IF NOT Type.IsEqual (t.tipe, Expr.TypeOf (actual), NIL) THEN
          Expr.Prep (actual);
        ELSIF Expr.IsDesignator (actual) THEN
          Expr.PrepLValue (actual);
        ELSE (* non-designator, same type *)
          Expr.Prep (actual);
        END;
    END;
  END PrepArg;

PROCEDURE <A NAME="EmitArg"><procedure>EmitArg</procedure></A> (proc: Expr.T;  formal: Value.T; actual: Expr.T) =
  VAR t: T := formal;   is_struct := FALSE;  info: Type.Info;
  BEGIN
    CASE t.kind OF
    | Type.Class.Error, Type.Class.Named, Type.Class.Packed
        =&gt;  &lt;*ASSERT FALSE*&gt;
    | Type.Class.Integer, Type.Class.Enum, Type.Class.Subrange
        =&gt;  GenOrdinal (t, actual);
    | Type.Class.Real, Type.Class.Longreal, Type.Class.Extended
        =&gt;  GenFloat (t, actual);
    | Type.Class.Ref, Type.Class.Object, Type.Class.Opaque
        =&gt;  GenReference (t, actual);
    | Type.Class.Procedure
        =&gt;  GenProcedure (t, actual, proc);
    | Type.Class.Record
        =&gt;  GenRecord (t, actual);  is_struct := TRUE;
    | Type.Class.Set
        =&gt;  GenSet (t, actual);     is_struct := Type.IsStructured (t.tipe);
    | Type.Class.Array
        =&gt;  GenArray (t, actual);   is_struct := TRUE;
    | Type.Class.OpenArray
        =&gt;  GenArray (t, actual);   is_struct := FALSE;
    END;
    IF (t.mode # Mode.mVALUE) THEN
      CG.Pop_param (CG.Type.Addr)
    ELSIF (is_struct) THEN
      EVAL Type.CheckInfo (t.tipe, info);
      CG.Pop_struct (info.size, info.alignment);
    ELSE (* by-value scalar *)
      CG.Pop_param (Type.CGType (t.tipe));
    END;
    IF (t.mode = Mode.mVAR) THEN Expr.NoteWrite (actual); END;
  END EmitArg;

PROCEDURE <A NAME="GenOrdinal"><procedure>GenOrdinal</procedure></A> (t: T;  actual: Expr.T) =
  VAR min, max: Target.Int;  (** constant := Expr.ConstValue (actual); **)
  BEGIN
    (***
      -- we can't fold constant actuals since they may have been precompiled
         and have allocated temporaries that still need to be freed ....
    IF (constant # NIL) THEN actual := constant END;
    ***)
    EVAL Type.GetBounds (t.tipe, min, max);
    CASE t.mode OF
    | Mode.mVALUE =&gt;
        CheckExpr.Emit (actual, min, max);
    | Mode.mVAR =&gt;
        Expr.CompileAddress (actual);
    | Mode.mCONST =&gt;
        IF NOT Type.IsEqual (t.tipe, Expr.TypeOf (actual), NIL) THEN
          CheckExpr.Emit (actual, min, max);
          GenCopy (t.tipe);
        ELSIF Expr.IsDesignator (actual) THEN
          Expr.CompileAddress (actual);
        ELSE (* non-designator, same type *)
          Expr.Compile (actual);
          GenCopy (t.tipe);
        END;
    END;
  END GenOrdinal;

PROCEDURE <A NAME="GenFloat"><procedure>GenFloat</procedure></A> (t: T;  actual: Expr.T) =
  BEGIN
    CASE t.mode OF
    | Mode.mVALUE =&gt;
        Expr.Compile (actual);
    | Mode.mVAR =&gt;
        Expr.CompileAddress (actual);
    | Mode.mCONST =&gt;
        IF Expr.IsDesignator (actual) THEN
          Expr.CompileAddress (actual);
        ELSE
          Expr.Compile (actual);
          GenCopy (t.tipe);
        END;
    END;
  END GenFloat;

PROCEDURE <A NAME="GenReference"><procedure>GenReference</procedure></A> (t: T;  actual: Expr.T) =
  VAR t_actual := Expr.TypeOf (actual);
  BEGIN
    CASE t.mode OF
    | Mode.mVALUE =&gt;
        Expr.Compile (actual);
        IF Host.doNarrowChk THEN Narrow.Emit (t.tipe, t_actual) END;
    | Mode.mVAR =&gt;
        Expr.CompileAddress (actual);
    | Mode.mCONST =&gt;
        IF NOT Type.IsEqual (t.tipe, t_actual, NIL) THEN
          Expr.Compile (actual);
          IF Host.doNarrowChk THEN Narrow.Emit (t.tipe, t_actual) END;
          GenCopy (t.tipe);
        ELSIF Expr.IsDesignator (actual) THEN
          Expr.CompileAddress (actual);
        ELSE
          Expr.Compile (actual);
          GenCopy (t.tipe);
        END;
    END;
  END GenReference;

PROCEDURE <A NAME="GenProcedure"><procedure>GenProcedure</procedure></A> (t: T;  actual: Expr.T;  proc: Expr.T) =
  BEGIN
    CASE t.mode OF
    | Mode.mVALUE =&gt;
        Expr.Compile (actual);
        GenClosure (actual, proc);
    | Mode.mVAR =&gt;
        Expr.CompileAddress (actual);
    | Mode.mCONST =&gt;
        IF Expr.IsDesignator (actual) THEN
          Expr.CompileAddress (actual);
        ELSE
          Expr.Compile (actual);
          GenClosure (actual, proc);
          GenCopy (t.tipe);
        END;
    END;
  END GenProcedure;

PROCEDURE <A NAME="GenClosure"><procedure>GenClosure</procedure></A> (actual: Expr.T;  proc: Expr.T) =
  VAR tmp: CG.Var;  proc_v: Value.T;  n_elts: INTEGER;
    ASIZE := Target.Address.size;
  BEGIN
    IF RequiresClosure (actual, proc_v) THEN
      (* actual is a nested procedure literal passed by value *)
      IF IsExternalProcedure (proc) THEN
        Error.Warn (1, &quot;passing nested procedure to external procedure&quot;);
      END;

      (* allocate space for the closure *)
      n_elts := (M3RT.CL_SIZE + ASIZE - 1) DIV ASIZE;
      tmp := CG.Declare_temp (M3RT.CL_SIZE, Target.Address.align,
                              CG.Type.Struct, in_memory := TRUE);

      (* and fill it in *)
      CG.Store_addr (tmp, M3RT.CL_proc);
      CG.Load_intt  (M3RT.CL_marker_value);
      CG.Store_int (tmp, M3RT.CL_marker);
      Procedure.LoadStaticLink (proc_v);
      CG.Store_addr (tmp, M3RT.CL_frame);
      CG.Load_addr_of_temp (tmp,  0, Target.Address.align);
    END;
  END GenClosure;

PROCEDURE <A NAME="RequiresClosure"><procedure>RequiresClosure</procedure></A> (e: Expr.T;  VAR proc: Value.T): BOOLEAN =
  BEGIN
    RETURN UserProc.IsProcedureLiteral (e, proc) AND Procedure.IsNested (proc);
  END RequiresClosure;

PROCEDURE <A NAME="IsExternalProcedure"><procedure>IsExternalProcedure</procedure></A> (e: Expr.T): BOOLEAN =
  VAR proc: Value.T;
  BEGIN
    RETURN UserProc.IsProcedureLiteral (e, proc) AND Value.IsExternal (proc);
  END IsExternalProcedure;

PROCEDURE <A NAME="GenRecord"><procedure>GenRecord</procedure></A> (t: T;  actual: Expr.T) =
  BEGIN
    &lt;* ASSERT Type.IsEqual (t.tipe, Expr.TypeOf (actual), NIL) *&gt;
    CASE t.mode OF
    | Mode.mVALUE =&gt;
        Expr.Compile (actual);
    | Mode.mVAR =&gt;
        Expr.CompileAddress (actual);
    | Mode.mCONST =&gt;
        IF Expr.IsDesignator (actual) THEN
          Expr.CompileAddress (actual);
        ELSE
          Expr.Compile (actual);
          (* not needed because of the ASSERT above: GenCopy (t.tipe); *)
        END;
    END;
  END GenRecord;

PROCEDURE <A NAME="GenSet"><procedure>GenSet</procedure></A> (t: T;  actual: Expr.T) =
  BEGIN
    &lt;* ASSERT Type.IsEqual (t.tipe, Expr.TypeOf (actual), NIL) *&gt;
    CASE t.mode OF
    | Mode.mVALUE =&gt;
        Expr.Compile (actual);
    | Mode.mVAR =&gt;
        Expr.CompileAddress (actual);
    | Mode.mCONST =&gt;
        IF Expr.IsDesignator (actual) THEN
          Expr.CompileAddress (actual);
        ELSIF Type.IsStructured (t.tipe) THEN
          Expr.Compile (actual);
          (* not needed because of the ASSERT above: GenCopy (t.tipe); *)
        ELSE (* small, non-designator set *)
          Expr.Compile (actual);
          GenCopy (t.tipe);
        END;
    END;
  END GenSet;

PROCEDURE <A NAME="GenArray"><procedure>GenArray</procedure></A> (t: T;  actual: Expr.T) =
  VAR t_actual := Expr.TypeOf (actual);
  BEGIN
    CASE t.mode OF
    | Mode.mVALUE =&gt;
        Expr.Compile (actual);
        ReshapeArray (t.tipe, t_actual);
    | Mode.mVAR =&gt;
        Expr.CompileAddress (actual);
        ReshapeArray (t.tipe, t_actual);
    | Mode.mCONST =&gt;
        IF NOT Type.IsEqual (t.tipe, t_actual, NIL) THEN
          Expr.Compile (actual);
          ReshapeArray (t.tipe, t_actual);
        ELSIF Expr.IsDesignator (actual) THEN
          Expr.CompileAddress (actual);
        ELSE
          Expr.Compile (actual);
        END;
    END;
  END GenArray;

PROCEDURE <A NAME="ReshapeArray"><procedure>ReshapeArray</procedure></A> (tlhs, trhs: Type.T) =
  VAR
    d_lhs, d_rhs: INTEGER;
    index, elt: Type.T;
    tmp: CG.Var;
    rhs: CG.Val;
    b: BOOLEAN;
  BEGIN
    IF Type.IsEqual (tlhs, trhs, NIL) THEN RETURN END;

    d_lhs := OpenArrayType.OpenDepth (tlhs);
    d_rhs := OpenArrayType.OpenDepth (trhs);

    IF (d_lhs = d_rhs) THEN RETURN END;

    (* capture the actual *)
    rhs := CG.Pop ();

    IF (d_lhs &gt; d_rhs) THEN
      (* build a bigger dope vector *)
      tmp := OpenArrayType.DeclareTemp (tlhs);

      (* copy the data pointer *)
      CG.Push (rhs);
      IF (d_rhs &gt; 0) THEN CG.Open_elt_ptr (Target.Byte) END;
      CG.Store_addr (tmp, M3RT.OA_elt_ptr);

      (* fill in the sizes *)
      FOR i := 0 TO d_lhs-1 DO
        b := ArrayType.Split (trhs, index, elt);  &lt;*ASSERT b*&gt;
        IF (index = NIL) THEN
          CG.Push (rhs);
          CG.Open_size (i);
        ELSE
          CG.Load_integer (Type.Number (index));
        END;
        CG.Store_int (tmp, M3RT.OA_sizes + i * Target.Integer.pack);
        trhs := elt;
      END;

      (* leave the result *)
      CG.Load_addr_of_temp (tmp, 0, Target.Address.align);
    ELSE
      &lt;*ASSERT d_lhs &lt; d_rhs *&gt;
      (* check some array bounds;  don't build a smaller dope vector
         just reuse the existing one! *)

      tlhs := OpenArrayType.OpenType (tlhs);
      FOR i := d_lhs TO d_rhs - 1 DO
        b := ArrayType.Split (tlhs, index, elt); &lt;*ASSERT b*&gt;
        &lt;*ASSERT index # NIL*&gt;
        CG.Push (rhs);
        CG.Open_size (i);
        CG.Load_integer (Type.Number (index));
        CG.Check_eq ();
      END;

      (* leave the old dope vector as the result *)
      CG.Push (rhs);
      IF (d_lhs &lt;= 0) THEN CG.Open_elt_ptr (Target.Byte); END;
      CG.Force ();
    END;

    CG.Free (rhs);
  END ReshapeArray;

PROCEDURE <A NAME="GenCopy"><procedure>GenCopy</procedure></A> (type: Type.T) =
  VAR info: Type.Info;  tmp: CG.Var;  id: CG.TypeUID;
  BEGIN
    EVAL Type.CheckInfo (type, info);
    id := Type.GlobalUID (type);
    IF Type.IsStructured (type) THEN
      tmp := CG.Declare_local (M3ID.NoID, info.size, info.alignment,
                               CG.Type.Struct, id, in_memory := TRUE,
                               up_level := FALSE, f := CG.Never);
      CG.Load_addr_of (tmp, 0, info.alignment);
      CG.Swap ();
      CG.Copy (info.size, overlap := FALSE);
    ELSE
      tmp := CG.Declare_local (M3ID.NoID, info.size, info.alignment,
                               info.cg_type, id, in_memory := TRUE,
                               up_level := FALSE, f := CG.Never);
      CG.Store (tmp, 0, info.size, info.alignment, info.cg_type);
    END;
    CG.Load_addr_of (tmp, 0, info.alignment);
  END GenCopy;

BEGIN
END Formal.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
