<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/Ident.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/Ident.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Ident.m3                                              
 Last Modified On Fri Jun 24 15:19:34 PDT 1994 By kalsow     

<P><PRE>MODULE <module><implements><A HREF="Ident.i3">Ident</A></implements></module>;

IMPORT <A HREF="../misc/Token.i3">Token</A>;
FROM <A HREF="../misc/Scanner.i3">Scanner</A> IMPORT MatchID, GetToken, cur;

PROCEDURE <A NAME="ParseList"><procedure>ParseList</procedure></A> (): INTEGER =
  VAR start: INTEGER;
  BEGIN
    IF (stack = NIL) THEN Init () END;
    start := top;
    LOOP
      IF (LAST (stack^) &lt; top) THEN ExpandLists () END;
      offset[top] := cur.offset;
      stack[top] := MatchID ();
      INC (top);
      IF (cur.token # Token.T.tCOMMA) THEN EXIT;  END;
      GetToken (); (* , *)
    END;
    RETURN (top - start);
  END ParseList;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> () =
  BEGIN
    top := 0;
  END Reset;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> () =
  BEGIN
    stack  := NEW (StringList, 100);
    offset := NEW (IntegerList, 100);
  END Init;

PROCEDURE <A NAME="ExpandLists"><procedure>ExpandLists</procedure></A> () =
  VAR newStack  := NEW (StringList, 2 * NUMBER (stack^));
  VAR newOffset := NEW (IntegerList, 2 * NUMBER (offset^));
  BEGIN
    SUBARRAY (newStack^, 0, NUMBER (stack^)) := stack^;
    SUBARRAY (newOffset^, 0, NUMBER (offset^)) := offset^;
    stack  := newStack;
    offset := newOffset;
  END ExpandLists;

BEGIN
END Ident.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
