<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/Method.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/Method.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Method.m3                                             

<P><PRE>MODULE <module><implements><A HREF="Method.i3">Method</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="Value.i3">Value</A>, <A HREF="ValueRep.i3">ValueRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../types/UserProc.i3">UserProc</A>;
IMPORT <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/ProcType.i3">ProcType</A>, <A HREF="Procedure.i3">Procedure</A>, <A HREF="../builtinTypes/Null.i3">Null</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>;

TYPE
  T = Value.T BRANDED OBJECT
        offset    : INTEGER;
        override  : BOOLEAN;
        parent    : Type.T;
        signature : Type.T;
        dfaultE   : Expr.T;
        dfault    : Value.T;
      OVERRIDES
        typeCheck   := Check;
        set_globals := SetGlobals;
        load        := ValueRep.NoLoader;
        declare     := ValueRep.Never;
        need_init   := ValueRep.Never;
        lang_init   := Compile;
        user_init   := ValueRep.NoInit;
	toExpr      := ValueRep.NoExpr;
	toType      := ValueRep.NoType;
        typeOf      := TypeOf;
        base        := ValueRep.Self;
        add_fp_tag  := AddFPTag;
        fp_type     := FPType;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (READONLY info: Info): Value.T =
  VAR t := NEW (T);
  BEGIN
    ValueRep.Init (t, info.name, Value.Class.Method);
    t.readonly   := TRUE;
    t.offset     := info.offset;
    t.override   := info.override;
    t.parent     := info.parent;
    t.signature  := info.signature;
    t.dfaultE    := info.dfault;
    t.dfault     := NIL;
    Scope.Insert (t);
    RETURN t;
  END New;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (method: Value.T;  VAR info: Info): BOOLEAN =
  BEGIN
    TYPECASE method OF
    | NULL =&gt; RETURN FALSE;

    | T(t) =&gt;
              info.name      := t.name;
              info.offset    := t.offset;
              info.parent    := t.parent;
              info.signature := t.signature;
              info.dfault    := t.dfaultE;
              info.override  := t.override;
	      RETURN TRUE;

    ELSE RETURN FALSE;
    END;
  END Split;

PROCEDURE <A NAME="SplitX"><procedure>SplitX</procedure></A> (method: Value.T;  VAR info: Info) =
  VAR b := Split (method, info);
  BEGIN
    &lt;* ASSERT b *&gt;
  END SplitX;

PROCEDURE <A NAME="NoteOverride"><procedure>NoteOverride</procedure></A> (newV, oldV: Value.T) =
  VAR new: T := newV;  old: T := oldV;
  BEGIN
    &lt;* ASSERT new.override *&gt;
    &lt;* ASSERT old.signature # NIL *&gt;
    new.signature := old.signature;
    new.offset    := old.offset;
  END NoteOverride;

PROCEDURE <A NAME="ResolveDefault"><procedure>ResolveDefault</procedure></A> (t: T) =
  VAR default_type: Type.T;
  BEGIN
    IF (t.dfault # NIL) THEN RETURN END;
    IF (t.dfaultE = NIL) THEN RETURN END;
    IF UserProc.IsProcedureLiteral (t.dfaultE, t.dfault) THEN RETURN END;
    default_type := Expr.TypeOf (t.dfaultE);
    IF Type.IsEqual (default_type, Null.T, NIL) THEN
      RETURN; (* ok *)
    ELSIF NOT ProcType.Is (default_type) THEN
      Error.ID (t.name, &quot;default is not a procedure&quot;);
    ELSE
      Error.ID (t.name, &quot;default is not a procedure constant&quot;);
    END;
  END ResolveDefault;

PROCEDURE <A NAME="IsEqual"><procedure>IsEqual</procedure></A> (va, vb: Value.T;  x: Type.Assumption): BOOLEAN =
  VAR a: T := va;  b: T := vb;
  BEGIN
    ResolveDefault (a);
    ResolveDefault (b);
    RETURN (a # NIL) AND (b # NIL)
       AND (a.name = b.name)
       AND (a.override = b.override)
       AND Type.IsEqual (a.signature, b.signature, x)
       AND (Value.Base (a.dfault) = Value.Base (b.dfault)) (*CHEAT, BUG!*);
  END IsEqual;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (t: T;  VAR cs: Value.CheckState) =
  VAR proc: Value.T;  procType: Type.T;
  BEGIN
    IF (t.signature # NIL) THEN
      t.signature := Type.Check (t.signature);
    END;

    IF (t.dfaultE # NIL) THEN
      Expr.TypeCheck (t.dfaultE, cs);
      ResolveDefault (t);
    END;

    proc := t.dfault;
    IF (proc # NIL) THEN
      Value.TypeCheck (proc, cs);
      procType := Value.TypeOf (proc);
      IF (procType = Null.T) THEN
        t.dfault := NIL;
      ELSIF (Value.ClassOf (proc) # Value.Class.Procedure) THEN
        Error.ID (t.name, &quot;default is not a procedure&quot;);
      ELSIF Procedure.IsNested (proc) THEN
        Error.ID (t.name, &quot;default is a nested procedure&quot;);
      ELSIF NOT ProcType.IsCompatible (procType, t.parent, t.signature) THEN
        Error.ID (t.name, &quot;default is incompatible with method type&quot;);
      END;
    END;
  END Check;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (t: T): Type.T =
  BEGIN
    RETURN t.signature;
  END TypeOf;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (t: T) =
  BEGIN
    Type.Compile (t.signature);
  END Compile;

PROCEDURE <A NAME="SetGlobals"><procedure>SetGlobals</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    (* Type.SetGlobals (t.signature); *)
    (* IF (t.dfaultE # NIL) THEN Type.SetGlobals (Expr.TypeOf (t.dfaultE)) END;*)
  END SetGlobals;

PROCEDURE <A NAME="AddFPTag"><procedure>AddFPTag</procedure></A>  (t: T;  VAR x: M3.FPInfo): CARDINAL =
  CONST Tags = ARRAY BOOLEAN OF TEXT { &quot;METHOD &quot;, &quot;OVERRIDE &quot; };
  CONST Cnt = ARRAY BOOLEAN OF INTEGER { 1, 0 };
  BEGIN
    ValueRep.FPStart (t, x, Tags[t.override], 0, global := FALSE);
    IF (t.dfault # NIL) THEN
      M3Buf.PutText (x.buf, &quot; := &quot;);
      Expr.GenFPLiteral (t.dfaultE, x.buf);
    END;
    RETURN Cnt [t.override];
  END AddFPTag;

PROCEDURE <A NAME="FPType"><procedure>FPType</procedure></A> (t: T): Type.T =
  BEGIN
    IF (t.override)
      THEN RETURN NIL;
      ELSE RETURN t.signature;
    END;
  END FPType;

BEGIN
END Method.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
