<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/Module.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/Module.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Module.def                                            

<P><PRE>INTERFACE <interface><A HREF="Module.m3">Module</A></interface>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="Value.i3">Value</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../misc/CG.i3">CG</A>;

TYPE <A HREF="Module.m3#T">T</A> &lt;: Value.T;

PROCEDURE <A HREF="Module.m3#Parse">Parse</A> (interfaceOnly: BOOLEAN := FALSE): T;

PROCEDURE <A HREF="Module.m3#NewDefn">NewDefn</A> (name: TEXT;  safe: BOOLEAN;  syms: Scope.T): T;

PROCEDURE <A HREF="Module.m3#LookUp">LookUp</A> (name: M3ID.T;  internal: BOOLEAN): T;

PROCEDURE <A HREF="Module.m3#ImportRevelations">ImportRevelations</A> (t: T;  source: Value.T);

PROCEDURE <A HREF="Module.m3#TypeCheck">TypeCheck</A> (t: T;  main: BOOLEAN;  VAR cs: Value.CheckState);

PROCEDURE <A HREF="Module.m3#Compile">Compile</A> (t: T);

PROCEDURE <A HREF="Module.m3#IsSafe">IsSafe</A> (): BOOLEAN;
PROCEDURE <A HREF="Module.m3#IsInterface">IsInterface</A> (): BOOLEAN;
PROCEDURE <A HREF="Module.m3#IsExternal">IsExternal</A> (): BOOLEAN;

PROCEDURE <A HREF="Module.m3#ExportScope">ExportScope</A> (t: T): Scope.T;

PROCEDURE <A HREF="Module.m3#Current">Current</A> (): T;

PROCEDURE <A HREF="Module.m3#Name">Name</A> (t: T): M3ID.T;
PROCEDURE <A HREF="Module.m3#Prefix">Prefix</A> (t: T): TEXT;
</PRE><BLOCKQUOTE><EM> t = NIL =&gt; use Current </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Module.m3#CurrentCounter">CurrentCounter</A> (): ARRAY [0..4] OF CHAR;
PROCEDURE <A HREF="Module.m3#SetCurrentCounter">SetCurrentCounter</A> (c: ARRAY [0..4] OF CHAR);

PROCEDURE <A HREF="Module.m3#Allocate">Allocate</A> (size, align: INTEGER;
                    tag: TEXT := NIL;  id: M3ID.T := M3ID.NoID): INTEGER;
</PRE><BLOCKQUOTE><EM> allocate 'size' bits of space with the specified alignment
   in the current module's global data segment.  Return the
   bit offset of allocated data. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Module.m3#GlobalData">GlobalData</A> (t: T): CG.Var;
</PRE><BLOCKQUOTE><EM> returns 't's global data segment.  If 't' is NIL, returns the
   current module's global dat segment.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Module.m3#GetTypeInfo">GetTypeInfo</A> (t: T): Type.ModuleInfo;
</PRE><BLOCKQUOTE><EM> return the global type info for module 't' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Module.m3#VisitImports">VisitImports</A> (v: Visitor);
</PRE><BLOCKQUOTE><EM> Call 'v(m)' for each interface 'm' imported or exported,
   directly or indirectly, by the current module.  Restrictions:
   'v' must be a top-level procedure and may not call 'VisitImports'
   directly or indirectly.  </EM></BLOCKQUOTE><PRE>

TYPE Visitor = PROCEDURE (t: T);

PROCEDURE <A HREF="Module.m3#Reset">Reset</A> ();
PROCEDURE <A HREF="Module.m3#MakeCurrent">MakeCurrent</A> (t: T);
</PRE><BLOCKQUOTE><EM> refresh 't' and its imports for the current compilation </EM></BLOCKQUOTE><PRE>

END Module.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
