<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/Revelation.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/Revelation.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Revelation.m3                                         

<P><PRE>MODULE <module><implements><A HREF="Revelation.i3">Revelation</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="Value.i3">Value</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/OpaqueType.i3">OpaqueType</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="Decl.i3">Decl</A>, <A HREF="../misc/Host.i3">Host</A>;
IMPORT <A HREF="../types/ObjectType.i3">ObjectType</A>, <A HREF="../types/RefType.i3">RefType</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="Module.i3">Module</A>, <A HREF="ValueRep.i3">ValueRep</A>, <A HREF="../misc/CG.i3">CG</A>;
IMPORT <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;
FROM <A HREF="../misc/Scanner.i3">Scanner</A> IMPORT GetToken, Fail, Match, MatchID, cur;

TYPE
  T = BRANDED &quot;Revelation.T&quot; REF RECORD
        home    : Value.T; (* the containing interface or module *)
        env     : Scope.T;
        qid     : M3.QID;
        obj     : Value.T; (* value named by 'qid' in scope 'env' *)
        rhs     : Type.T;  (* REVEAL qid (&lt;:|=) rhs *)
        lhs     : Type.T;  (* == type that corresponds to qid *)
        equal   : BOOLEAN; (* TRUE =&gt; lhs = rhs, FALSE =&gt; lhs &lt;: rhs *)
        checked : BOOLEAN;
        origin  : INTEGER;
      END;

TYPE
  List = BRANDED &quot;Revelation.List&quot; REF RECORD
           next  : List;
	   ident : T;
	   local : BOOLEAN; (* as opposed to inherited *)
           used  : BOOLEAN;
           home  : Value.T; (* External.T that caused the import *)
         END;

TYPE
  Node = BRANDED &quot;Revelation.Node&quot; REF RECORD
           next     : Node;
           key      : Type.T;
           best     : List     := NIL;
           contents : List     := NIL;
           reducing : BOOLEAN  := FALSE;
         END;

TYPE
  HashTable = REF ARRAY OF Node;

REVEAL
  <A NAME="Set">Set</A> = BRANDED &quot;Revelation.Set&quot; REF RECORD
          home   : Value.T    := NIL;
          count  : INTEGER    := 0;
          idents : List       := NIL;
          hash   : HashTable  := NIL;
          (* the visible revelations are in the union of indents and hash *)
        END;

TYPE
  Iterator = RECORD
    cur       : List;
    set       : Set;
    next_list : List;
    next_node : Node;
    next_hash : INTEGER;
    max_hash  : INTEGER;
  END;

VAR top := NewSet (NIL);

PROCEDURE <A NAME="NewSet"><procedure>NewSet</procedure></A> (module: Value.T): Set =
  BEGIN
    RETURN NEW (Set, home := module);
  END NewSet;

PROCEDURE <A NAME="Push"><procedure>Push</procedure></A> (s: Set): Set =
  VAR old := top;
  BEGIN
    &lt;* ASSERT s # NIL *&gt;
    top := s;
    RETURN old;
  END Push;

PROCEDURE <A NAME="Pop"><procedure>Pop</procedure></A> (s: Set) =
  BEGIN
    top := s;
  END Pop;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (READONLY att: Decl.Attributes) =
  TYPE TK = Token.T;
  VAR id, id2: M3ID.T;  loc: INTEGER;
  BEGIN
    IF att.isInline   THEN Error.Msg (&quot;a revelation cannot be inline&quot;); END;
    IF att.isObsolete THEN Error.Msg (&quot;a revelation cannot be obsolete&quot;); END;
    IF att.isUnused   THEN Error.Msg (&quot;a revelation cannot be unused&quot;); END;
    IF att.isExternal THEN
      Error.Msg (&quot;a revelation cannot be external&quot;);
    ELSIF att.callingConv # NIL THEN
      Error.Msg (&quot;a revelation does not have a calling convention&quot;);
    END;

    Match (TK.tREVEAL);
    WHILE (cur.token = TK.tIDENT) DO
      id2 := M3ID.NoID;
      id  := MatchID ();
      IF (cur.token = TK.tDOT) THEN
        GetToken (); (* . *)
        id2 := id;
        id := MatchID ();
      END;
      loc := Scanner.offset;
      CASE cur.token OF
      | TK.tEQUAL =&gt;
          GetToken (); (* = *)
          New (id2, id, Type.Parse (), TRUE, loc);
      | TK.tSUBTYPE =&gt;
          GetToken (); (* &lt;: *)
          New (id2, id, Type.Parse (), FALSE, loc);
      ELSE Fail (&quot;missing \'=\' or \'&lt;:\'&quot;);
      END;
      Match (TK.tSEMI);
    END;
  END Parse;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (module, name: M3ID.T;  rhs: Type.T;  eq: BOOLEAN; loc: INTEGER)=
  VAR t: T;
  BEGIN
    &lt;* ASSERT top.home # NIL *&gt;
    t := NEW (T);
    t.home       := top.home;
    t.qid.module := module;
    t.qid.item   := name;
    t.obj        := NIL;
    t.rhs        := rhs;
    t.lhs        := NIL;
    t.equal      := eq;
    t.checked    := FALSE;
    t.origin     := loc;
    t.env        := Scope.Top ();
    AddOne (t, TRUE, NIL);
  END New;

PROCEDURE <A NAME="Inherit"><procedure>Inherit</procedure></A> (s: Set;  import: Value.T) =
  VAR iter: Iterator;
  BEGIN
    InitIterator (s, iter);
    WHILE Iterate (iter) DO
      IF (iter.cur.local) THEN AddOne (iter.cur.ident, FALSE, import) END;
    END;
  END Inherit;

PROCEDURE <A NAME="AddOne"><procedure>AddOne</procedure></A> (t: T;  isLocal: BOOLEAN;  import: Value.T) =
  VAR y := NEW (List, ident := t, local := isLocal,
                         used := FALSE, home := import);
  BEGIN
    y.next := top.idents;
    top.idents := y;
    INC (top.count);
  END AddOne;

PROCEDURE <A NAME="TypeCheck"><procedure>TypeCheck</procedure></A> (s: Set) =
  VAR l: List;  save, n_buckets: INTEGER;  n: Node;
  BEGIN
    IF (s.count &lt;= 0) THEN RETURN END;

    save := Scanner.offset;

    (* allocate and initialize the hash table *)
    &lt;*ASSERT s.hash = NIL*&gt; (* otherwise we've been checked twice!? *)
    n_buckets := 2 * s.count;
    s.hash := NEW (HashTable, n_buckets);
    FOR i := 0 TO n_buckets - 1 DO s.hash[i] := NIL END;

    (* bind the lhs qid's to types &amp; map them into the hash table *)
    WHILE (s.idents # NIL) DO
      l := s.idents;
      DoBind (l.ident);
      s.idents := l.next;
      HashInsert (s, l);
    END;

    (* type check the lhs and rhs *)
    FOR i := 0 TO n_buckets-1 DO
      n := s.hash[i];
      WHILE (n # NIL) DO
        l := n.contents;
        WHILE (l # NIL) DO DoCheck0 (l.ident); l := l.next;  END;
        n := n.next;
      END;
    END;

    (* type check the lhs and rhs *)
    FOR i := 0 TO n_buckets-1 DO
      n := s.hash[i];
      WHILE (n # NIL) DO
        l := n.contents;
        WHILE (l # NIL) DO DoCheck (l.ident); l := l.next;  END;
        n := n.next;
      END;
    END;

    (* find the strongest revelation for each type *)
    FOR i := 0 TO n_buckets-1 DO
      n := s.hash [i];
      WHILE (n # NIL) DO
        Reduce (s, n.key);
        n := n.next;
      END;
    END;

    Scanner.offset := save;
  END TypeCheck;

PROCEDURE <A NAME="DoBind"><procedure>DoBind</procedure></A> (t: T) =
  VAR obj: Value.T;
  BEGIN
    IF (t.checked) THEN RETURN END;
    Scanner.offset := t.origin;
    obj := Scope.LookUpQID (t.env, t.qid);
    t.obj := obj;
    IF (obj = NIL) THEN
      Error.QID (t.qid, &quot;undefined&quot;);
      t.lhs := t.rhs;
    ELSIF (Value.ClassOf (obj) # Value.Class.Type) THEN
      Error.QID (t.qid, &quot;is not a type&quot;);
      t.lhs := t.rhs;
    ELSE
      t.lhs := Value.ToType (obj);
    END;
    t.lhs := Type.Strip (t.lhs);
  END DoBind;

PROCEDURE <A NAME="HashInsert"><procedure>HashInsert</procedure></A> (s: Set;  l: List) =
  VAR lhs := l.ident.lhs;
  VAR hsh := OpaqueType.UID (lhs) MOD NUMBER (s.hash^);
  VAR n   := s.hash [hsh];
  VAR x: List;
  BEGIN
    (* look for the node that contains l's revelations *)
    LOOP
      IF (n = NIL) THEN
        (* we didn't find a node for this type *)
        n := NEW (Node, next := s.hash[hsh], key := lhs);
        s.hash [hsh] := n;
        EXIT;
      END;
      IF Type.IsEqual (n.key, lhs, NIL) THEN EXIT END;
      n := n.next;
    END;

    (* check for a duplicate revelation (possible because both &quot;IMPORT X&quot;
       and &quot;FROM X IMPORT&quot; are allowed in a single unit.  They cause X's
       revelations to be inherited twice.  sigh. *)
    x := n.contents;
    WHILE (x # NIL) DO
      IF (x.ident = l.ident) THEN (* drop 'l' on the floor *) RETURN END;
      x := x.next;
    END;

    (* add 'l' to the list *)
    l.next := n.contents;
    n.contents := l;
  END HashInsert;

PROCEDURE <A NAME="DoCheck0"><procedure>DoCheck0</procedure></A> (t: T) =
  BEGIN
    Scanner.offset := t.origin;
    t.rhs := Type.Check (t.rhs);
    t.lhs := Type.Check (t.lhs);
  END DoCheck0;

PROCEDURE <A NAME="DoCheck"><procedure>DoCheck</procedure></A> (t: T) =
  VAR  xx: Type.T;  name: TEXT;
  BEGIN
    IF (t.checked) THEN RETURN END;
    Scanner.offset := t.origin;

    IF (NOT OpaqueType.Is (t.lhs)) THEN
      Error.QID (t.qid, &quot;is not an opaque type&quot;);
    ELSIF NOT Type.IsSubtype (t.rhs, OpaqueType.Super (t.lhs)) THEN
      Error.QID (t.qid, &quot;identification is not to a legal subtype&quot;);
    END;

    IF (t.equal) THEN
      xx := Type.Strip (t.rhs);
      IF (xx # t.rhs)
        OR NOT (RefType.IsBranded (xx) OR ObjectType.IsBranded (xx)) THEN
        Error.QID (t.qid, &quot;right-hand side must be a branded type expression&quot;);
        t.rhs := xx;
      END;

      name := Value.GlobalName (t.obj, dots := TRUE, with_module := TRUE);
      IF RefType.Is (t.rhs)
        THEN RefType.NoteRefName (t.rhs, name);
        ELSE ObjectType.NoteRefName (t.rhs, name);
      END;
    END;

    t.checked := TRUE;
  END DoCheck;

PROCEDURE <A NAME="Reduce"><procedure>Reduce</procedure></A> (s: Set;  key: Type.T) =
  VAR x: INTEGER;  n: Node;  best, l: List;
  BEGIN
    IF (key = NIL) THEN RETURN END;
    key := Type.Strip (key);

    x := OpaqueType.UID (key);
    IF (x = 0) THEN
      (* it's not an opaque type *)
      Reduce (s, ObjectType.Super (key));
      RETURN;
    END;
    Reduce (s, OpaqueType.Super (key));

    (* find the hash table node *)
    x := x MOD NUMBER (s.hash^);
    n := s.hash [x];
    LOOP
      IF (n = NIL) THEN RETURN END;
      IF Type.IsEqual (n.key, key, NIL) THEN EXIT END;
      n := n.next;
    END;

    IF (n.reducing) THEN (*recursive call*) RETURN END;
    IF (n.best # NIL) THEN (*done*) RETURN END;
    n.reducing := TRUE;

    (* first, reduce the rhs's *)
    l := n.contents;
    WHILE (l # NIL) DO
      Reduce (s, l.ident.rhs);
      l := l.next;
    END;

    (* finally, search for the best candidate *)
    best := n.contents;
    l := best.next;
    WHILE (l # NIL) DO

      best.ident.rhs := Type.Check (best.ident.rhs);
      l.ident.rhs := Type.Check (l.ident.rhs);
      (* We need these checks since Reduce can be called by
         LookUpAll during an active call to  TypeCheck. *)

      IF Type.IsSubtype (best.ident.rhs, l.ident.rhs) THEN
        (* best is better than l *)
        IF (l.ident.equal) THEN TooStrong (l, best) END;
      ELSIF Type.IsSubtype (l.ident.rhs, best.ident.rhs) THEN
        (* l is better than best *)
        IF (best.ident.equal) THEN TooStrong (best, l) END;
        best := l;
      ELSE (* unrelated revelations! *)
        Scanner.offset := best.ident.origin;
        Error.QID (best.ident.qid, &quot;non-comparable revelation&quot;);
        Scanner.offset := l.ident.origin;
        Error.QID (l.ident.qid, &quot;non-comparable revelation&quot;);
      END;
      l := l.next;
    END;

    n.best := best;
  END Reduce;

PROCEDURE <A NAME="TooStrong"><procedure>TooStrong</procedure></A> (xa, xb: List) =
  (* a.ident.equal *)
  VAR a := xa.ident;  b := xb.ident;
  BEGIN
    &lt;*ASSERT a.equal *&gt;
    IF (b.equal) THEN
      Scanner.offset := a.origin;
      Error.QID (a.qid, &quot;multiple full revelations&quot;);
      Scanner.offset := b.origin;
      Error.QID (b.qid, &quot;multiple full revelations&quot;);
    ELSE
      Scanner.offset := b.origin;
      Error.QID (b.qid, &quot;partial revelation is stronger than full revelation&quot;);
    END;
  END TooStrong;

PROCEDURE <A NAME="LookUp"><procedure>LookUp</procedure></A> (key: Type.T): Type.T =
  VAR h: INTEGER;  x: Type.T;
  BEGIN
    key := Type.Strip (key);
    IF (top.hash # NIL) THEN
      h := OpaqueType.UID (key) MOD NUMBER (top.hash^);
      x := SearchEQ (top.hash [h], key);
      IF (x # NIL) THEN RETURN x END;
    END;
    RETURN SearchListEQ (top.idents, key);
  END LookUp;

PROCEDURE <A NAME="SearchEQ"><procedure>SearchEQ</procedure></A> (n: Node;  key: Type.T): Type.T =
  VAR l: List;  t: T;
  BEGIN
    (* look for the chain header *)
    LOOP
      IF (n = NIL) THEN RETURN NIL END;
      IF Type.IsEqual (n.key, key, NIL) THEN EXIT END;
      n := n.next;
    END;

    (* has it already been reduced? *)
    l := n.best;
    IF (l # NIL) THEN
      t := l.ident;
      IF NOT t.equal THEN RETURN NIL END;
      IF (NOT t.checked) THEN CheckRHS (t) END;
      NoteUse (l);
      RETURN t.rhs;
    END;

    (* no, then search the full list for a match *)
    RETURN SearchListEQ (n.contents, key);
  END SearchEQ;

PROCEDURE <A NAME="SearchListEQ"><procedure>SearchListEQ</procedure></A> (l: List;  key: Type.T): Type.T =
  VAR t: T;
  BEGIN
    WHILE (l # NIL) DO
      t := l.ident;
      &lt;* ASSERT t.lhs # NIL OR t.rhs = NIL *&gt; (* =&gt; LHS is bound *)
      IF (t.equal) AND Type.IsEqual (t.lhs, key, NIL) THEN
        IF (NOT t.checked) THEN CheckRHS (t) END;
        NoteUse (l);
        RETURN t.rhs;
      END;
      l := l.next;
    END;
    RETURN NIL; (* didn't find a full revelation *)
  END SearchListEQ;

PROCEDURE <A NAME="LookUpAll"><procedure>LookUpAll</procedure></A> (key: Type.T;  VAR(*OUT*) x: TypeSet) =
  VAR h: INTEGER;
  BEGIN
    x.cnt := 0;
    x.others := NIL;
    key := Type.Strip (key);
    IF (top.idents # NIL) THEN
      SearchListAll (top.idents, key, x);
    END;
    IF (top.hash # NIL) THEN
      Reduce (top, key);
      h := OpaqueType.UID (key) MOD NUMBER (top.hash^);
      SearchAll (top.hash [h], key, x);
    END;
  END LookUpAll;

PROCEDURE <A NAME="SearchAll"><procedure>SearchAll</procedure></A> (n: Node;  key: Type.T;  VAR x: TypeSet) =
  VAR t: T;
  BEGIN
    (* search the list for a matching node *)
    LOOP
      IF (n = NIL) THEN RETURN END;
      IF Type.IsEqual (n.key, key, NIL) THEN EXIT END;
      n := n.next;
    END;

    IF (n.best # NIL) THEN
      NoteUse (n.best);
      t := n.best.ident;
      &lt;* ASSERT Type.IsEqual (t.lhs, key, NIL) *&gt;
      IF (NOT t.checked) THEN CheckRHS (t) END;
      AddType (x, t.rhs);
    ELSE
      (* we haven't reduced this node yet =&gt; return all possible nodes *)
      SearchListAll (n.contents, key, x);
    END;
  END SearchAll;

PROCEDURE <A NAME="SearchListAll"><procedure>SearchListAll</procedure></A> (l: List;  key: Type.T;  VAR x: TypeSet) =
  VAR t: T;
  BEGIN
    WHILE (l # NIL) DO
      t := l.ident;
      &lt;* ASSERT t.lhs # NIL OR t.rhs = NIL *&gt; (* =&gt; LHS is bound *)
      IF Type.IsEqual (t.lhs, key, NIL) THEN
        NoteUse (l);
        IF (NOT t.checked) THEN CheckRHS (t) END;
        AddType (x, t.rhs);
      END;
      l := l.next;
    END;
  END SearchListAll;

PROCEDURE <A NAME="AddType"><procedure>AddType</procedure></A> (VAR x: TypeSet;  t: Type.T) =
  BEGIN
    IF (x.cnt &lt; NUMBER (x.types)) THEN
      x.types [x.cnt] := t;
      INC (x.cnt);
    ELSE
      x.others := NEW (TypeList, next := x.others, type := t);
    END;
  END AddType;

PROCEDURE <A NAME="NoteUse"><procedure>NoteUse</procedure></A> (l: List) =
  BEGIN
    IF (Scanner.in_main) THEN
      l.used := TRUE;
      IF (l.home # NIL) THEN l.home.used := TRUE END;
    END;
  END NoteUse;

PROCEDURE <A NAME="CheckRHS"><procedure>CheckRHS</procedure></A> (t: T) =
  (* we're doing a lookup while the revelations are being checked... *)
  VAR save := Scanner.offset;
  BEGIN
    t.rhs := Type.Check (t.rhs);
    Scanner.offset := save;
  END CheckRHS;

PROCEDURE <A NAME="Reuse"><procedure>Reuse</procedure></A> (s: Set) =
  VAR iter: Iterator;
  BEGIN
    InitIterator (s, iter);
    WHILE Iterate (iter) DO
      iter.cur.used := FALSE;
    END;
  END Reuse;

PROCEDURE <A NAME="Declare"><procedure>Declare</procedure></A> (s: Set;  VAR full_info, partial_info: INTEGER) =
  VAR l: List;  n_full, n_partial := 0;  iter: Iterator;
  BEGIN
    (* generate the link info for the revelations defined or used here
       and count the exported revelations *)
    InitIterator (s, iter);
    WHILE Iterate (iter) DO
      l := iter.cur;
      IF (l.used) OR (l.local) THEN
        DeclareRevelation (l.ident, l.local, n_full, n_partial);
      END;
    END;

    full_info := 0;
    partial_info := 0;
    IF (n_full &gt; 0) THEN
      full_info := GenList (s, n_full, TRUE);
    END;
    IF (n_partial &gt; 0) THEN
      partial_info := GenList (s, n_partial, FALSE);
    END;
  END Declare;

PROCEDURE <A NAME="GenList"><procedure>GenList</procedure></A> (s: Set;  cnt: INTEGER;  eq: BOOLEAN): INTEGER =
  VAR
    base := Module.Allocate (cnt * M3RT.RV_SIZE + Target.Integer.size,
                             Target.Integer.align, &quot;revelations&quot;);
    offs := base;
    iter : Iterator;
    l    : List;
  BEGIN
    InitIterator (s, iter);
    WHILE Iterate (iter) DO
      l := iter.cur;
      IF (l.local) AND (l.ident.equal = eq) THEN
        CG.Init_intt (offs + M3RT.RV_lhs_id, Target.Integer.size,
                      Type.GlobalUID (l.ident.lhs));
        CG.Init_intt (offs + M3RT.RV_rhs_id, Target.Integer.size,
                      Type.GlobalUID (l.ident.rhs));
        INC (offs, M3RT.RV_SIZE);
      END;
    END;
    RETURN base;
  END GenList;

PROCEDURE <A NAME="DeclareRevelation"><procedure>DeclareRevelation</procedure></A> (t: T;  exported: BOOLEAN;
                             VAR full, partial: INTEGER) =
  VAR
    interface := (NOT exported) OR (Module.IsInterface ());
    lhs_uid   := Type.GlobalUID (t.lhs);
    rhs_uid   := Type.GlobalUID (t.rhs);
  BEGIN
    Value.Declare (t.obj);
    Type.Compile (t.rhs);
    Type.Compile (t.lhs);
    Host.env.note_revelation (t.home.name, interface,
                             lhs_uid, rhs_uid, t.equal, NOT exported);
    IF (exported) THEN
      IF (t.equal) THEN
        CG.Reveal_opaque (lhs_uid, rhs_uid);
        ObjectType.NoteOffsets (t.lhs, t.rhs);
        INC (full);
      ELSE
        INC (partial);
      END;
    END;
  END DeclareRevelation;

PROCEDURE <A NAME="InitIterator"><procedure>InitIterator</procedure></A> (s: Set;  VAR i: Iterator) =
  BEGIN
    i.cur       := NIL;
    i.set       := s;
    i.next_list := s.idents;
    i.next_node := NIL;
    i.next_hash := 0;
    i.max_hash  := 0;
    IF (s.hash # NIL) THEN i.max_hash := NUMBER (s.hash^); END;
  END InitIterator;

PROCEDURE <A NAME="Iterate"><procedure>Iterate</procedure></A> (VAR i: Iterator): BOOLEAN =
  BEGIN
    IF i.next_list # NIL THEN
      i.cur       := i.next_list;
      i.next_list := i.next_list.next;
      RETURN TRUE;
    END;
    IF (i.next_node # NIL) THEN
      i.next_list := i.next_node.contents;
      i.next_node := i.next_node.next;
      RETURN Iterate (i);
    END;
    WHILE (i.next_hash &lt; i.max_hash) AND (i.next_node = NIL) DO
      i.next_node := i.set.hash[i.next_hash];
      INC (i.next_hash);
    END;
    IF (i.next_node # NIL) THEN RETURN Iterate (i); END;
    i.cur := NIL;
    RETURN FALSE;
  END Iterate;

BEGIN
END Revelation.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
