<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/Tipe.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/Tipe.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Tipe.m3                                               
 Last Modified On Tue Dec 20 15:23:35 PST 1994 By kalsow     
      Modified On Tue Nov 27 22:16:56 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="Tipe.i3">Tipe</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="Value.i3">Value</A>, <A HREF="ValueRep.i3">ValueRep</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/OpaqueType.i3">OpaqueType</A>, <A HREF="../misc/WebInfo.i3">WebInfo</A>;
IMPORT <A HREF="../misc/Token.i3">Token</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="Decl.i3">Decl</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="../types/NamedType.i3">NamedType</A>, <A HREF="../types/RefType.i3">RefType</A>, <A HREF="../types/ObjectType.i3">ObjectType</A>;
FROM <A HREF="../misc/Scanner.i3">Scanner</A> IMPORT GetToken, Fail, Match, MatchID, cur;

TYPE
  T = Value.T BRANDED &quot;Tipe.T&quot; OBJECT
        value      : Type.T;
        is_new_ref : BOOLEAN;
      OVERRIDES
        typeCheck   := Check;
        set_globals := SetGlobals;
        load        := ValueRep.NoLoader;
        declare     := Compile;
        need_init   := ValueRep.Never;
        lang_init   := ValueRep.NoInit;
        user_init   := ValueRep.NoInit;
	toExpr      := ValueRep.NoExpr;
	toType      := ToType;
        typeOf      := ValueRep.TypeVoid;
        base        := ValueRep.Self;
        add_fp_tag  := AddFPTag;
        fp_type     := ToType;
      END;

PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (READONLY att: Decl.Attributes) =
  VAR t: T;  id: M3ID.T;
  BEGIN
    IF att.isInline THEN Error.Msg (&quot;a type cannot be inline&quot;); END;
    IF att.isExternal THEN
      Error.Msg (&quot;a type cannot be external&quot;);
    ELSIF att.callingConv # NIL THEN
      Error.Msg (&quot;a type does not have a calling convention&quot;);
    END;

    Match (Token.T.tTYPE);

    WHILE (cur.token = Token.T.tIDENT) DO
      id := MatchID ();
      t := Create (id);
      t.unused := att.isUnused;
      t.obsolete := att.isObsolete;
      Scope.Insert (t);
      CASE cur.token OF
      | Token.T.tEQUAL =&gt;
          GetToken (); (* = *)
	  t.value := Type.Parse ();
      | Token.T.tSUBTYPE =&gt;
          GetToken (); (* &lt;: *)
          t.value := OpaqueType.New (Type.Parse (), t);
      ELSE
          Fail (&quot;missing \'=\' or \'&lt;:\'&quot;);
      END;
      Match (Token.T.tSEMI);
    END;

  END Parse;

PROCEDURE <A NAME="Create"><procedure>Create</procedure></A> (name: M3ID.T): T =
  VAR t: T;
  BEGIN
    t := NEW (T);
    ValueRep.Init (t, name, Value.Class.Type);
    t.readonly   := TRUE;
    t.value      := NIL;
    t.is_new_ref := FALSE;
    RETURN t;
  END Create;

PROCEDURE <A NAME="Define"><procedure>Define</procedure></A> (name: TEXT;  type: Type.T;  reserved: BOOLEAN) =
  VAR t: T;
  BEGIN
    t := Create (M3ID.Add (name));
    t.value := type;
    Scope.Insert (t);
    IF (reserved) THEN Scanner.NoteReserved (t.name, t) END;
  END Define;

PROCEDURE <A NAME="DefineOpaque"><procedure>DefineOpaque</procedure></A> (name: TEXT;  super: Type.T): Type.T =
  VAR t: T;
  BEGIN
    t := Create (M3ID.Add (name));
    Scope.Insert (t);
    t.value := OpaqueType.New (super, t);
    Scanner.NoteReserved (t.name, t);
    RETURN t.value;
  END DefineOpaque;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (t: T;  &lt;*UNUSED*&gt; VAR cs: Value.CheckState) =
  VAR info: Type.Info;  initial := t.value;  qid: M3.QID;  name: TEXT;
  BEGIN
    t.value := Type.CheckInfo (t.value, info);

    IF (NOT t.imported)
      AND ((info.class = Type.Class.Ref) OR (info.class = Type.Class.Object))
      AND (NOT NamedType.Split (initial, qid)) THEN
      name := Value.GlobalName (t, dots := TRUE, with_module := TRUE);
      IF (info.class = Type.Class.Ref)
        THEN RefType.NoteRefName (t.value, name);
        ELSE ObjectType.NoteRefName (t.value, name);
      END;
    END;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (t: T): BOOLEAN =
  VAR uid: INTEGER;  name: TEXT;
  BEGIN
    Type.Compile (t.value);
    IF NOT t.imported THEN
      uid  := Type.GlobalUID (t.value);
      name := Value.GlobalName (t, dots := TRUE, with_module := FALSE);
      CG.Declare_typename (uid, M3ID.Add (name));
      WebInfo.Declare_typename (uid, t);
    END;
    RETURN TRUE;
  END Compile;

PROCEDURE <A NAME="SetGlobals"><procedure>SetGlobals</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    (* Type.SetGlobals (t.value); *)
  END SetGlobals;

PROCEDURE <A NAME="AddFPTag"><procedure>AddFPTag</procedure></A> (t: T; VAR x: M3.FPInfo): CARDINAL =
  BEGIN
    ValueRep.FPStart (t, x, &quot;TYPE &quot;, 0, global := TRUE);
    RETURN 1;
  END AddFPTag;

PROCEDURE <A NAME="ToType"><procedure>ToType</procedure></A> (t: T): Type.T =
  BEGIN
    RETURN t.value;
  END ToType;

BEGIN
END Tipe.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
